/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.query.QueryException;
import oracle.spatial.geometry.JGeometry;

public class GeometryImpl
implements Geometry {
    private JGeometry theGeom;

    GeometryImpl(JGeometry geom) {
        this.theGeom = geom;
    }

    JGeometry getGeom() {
        return this.theGeom;
    }

    @Override
    public double defaultTolerance() {
        return this.theGeom.defaultTolerance();
    }

    @Override
    public String toGeoJson() {
        return this.theGeom.toGeoJson();
    }

    @Override
    public boolean isPolygon() {
        return this.theGeom.getType() == 3;
    }

    @Override
    public double area(QueryException.Location loc) {
        try {
            return this.theGeom.area(this.defaultTolerance());
        }
        catch (Exception e) {
            throw new QueryException(e, loc);
        }
    }

    @Override
    public Geometry buffer(double distance, QueryException.Location loc) {
        try {
            JGeometry bgeom = this.theGeom.buffer(distance);
            return new GeometryImpl(bgeom);
        }
        catch (Exception e) {
            throw new QueryException(e, loc);
        }
    }

    @Override
    public double distance(Geometry g, QueryException.Location loc) {
        try {
            return this.theGeom.distance(((GeometryImpl)g).theGeom, this.theGeom.defaultTolerance(), "TRUE");
        }
        catch (Exception e) {
            throw new QueryException(e, loc);
        }
    }

    @Override
    public boolean interact(Geometry g, QueryException.Location loc) {
        try {
            return this.theGeom.anyInteract(((GeometryImpl)g).theGeom, this.defaultTolerance(), true);
        }
        catch (Exception e) {
            throw new QueryException(e, loc);
        }
    }

    @Override
    public boolean inside(Geometry g, QueryException.Location loc) {
        try {
            return this.theGeom.isInside(((GeometryImpl)g).theGeom, this.defaultTolerance(), "TRUE");
        }
        catch (Exception e) {
            throw new QueryException(e, loc);
        }
    }
}

