/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprCast
extends Expr {
    private Expr theInput;
    private FieldDefImpl theTargetType;
    private ExprType.Quantifier theTargetQuantifier;

    static Expr create(QueryControlBlock qcb, StaticContext sctx, QueryException.Location loc, Expr input, FieldDefImpl targetType, ExprType.Quantifier targetQuant) {
        if (input.getKind() == Expr.ExprKind.CONST) {
            ExprConst constExpr = (ExprConst)input;
            FieldValueImpl val = constExpr.getValue();
            val = CastIter.castValue(val, targetType, loc);
            return new ExprConst(qcb, sctx, loc, val);
        }
        return new ExprCast(qcb, sctx, loc, input, targetType, targetQuant);
    }

    private ExprCast(QueryControlBlock qcb, StaticContext sctx, QueryException.Location loc, Expr input, FieldDefImpl targetType, ExprType.Quantifier targetQuant) {
        super(qcb, sctx, Expr.ExprKind.CAST, loc);
        this.theInput = input;
        this.theInput.addParent(this);
        this.theTargetType = targetType;
        this.theTargetQuantifier = targetQuant;
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
    }

    FieldDefImpl getTargetType() {
        return this.theTargetType;
    }

    ExprType.Quantifier getTargetQuantifier() {
        return this.theTargetQuantifier;
    }

    @Override
    ExprType computeType() {
        return TypeManager.createType(this.theTargetType, this.theTargetQuantifier);
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("CAST (\n");
        formatter.incIndent();
        this.theInput.display(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("AS ");
        this.theTargetType.display(sb, formatter);
        sb.append(this.theTargetQuantifier.toString());
        sb.append("),\n");
    }
}

