/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;

public class SFWIter
extends PlanIter {
    private final PlanIter[] theFromIters;
    private final String[][] theFromVarNames;
    private final PlanIter theWhereIter;
    private final PlanIter[] theColumnIters;
    private final String[] theColumnNames;
    private final int theNumGBColumns;
    private final boolean theDoNullOnEmpty;
    private final int[] theTupleRegs;
    private final FieldDefImpl theTypeDefinition;
    private final PlanIter theOffsetIter;
    private final PlanIter theLimitIter;

    public SFWIter(Expr e, int resultReg, int[] tupleRegs, PlanIter[] fromIters, String[][] fromVarNames, PlanIter whereIter, PlanIter[] columnIters, String[] columnNames, int numGBColumns, boolean nullOnEmpty, PlanIter offsetIter, PlanIter limitIter) {
        super(e, resultReg);
        this.theFromIters = fromIters;
        this.theFromVarNames = fromVarNames;
        this.theWhereIter = whereIter;
        this.theColumnIters = columnIters;
        this.theColumnNames = columnNames;
        this.theNumGBColumns = numGBColumns;
        this.theDoNullOnEmpty = nullOnEmpty;
        this.theTupleRegs = tupleRegs;
        this.theTypeDefinition = e.getType().getDef();
        this.theOffsetIter = offsetIter;
        this.theLimitIter = limitIter;
    }

    SFWIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theTypeDefinition = (FieldDefImpl)SFWIter.deserializeFieldDef(in, serialVersion);
        this.theTupleRegs = SFWIter.deserializeIntArray(in, serialVersion);
        this.theColumnNames = SFWIter.deserializeStringArray(in, serialVersion);
        this.theColumnIters = SFWIter.deserializeIters(in, serialVersion);
        this.theNumGBColumns = serialVersion >= 16 ? in.readInt() : -1;
        if (serialVersion < 12) {
            this.theFromIters = new PlanIter[1];
            this.theFromVarNames = new String[1][];
            this.theFromVarNames[0] = new String[1];
            this.theFromIters[0] = SFWIter.deserializeIter(in, serialVersion);
            this.theFromVarNames[0][0] = SerializationUtil.readString(in, serialVersion);
        } else {
            this.theFromIters = SFWIter.deserializeIters(in, serialVersion);
            this.theFromVarNames = new String[this.theFromIters.length][];
            if (serialVersion < 16) {
                for (int i = 0; i < this.theFromIters.length; ++i) {
                    this.theFromVarNames[i] = new String[1];
                    this.theFromVarNames[i][0] = SerializationUtil.readString(in, serialVersion);
                }
            } else {
                for (int i = 0; i < this.theFromIters.length; ++i) {
                    this.theFromVarNames[i] = PlanIter.deserializeStringArray(in, serialVersion);
                }
            }
        }
        this.theWhereIter = SFWIter.deserializeIter(in, serialVersion);
        this.theOffsetIter = SFWIter.deserializeIter(in, serialVersion);
        this.theLimitIter = SFWIter.deserializeIter(in, serialVersion);
        this.theDoNullOnEmpty = serialVersion < 14 ? true : in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SFWIter.serializeFieldDef(this.theTypeDefinition, out, serialVersion);
        SFWIter.serializeIntArray(this.theTupleRegs, out, serialVersion);
        SFWIter.serializeStringArray(this.theColumnNames, out, serialVersion);
        SFWIter.serializeIters(this.theColumnIters, out, serialVersion);
        if (serialVersion < 16) {
            String QV6String = SerialVersion.getKVVersion((short)16).getNumericVersionString();
            throw new QueryException("Cannot execute a group-by query at a server whose version is less than " + QV6String + "\nserialVersion = " + serialVersion + " expected version = " + 16);
        }
        out.writeInt(this.theNumGBColumns);
        if (serialVersion < 12) {
            String QV2String = SerialVersion.getKVVersion((short)12).getNumericVersionString();
            if (this.theTupleRegs == null) {
                throw new QueryException("Cannot execute a query with a single expression in the SELECT with no associated AS clause at a server whose version is less than " + QV2String + "\nserialVersion = " + serialVersion + " expected version = " + 12);
            }
            if (this.theFromIters.length > 1) {
                throw new QueryException("Cannot execute a query with more than one expression in the FROM clause at a server whose version is less than " + QV2String + "\nserialVersion = " + serialVersion + " expected version = " + 12);
            }
            SFWIter.serializeIter(this.theFromIters[0], out, serialVersion);
            SerializationUtil.writeString(out, serialVersion, this.theFromVarNames[0][0]);
        } else {
            SFWIter.serializeIters(this.theFromIters, out, serialVersion);
            if (serialVersion < 16) {
                for (int i = 0; i < this.theFromIters.length; ++i) {
                    SerializationUtil.writeString(out, serialVersion, this.theFromVarNames[i][0]);
                }
            } else {
                for (int i = 0; i < this.theFromIters.length; ++i) {
                    PlanIter.serializeStringArray(this.theFromVarNames[i], out, serialVersion);
                }
            }
        }
        SFWIter.serializeIter(this.theWhereIter, out, serialVersion);
        SFWIter.serializeIter(this.theOffsetIter, out, serialVersion);
        SFWIter.serializeIter(this.theLimitIter, out, serialVersion);
        if (serialVersion >= 14) {
            out.writeBoolean(this.theDoNullOnEmpty);
        }
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SFW;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theTupleRegs;
    }

    public int getNumColumns() {
        return this.theColumnNames.length;
    }

    public String getColumnName(int i) {
        return this.theColumnNames[i];
    }

    @Override
    public void setIterationHandleNotifier(IterationHandleNotifier iterHandleNotifier) {
        for (PlanIter iter : this.theFromIters) {
            iter.setIterationHandleNotifier(iterHandleNotifier);
        }
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        SFWIterState state = new SFWIterState(this);
        rcb.setState(this.theStatePos, state);
        if (this.theTupleRegs != null) {
            TupleValue tuple = new TupleValue((RecordDefImpl)this.theTypeDefinition, rcb.getRegisters(), this.theTupleRegs);
            rcb.setRegVal(this.theResultReg, tuple);
        }
        for (int i = 0; i < this.theFromIters.length; ++i) {
            this.theFromIters[i].open(rcb);
        }
        if (this.theWhereIter != null) {
            this.theWhereIter.open(rcb);
        }
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.open(rcb);
        }
        this.computeOffsetLimit(rcb);
        ResumeInfo ri = rcb.getResumeInfo();
        if (rcb.isServerRCB() && ri != null && ri.getGBTuple() != null && this.theNumGBColumns >= 0) {
            int i;
            SFWIterState.access$102(state, ri.getGBTuple());
            state.theHaveGBTuple = true;
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Received resume GB tuple:");
                for (i = 0; i < state.theGBTuple.length; ++i) {
                    rcb.trace("Val " + i + " = " + state.theGBTuple[i]);
                }
            }
            for (i = this.theNumGBColumns; i < state.theGBTuple.length; ++i) {
                this.theColumnIters[i].initAggrValue(rcb, state.theGBTuple[i]);
            }
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb, false);
    }

    @Override
    public boolean nextLocal(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb, true);
    }

    private boolean nextInternal(RuntimeControlBlock rcb, boolean localOnly) {
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.theNumResults >= state.theLimit) {
            state.done();
            this.theFromIters[0].reset(rcb);
            return false;
        }
        while (true) {
            boolean more;
            if (!(more = this.computeNextResult(rcb, state, localOnly))) {
                return false;
            }
            if (state.isDone() && state.theOffset > 0L) {
                return false;
            }
            if (state.theOffset == 0L) break;
            --state.theOffset;
        }
        ++state.theNumResults;
        return true;
    }

    boolean computeNextResult(RuntimeControlBlock rcb, SFWIterState state, boolean localOnly) {
        int numCols;
        int i;
        block0: do {
            if (this.theWhereIter != null) {
                boolean whereValue = true;
                do {
                    FieldValueImpl val;
                    if (!this.getNextFROMTuple(rcb, state, localOnly)) {
                        if (this.theNumGBColumns >= 0) {
                            return this.produceLastGroup(rcb, state);
                        }
                        return false;
                    }
                    boolean more = this.theWhereIter.next(rcb);
                    whereValue = !more ? false : ((val = rcb.getRegVal(this.theWhereIter.getResultReg())).isNull() ? false : val.getBoolean());
                    this.theWhereIter.reset(rcb);
                } while (!whereValue);
            } else if (!this.getNextFROMTuple(rcb, state, localOnly)) {
                if (this.theNumGBColumns >= 0) {
                    return this.produceLastGroup(rcb, state);
                }
                return false;
            }
            if (this.theNumGBColumns < 0 && state.theOffset > 0L) {
                return true;
            }
            numCols = this.theNumGBColumns >= 0 ? this.theNumGBColumns : this.theColumnIters.length;
            i = 0;
            if (numCols > 0 && this.theTupleRegs == null) {
                boolean more = this.theColumnIters[0].next(rcb);
                if (!more) {
                    rcb.setRegVal(this.theResultReg, this.theDoNullOnEmpty ? NullValueImpl.getInstance() : EmptyValueImpl.getInstance());
                } else {
                    i = 1;
                }
                this.theColumnIters[0].reset(rcb);
                if (this.theNumGBColumns >= 0) continue;
                return true;
            }
            for (i = 0; i < numCols; ++i) {
                PlanIter columnIter = this.theColumnIters[i];
                boolean more = columnIter.next(rcb);
                if (!more) {
                    if (this.theNumGBColumns > 0) {
                        columnIter.reset(rcb);
                        continue block0;
                    }
                    rcb.setRegVal(this.theTupleRegs[i], this.theDoNullOnEmpty ? NullValueImpl.getInstance() : EmptyValueImpl.getInstance());
                } else {
                    FieldValueImpl value = rcb.getRegVal(columnIter.getResultReg());
                    if (rcb.getTraceLevel() >= 3) {
                        rcb.trace("Value for SFW column " + i + " = " + value);
                    }
                    if (value.isTuple()) {
                        value = ((TupleValue)value).toRecord();
                        rcb.setRegVal(this.theTupleRegs[i], value);
                    }
                }
                columnIter.reset(rcb);
            }
        } while (i < numCols || this.theNumGBColumns >= 0 && !this.groupInputTuple(rcb, state));
        return true;
    }

    private boolean getNextFROMTuple(RuntimeControlBlock rcb, SFWIterState state, boolean localOnly) {
        while (0 <= state.theNumBoundVars && state.theNumBoundVars < this.theFromIters.length) {
            boolean hasNext;
            PlanIter fromIter = this.theFromIters[state.theNumBoundVars];
            if (localOnly) {
                hasNext = fromIter.nextLocal(rcb);
                if (!hasNext && !fromIter.isClosed(rcb)) {
                    return false;
                }
            } else {
                hasNext = fromIter.next(rcb);
            }
            if (!hasNext) {
                fromIter.reset(rcb);
                --state.theNumBoundVars;
                if (!rcb.isServerRCB() || !rcb.getReachedLimit() || this.theNumGBColumns < 0 || !state.theHaveGBTuple) continue;
                int numCols = this.theColumnIters.length;
                for (int i = this.theNumGBColumns; i < numCols; ++i) {
                    ((SFWIterState)state).theGBTuple[i] = this.theColumnIters[i].getAggrValue(rcb, false);
                }
                rcb.getResumeInfo().setGBTuple(state.theGBTuple);
                continue;
            }
            ++state.theNumBoundVars;
        }
        if (state.theNumBoundVars < 0) {
            state.done();
            return false;
        }
        --state.theNumBoundVars;
        return true;
    }

    boolean groupInputTuple(RuntimeControlBlock rcb, SFWIterState state) {
        int i;
        int i2;
        FieldValueImpl curval;
        FieldValueImpl newval;
        int j;
        int numCols = this.theColumnIters.length;
        if (!state.theHaveGBTuple) {
            int i3;
            for (i3 = 0; i3 < this.theNumGBColumns; ++i3) {
                ((SFWIterState)state).theGBTuple[i3] = rcb.getRegVal(this.theColumnIters[i3].getResultReg());
            }
            for (i3 = this.theNumGBColumns; i3 < numCols; ++i3) {
                this.theColumnIters[i3].next(rcb);
                this.theColumnIters[i3].reset(rcb);
            }
            state.theHaveGBTuple = true;
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Started first group:");
                this.traceCurrentGroup(rcb, state);
            }
            return false;
        }
        for (j = 0; j < this.theNumGBColumns && (newval = rcb.getRegVal(this.theColumnIters[j].getResultReg())).equals(curval = state.theGBTuple[j]); ++j) {
        }
        if (j == this.theNumGBColumns) {
            for (int i4 = this.theNumGBColumns; i4 < numCols; ++i4) {
                this.theColumnIters[i4].next(rcb);
                this.theColumnIters[i4].reset(rcb);
            }
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Input tuple belongs to current group:");
                this.traceCurrentGroup(rcb, state);
            }
            return false;
        }
        for (i2 = this.theNumGBColumns; i2 < numCols; ++i2) {
            ((SFWIterState)state).theGBTuple[i2] = this.theColumnIters[i2].getAggrValue(rcb, true);
        }
        for (i2 = 0; i2 < this.theNumGBColumns; ++i2) {
            ((SFWIterState)state).theSwapGBTuple[i2] = rcb.getRegVal(this.theColumnIters[i2].getResultReg());
        }
        FieldValueImpl[] temp = state.theSwapGBTuple;
        SFWIterState.access$702(state, state.theGBTuple);
        SFWIterState.access$102(state, temp);
        for (i = this.theNumGBColumns; i < numCols; ++i) {
            this.theColumnIters[i].next(rcb);
            this.theColumnIters[i].reset(rcb);
            ((SFWIterState)state).theGBTuple[i] = this.theColumnIters[i].getAggrValue(rcb, false);
        }
        for (i = 0; i < numCols; ++i) {
            rcb.setRegVal(this.theColumnIters[i].getResultReg(), state.theSwapGBTuple[i]);
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("Started new group:");
            this.traceCurrentGroup(rcb, state);
        }
        if (rcb.isServerRCB()) {
            rcb.getResumeInfo().setGBTuple(state.theGBTuple);
        }
        return true;
    }

    boolean produceLastGroup(RuntimeControlBlock rcb, SFWIterState state) {
        int i;
        if (rcb.getReachedLimit()) {
            if (rcb.isServerRCB()) {
                return false;
            }
            ResumeInfo ri = rcb.getResumeInfo();
            FieldValueImpl[] rnGBTuple = ri.getGBTuple();
            FieldValueImpl[] clGBTuple = state.theGBTuple;
            if (this.theNumGBColumns == 0) {
                if (rcb.getContinuationKey() != null) {
                    for (int i2 = 0; i2 < this.theColumnIters.length; ++i2) {
                        PlanIter aggrIter = this.theColumnIters[i2];
                        if (rnGBTuple == null) {
                            clGBTuple[i2] = aggrIter.getAggrValue(rcb, true);
                            continue;
                        }
                        rcb.setRegVal(aggrIter.getInputIter().getResultReg(), rnGBTuple[i2]);
                        aggrIter.next(rcb);
                        clGBTuple[i2] = aggrIter.getAggrValue(rcb, true);
                    }
                    ri.setGBTuple(clGBTuple);
                    rcb.createContinuationKey();
                    return false;
                }
            } else if (rnGBTuple != null) {
                FieldValueImpl curval;
                FieldValueImpl newval;
                int j;
                for (j = 0; j < this.theNumGBColumns && (newval = rnGBTuple[j]).equals(curval = clGBTuple[j]); ++j) {
                }
                if (j == this.theNumGBColumns) {
                    return false;
                }
            }
        }
        if (!state.theHaveGBTuple) {
            if (this.theNumGBColumns > 0) {
                return false;
            }
            if (!rcb.isServerRCB()) {
                throw new QueryStateException("Unexpected method call");
            }
            for (int i3 = 0; i3 < this.theColumnIters.length; ++i3) {
                PlanIter aggrIter = this.theColumnIters[i3];
                if (aggrIter.getKind() == PlanIter.PlanIterKind.FUNC_COUNT || aggrIter.getKind() == PlanIter.PlanIterKind.FUNC_COUNT_STAR) {
                    rcb.setRegVal(aggrIter.getResultReg(), LongValueImpl.ZERO);
                    continue;
                }
                rcb.setRegVal(aggrIter.getResultReg(), NullValueImpl.getInstance());
            }
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Produced empty group:");
                this.traceCurrentGroup(rcb, state);
            }
            rcb.getResumeInfo().setGBTuple(null);
            return true;
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("Produced last group:");
            this.traceCurrentGroup(rcb, state);
        }
        for (i = 0; i < this.theNumGBColumns; ++i) {
            rcb.setRegVal(this.theColumnIters[i].getResultReg(), state.theGBTuple[i]);
        }
        for (i = this.theNumGBColumns; i < this.theColumnIters.length; ++i) {
            rcb.setRegVal(this.theColumnIters[i].getResultReg(), this.theColumnIters[i].getAggrValue(rcb, true));
        }
        if (rcb.isServerRCB()) {
            rcb.getResumeInfo().setGBTuple(null);
        }
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (int i = 0; i < this.theFromIters.length; ++i) {
            this.theFromIters[i].reset(rcb);
        }
        if (this.theWhereIter != null) {
            this.theWhereIter.reset(rcb);
        }
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.reset(rcb);
        }
        if (this.theOffsetIter != null) {
            this.theOffsetIter.reset(rcb);
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.reset(rcb);
        }
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        state.reset(this);
        this.computeOffsetLimit(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (int i = 0; i < this.theFromIters.length; ++i) {
            this.theFromIters[i].close(rcb);
        }
        if (this.theWhereIter != null) {
            this.theWhereIter.close(rcb);
        }
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.close(rcb);
        }
        if (this.theOffsetIter != null) {
            this.theOffsetIter.close(rcb);
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.close(rcb);
        }
        state.close();
    }

    private void computeOffsetLimit(RuntimeControlBlock rcb) {
        FieldValueImpl val;
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        long offset = 0L;
        long limit = -1L;
        if (this.theOffsetIter != null) {
            this.theOffsetIter.open(rcb);
            this.theOffsetIter.next(rcb);
            val = rcb.getRegVal(this.theOffsetIter.getResultReg());
            offset = val.getLong();
            if (offset < 0L) {
                throw new QueryException("Offset can not be a negative number", this.theOffsetIter.theLocation);
            }
            if (offset > Integer.MAX_VALUE) {
                throw new QueryException("Offset can not be greater than Integer.MAX_VALUE", this.theOffsetIter.theLocation);
            }
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.open(rcb);
            this.theLimitIter.next(rcb);
            val = rcb.getRegVal(this.theLimitIter.getResultReg());
            limit = val.getLong();
            if (limit < 0L) {
                throw new QueryException("Limit can not be a negative number", this.theLimitIter.theLocation);
            }
            if (limit > Integer.MAX_VALUE) {
                throw new QueryException("Limit can not be greater than Integer.MAX_VALUE", this.theOffsetIter.theLocation);
            }
        }
        long numResultsComputed = 0L;
        if (rcb.getResumeInfo() != null) {
            numResultsComputed = rcb.getResumeInfo().getNumResultsComputed();
        }
        limit = limit < 0L ? Long.MAX_VALUE : (limit -= numResultsComputed);
        if (numResultsComputed > 0L) {
            offset = 0L;
        }
        state.theOffset = offset;
        state.theLimit = limit;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        for (i = 0; i < this.theFromIters.length; ++i) {
            formatter.indent(sb);
            sb.append("FROM:\n");
            this.theFromIters[i].display(sb, formatter);
            sb.append(" as");
            for (String vname : this.theFromVarNames[i]) {
                sb.append(" " + vname);
            }
            sb.append("\n\n");
        }
        if (this.theWhereIter != null) {
            formatter.indent(sb);
            sb.append("WHERE:\n");
            this.theWhereIter.display(sb, formatter);
            sb.append("\n\n");
        }
        if (this.theNumGBColumns >= 0) {
            formatter.indent(sb);
            sb.append("GROUP BY:\n");
            formatter.indent(sb);
            if (this.theNumGBColumns == 0) {
                sb.append("No grouping expressions");
            } else if (this.theNumGBColumns == 1) {
                sb.append("Grouping by the first expression in the SELECT list");
            } else {
                sb.append("Grouping by the first " + this.theNumGBColumns + " expressions in the SELECT list");
            }
            sb.append("\n\n");
        }
        formatter.indent(sb);
        sb.append("SELECT:\n");
        for (i = 0; i < this.theColumnIters.length; ++i) {
            this.theColumnIters[i].display(sb, formatter);
            if (i >= this.theColumnIters.length - 1) continue;
            sb.append(",\n");
        }
        if (this.theOffsetIter != null) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("OFFSET:\n");
            this.theOffsetIter.display(sb, formatter);
        }
        if (this.theLimitIter != null) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("LIMIT:\n");
            this.theLimitIter.display(sb, formatter);
        }
    }

    void traceCurrentGroup(RuntimeControlBlock rcb, SFWIterState state) {
        int i;
        for (i = 0; i < this.theNumGBColumns; ++i) {
            rcb.trace("Val " + i + " = " + state.theGBTuple[i]);
        }
        for (i = this.theNumGBColumns; i < this.theColumnIters.length; ++i) {
            rcb.trace("Val " + i + " = " + this.theColumnIters[i].getAggrValue(rcb, false));
        }
    }

    public static class SFWIterState
    extends PlanIterState {
        private int theNumBoundVars;
        private long theOffset;
        private long theLimit;
        private long theNumResults;
        private FieldValueImpl[] theGBTuple;
        private FieldValueImpl[] theSwapGBTuple;
        private boolean theHaveGBTuple;

        SFWIterState(SFWIter iter) {
            this.theGBTuple = new FieldValueImpl[iter.theColumnIters.length];
            this.theSwapGBTuple = new FieldValueImpl[iter.theColumnIters.length];
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theNumBoundVars = 0;
            this.theNumResults = 0L;
            this.theHaveGBTuple = false;
        }

        static /* synthetic */ FieldValueImpl[] access$102(SFWIterState x0, FieldValueImpl[] x1) {
            x0.theGBTuple = x1;
            return x1;
        }

        static /* synthetic */ FieldValueImpl[] access$702(SFWIterState x0, FieldValueImpl[] x1) {
            x0.theSwapGBTuple = x1;
            return x1;
        }
    }
}

