/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class ExprRecConstr
extends Expr {
    final RecordDefImpl theDef;
    final ArrayList<Expr> theArgs;

    ExprRecConstr(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, RecordDefImpl def, ArrayList<Expr> args) {
        super(qcb, sctx, Expr.ExprKind.REC_CONSTR, location);
        this.theDef = def;
        this.theArgs = args;
    }

    @Override
    int getNumChildren() {
        return this.theArgs.size();
    }

    public RecordDefImpl getDef() {
        return this.theDef;
    }

    int getNumArgs() {
        return this.theArgs.size();
    }

    Expr getArg(int i) {
        return this.theArgs.get(i);
    }

    void setArg(int i, Expr newExpr, boolean destroy) {
        this.theArgs.get(i).removeParent(this, destroy);
        FieldDefImpl argType = newExpr.getType().getDef();
        if (!argType.isSubtype(this.theDef)) {
            throw new QueryException("Type:\n" + argType.getDDLString() + "\nis not a subtype of\n" + this.theDef.getDDLString(), this.theLocation);
        }
        this.theArgs.set(i, newExpr);
        newExpr.addParent(this);
    }

    @Override
    public boolean mayReturnNULL() {
        return false;
    }

    @Override
    ExprType computeType() {
        return TypeManager.createType(this.theDef, ExprType.Quantifier.ONE);
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        sb.append("type = \n");
        this.theDef.display(sb, formatter);
        for (int i = 0; i < this.theArgs.size(); ++i) {
            this.theArgs.get(i).display(sb, formatter);
            if (i >= this.theArgs.size() - 1) continue;
            sb.append(",\n");
        }
    }
}

