/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.FieldValue;

public class UpdateFieldIter
extends PlanIter {
    private final Expr.UpdateKind theUpdateKind;
    private final PlanIter theInputIter;
    private final PlanIter thePosIter;
    private final PlanIter theNewValueIter;
    private final int theTargetItemReg;
    private final boolean theCloneNewValues;

    public UpdateFieldIter(Expr e, Expr.UpdateKind kind, PlanIter inputIter, PlanIter posIter, PlanIter newValueIter, int targetItemReg, boolean cloneNewValues) {
        super(e, -1);
        this.theUpdateKind = kind;
        this.theInputIter = inputIter;
        this.thePosIter = posIter;
        this.theNewValueIter = newValueIter;
        this.theTargetItemReg = targetItemReg;
        this.theCloneNewValues = cloneNewValues;
    }

    public UpdateFieldIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = UpdateFieldIter.readOrdinal(in, Expr.UpdateKind.values().length);
        this.theUpdateKind = Expr.UpdateKind.values()[ordinal];
        this.theInputIter = UpdateFieldIter.deserializeIter(in, serialVersion);
        this.thePosIter = UpdateFieldIter.deserializeIter(in, serialVersion);
        this.theNewValueIter = UpdateFieldIter.deserializeIter(in, serialVersion);
        this.theTargetItemReg = UpdateFieldIter.readPositiveInt(in, true);
        this.theCloneNewValues = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theUpdateKind.ordinal());
        UpdateFieldIter.serializeIter(this.theInputIter, out, serialVersion);
        UpdateFieldIter.serializeIter(this.thePosIter, out, serialVersion);
        UpdateFieldIter.serializeIter(this.theNewValueIter, out, serialVersion);
        out.writeInt(this.theTargetItemReg);
        out.writeBoolean(this.theCloneNewValues);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.UPDATE_FIELD;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new UpdateFieldState());
        this.theInputIter.open(rcb);
        if (this.thePosIter != null) {
            this.thePosIter.open(rcb);
        }
        if (this.theNewValueIter != null) {
            this.theNewValueIter.open(rcb);
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        if (this.thePosIter != null) {
            this.thePosIter.close(rcb);
        }
        if (this.theNewValueIter != null) {
            this.theNewValueIter.close(rcb);
        }
        state.close();
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        if (this.thePosIter != null) {
            this.thePosIter.reset(rcb);
        }
        if (this.theNewValueIter != null) {
            this.theNewValueIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        UpdateFieldState state = (UpdateFieldState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInputIter.next(rcb);
        if (!more) {
            state.done();
            return false;
        }
        boolean updated = false;
        block6: while (more) {
            int inputReg = this.theInputIter.getResultReg();
            FieldValueImpl targetItem = rcb.getRegVal(inputReg);
            switch (this.theUpdateKind) {
                case SET: {
                    if (!this.doSet(rcb, state, targetItem)) break;
                    updated = true;
                    break;
                }
                case ADD: {
                    if (!this.doAdd(rcb, targetItem)) break;
                    updated = true;
                    break;
                }
                case PUT: {
                    if (!this.doPut(rcb, targetItem)) break;
                    updated = true;
                    break;
                }
                case REMOVE: {
                    FieldValueImpl savedParentItem = state.theParentItemContext.theParentItem;
                    this.theInputIter.getParentItemContext(rcb, state.theParentItemContext);
                    FieldValueImpl parentItem = state.theParentItemContext.theParentItem;
                    int targetPos = state.theParentItemContext.theTargetPos;
                    String targetKey = state.theParentItemContext.theTargetKey;
                    if (rcb.getTraceLevel() >= 3) {
                        rcb.trace("Removing item :\n" + targetItem + "\nfrom parent item :\n" + parentItem);
                    }
                    if (parentItem.isRecord()) {
                        throw new QueryException("Cannot remove fields from records.\nField " + targetKey + "\nRecord:\n" + parentItem, this.theLocation);
                    }
                    if (parentItem.isNull()) continue block6;
                    if (savedParentItem == null || savedParentItem == parentItem) {
                        if (targetKey != null) {
                            assert (parentItem.isMap());
                            state.theKeysToRemove.add(targetKey);
                            break;
                        }
                        assert (parentItem.isArray());
                        state.thePositionsToRemove.add(targetPos);
                        break;
                    }
                    if (this.doRemove(state, savedParentItem)) {
                        updated = true;
                    }
                    state.theKeysToRemove.clear();
                    state.thePositionsToRemove.clear();
                    if (targetKey != null) {
                        assert (parentItem.isMap());
                        state.theKeysToRemove.add(targetKey);
                        break;
                    }
                    assert (parentItem.isArray());
                    state.thePositionsToRemove.add(targetPos);
                    break;
                }
                default: {
                    throw new QueryStateException("Unexpected kind of update clause: " + (Object)((Object)this.theUpdateKind));
                }
            }
            more = this.theInputIter.next(rcb);
        }
        if (this.theUpdateKind == Expr.UpdateKind.REMOVE && state.theParentItemContext.theParentItem != null && this.doRemove(state, state.theParentItemContext.theParentItem)) {
            updated = true;
        }
        state.done();
        return updated;
    }

    boolean doSet(RuntimeControlBlock rcb, UpdateFieldState state, FieldValueImpl targetItem) {
        boolean more;
        this.theInputIter.getParentItemContext(rcb, state.theParentItemContext);
        FieldValueImpl parentItem = state.theParentItemContext.theParentItem;
        int targetPos = state.theParentItemContext.theTargetPos;
        String targetKey = state.theParentItemContext.theTargetKey;
        if (parentItem.isNull()) {
            return false;
        }
        if (this.theTargetItemReg >= 0) {
            rcb.setRegVal(this.theTargetItemReg, targetItem);
        }
        if (!(more = this.theNewValueIter.next(rcb))) {
            this.theNewValueIter.reset(rcb);
            return false;
        }
        int inputReg = this.theNewValueIter.getResultReg();
        FieldValueImpl newTargetItem = rcb.getRegVal(inputReg);
        if (this.theCloneNewValues && !newTargetItem.isAtomic()) {
            newTargetItem = newTargetItem.clone();
        }
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("SET:\nParentItem =\n" + parentItem + "\nTargetItem:\n" + targetItem + "\nNewValue:\n" + newTargetItem + "\ntarget pos = " + targetPos);
        }
        try {
            switch (parentItem.getType()) {
                case RECORD: {
                    RecordValueImpl rec = (RecordValueImpl)parentItem;
                    if (newTargetItem.isJsonNull()) {
                        newTargetItem = NullValueImpl.getInstance();
                    }
                    FieldDefImpl targetType = targetPos >= 0 ? rec.getFieldDef(targetPos) : rec.getFieldDef(targetKey);
                    newTargetItem = CastIter.castValue(newTargetItem, targetType, this.theLocation);
                    if (targetPos >= 0) {
                        rec.put(targetPos, (FieldValue)newTargetItem);
                    } else {
                        rec.put(targetKey, (FieldValue)newTargetItem);
                    }
                    if (rcb.getTraceLevel() >= 1) {
                        rcb.trace("SET DONE:\nParentItem after update =\n" + parentItem);
                    }
                    break;
                }
                case MAP: {
                    MapValueImpl map = (MapValueImpl)parentItem;
                    FieldDefImpl targetType = map.getElementDef();
                    newTargetItem = CastIter.castValue(newTargetItem, targetType, this.theLocation);
                    map.put(targetKey, newTargetItem);
                    break;
                }
                case ARRAY: {
                    ArrayValueImpl arr = (ArrayValueImpl)parentItem;
                    FieldDefImpl targetType = arr.getElementDef();
                    newTargetItem = CastIter.castValue(newTargetItem, targetType, this.theLocation);
                    arr.set(targetPos, newTargetItem);
                    break;
                }
                default: {
                    throw new QueryStateException("Field to SET is not contained in a record, map, or array");
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new QueryException("SET operation failed. Cause: " + e.getMessage(), this.theLocation);
        }
        this.theNewValueIter.reset(rcb);
        return true;
    }

    boolean doAdd(RuntimeControlBlock rcb, FieldValueImpl targetItem) {
        boolean more;
        if (!targetItem.isArray()) {
            return false;
        }
        ArrayValueImpl arr = (ArrayValueImpl)targetItem;
        FieldDefImpl elemDef = arr.getElementDef();
        if (this.theTargetItemReg >= 0) {
            rcb.setRegVal(this.theTargetItemReg, targetItem);
        }
        int pos = -1;
        if (this.thePosIter != null && (more = this.thePosIter.next(rcb))) {
            FieldValueImpl posVal = rcb.getRegVal(this.thePosIter.getResultReg());
            if (!posVal.isNumeric()) {
                throw new QueryException("ADD operation failed. Cause: The position expression does not return a numeric item", this.theLocation);
            }
            if (this.thePosIter.next(rcb)) {
                throw new QueryException("ADD operation failed. Cause: The position expression returns more than one items", this.theLocation);
            }
            if (!posVal.isInteger()) {
                posVal = CastIter.castValue(posVal, FieldDefImpl.integerDef, this.theLocation);
            }
            if ((pos = posVal.getInt()) < 0) {
                pos = 0;
            }
            if (pos >= arr.size()) {
                pos = -1;
            }
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("Adding item at position " + pos + " of array\n" + arr);
        }
        if (!(more = this.theNewValueIter.next(rcb))) {
            this.theNewValueIter.reset(rcb);
            return false;
        }
        ArrayList<FieldValueImpl> values = new ArrayList<FieldValueImpl>();
        while (more) {
            FieldValueImpl val = rcb.getRegVal(this.theNewValueIter.getResultReg());
            if (this.theCloneNewValues && !val.isAtomic()) {
                val = val.clone();
            }
            val = CastIter.castValue(val, elemDef, this.theLocation);
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Item to add:\n" + val);
            }
            values.add(val);
            more = this.theNewValueIter.next(rcb);
        }
        try {
            for (int i = 0; i < values.size(); ++i) {
                if (pos < 0) {
                    arr.add((FieldValue)values.get(i));
                    continue;
                }
                arr.add(pos, (FieldValue)values.get(i));
                ++pos;
            }
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Target array after update:\n" + arr);
            }
        }
        catch (IllegalArgumentException e) {
            throw new QueryException("ADD operation failed. Cause: " + e.getMessage(), this.theLocation);
        }
        if (this.thePosIter != null) {
            this.thePosIter.reset(rcb);
        }
        this.theNewValueIter.reset(rcb);
        return true;
    }

    boolean doPut(RuntimeControlBlock rcb, FieldValueImpl targetItem) {
        boolean more;
        if (!targetItem.isMap()) {
            return false;
        }
        MapValueImpl map = (MapValueImpl)targetItem;
        FieldDefImpl elemDef = map.getElementDef();
        if (this.theTargetItemReg >= 0) {
            rcb.setRegVal(this.theTargetItemReg, targetItem);
        }
        if (!(more = this.theNewValueIter.next(rcb))) {
            this.theNewValueIter.reset(rcb);
            return false;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<FieldValueImpl> values = new ArrayList<FieldValueImpl>();
        while (more) {
            FieldValueImpl fval;
            String fkey;
            FieldValueImpl val = rcb.getRegVal(this.theNewValueIter.getResultReg());
            if (val.isMap()) {
                MapValueImpl fromMap = (MapValueImpl)val;
                for (Map.Entry<String, FieldValue> entry : fromMap.getFields().entrySet()) {
                    fkey = entry.getKey();
                    fval = (FieldValueImpl)entry.getValue();
                    if (this.theCloneNewValues && !fval.isAtomic()) {
                        fval = fval.clone();
                    }
                    fval = CastIter.castValue(fval, elemDef, this.theLocation);
                    keys.add(fkey);
                    values.add(fval);
                }
            } else if (val.isRecord()) {
                RecordValueImpl fromRec = (RecordValueImpl)val;
                int numFields = fromRec.getNumFields();
                for (int i = 0; i < numFields; ++i) {
                    fkey = fromRec.getFieldName(i);
                    fval = fromRec.get(i);
                    if (!fval.isAtomic()) {
                        fval = fval.clone();
                    }
                    fval = CastIter.castValue(fval, elemDef, this.theLocation);
                    keys.add(fkey);
                    values.add(fval);
                }
            }
            more = this.theNewValueIter.next(rcb);
        }
        this.theNewValueIter.reset(rcb);
        try {
            for (int i = 0; i < keys.size(); ++i) {
                map.put((String)keys.get(i), (FieldValue)values.get(i));
            }
        }
        catch (IllegalArgumentException e) {
            throw new QueryException("PUT operation failed. Cause: " + e.getMessage(), this.theLocation);
        }
        return !keys.isEmpty();
    }

    boolean doRemove(UpdateFieldState state, FieldValueImpl parentItem) {
        if (parentItem.isMap()) {
            MapValueImpl map = (MapValueImpl)parentItem;
            if (state.theKeysToRemove.isEmpty()) {
                return false;
            }
            for (String key : state.theKeysToRemove) {
                map.remove(key);
            }
        } else {
            ArrayValueImpl arr = (ArrayValueImpl)parentItem;
            int numRemoved = 0;
            for (Integer pos : state.thePositionsToRemove) {
                int adjustedPos = pos - numRemoved;
                arr.remove(adjustedPos);
                ++numRemoved;
            }
            if (numRemoved == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        if (this.thePosIter != null) {
            sb.append(",\n");
            this.thePosIter.display(sb, formatter);
        }
        if (this.theTargetItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("targetItemReg : ").append(this.theTargetItemReg);
        }
        if (this.theCloneNewValues) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("cloneNewValues : ").append(this.theCloneNewValues);
        }
        if (this.theNewValueIter != null) {
            sb.append(",\n");
            this.theNewValueIter.display(sb, formatter);
        }
    }

    @Override
    void displayName(StringBuilder sb) {
        sb.append((Object)this.theUpdateKind);
    }

    private static class UpdateFieldState
    extends PlanIterState {
        PlanIter.ParentItemContext theParentItemContext = new PlanIter.ParentItemContext();
        final ArrayList<String> theKeysToRemove = new ArrayList(32);
        final ArrayList<Integer> thePositionsToRemove = new ArrayList(32);

        UpdateFieldState() {
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theParentItemContext.reset();
            this.theKeysToRemove.clear();
            this.thePositionsToRemove.clear();
        }
    }
}

