/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Random;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Country;

public class ReadOnlyClassInsertTestCase
extends AutoVerifyTestCase {
    public Address address;

    public void reset() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected Object selectRandom(Vector aVector) {
        if (aVector.isEmpty()) {
            return null;
        }
        int size = aVector.size();
        Random aRandom = new Random();
        int index = Math.abs(aRandom.nextInt()) % size;
        return aVector.elementAt(index);
    }

    protected void setup() {
        this.beginTransaction();
    }

    protected void test() {
        Vector countries = this.getSession().readAllObjects(Country.class);
        Vector<Class<Country>> readOnlyClasses = new Vector<Class<Country>>();
        readOnlyClasses.addElement(Country.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.removeAllReadOnlyClasses();
        uow.addReadOnlyClasses(readOnlyClasses);
        this.address = new Address();
        Address addressClone = (Address)uow.registerObject((Object)this.address);
        addressClone.setStreetAddress("1203 Southport Drive");
        addressClone.setCity("Ottawa");
        addressClone.setZipCode("K1R 5N2");
        addressClone.setCountry((Country)this.selectRandom(countries));
        uow.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)this.address);
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("streetAddress").equal((Object)this.address.getStreet());
        Address dbAddress = (Address)this.getSession().readObject(Address.class, exp);
        if (!this.address.equals(dbAddress)) {
            throw new TestErrorException("The insert of a non-read-only object referring to a read-only object failed. We should be able to do this!");
        }
    }
}

