/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.util.HashMap;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaSequencingTest
extends AutoVerifyTestCase {
    final int numSessions = 4;
    DatabaseSession[] session = new DatabaseSession[4];
    String[] sessionName = new String[]{"NoDefaultSequence_NoSequences", "DefaultSequence_NoSequences", "NoDefaultSequence_Sequences", "DefaultSequence_Sequences"};
    Sequence definedDefaultSequence;
    HashMap definedSequences = new HashMap();

    public SessionsXMLSchemaSequencingTest() {
        this.setDescription("Test loading of sequencing in session xml against the XML Schema");
        this.definedDefaultSequence = new TableSequence("", 25, "MY_SEQUENCE", "MY_SEQ_NAME", "MY_SEQ_COUNT");
        this.definedSequences.put("EMP_SEQ", new DefaultSequence("EMP_SEQ", 30));
        this.definedSequences.put("PROJ_SEQ", new NativeSequence("PROJ_SEQ", 35));
        this.definedSequences.put("ADDRESS_SEQ", new UnaryTableSequence("ADDRESS_SEQ", 40));
    }

    public void reset() {
        for (int i = 0; i < 4; ++i) {
            if (this.session[i] == null) continue;
            SessionManager.getManager().getSessions().remove(this.session[i]);
            this.session[i] = null;
        }
    }

    protected void setup() throws Exception {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSessionSequencing.xml");
        for (int i = 0; i < 4; ++i) {
            this.session[i] = (DatabaseSession)SessionManager.getManager().getSession(loader, this.sessionName[i], ((Object)((Object)this)).getClass().getClassLoader(), false, true);
        }
    }

    protected void verify() {
        for (int i = 0; i < 4; ++i) {
            boolean ok;
            boolean isSequencesDefined;
            boolean isDefaultSequenceDefined = this.sessionName[i].indexOf("NoDefaultSequence") == -1;
            boolean bl = isSequencesDefined = this.sessionName[i].indexOf("NoSequences") == -1;
            if (isDefaultSequenceDefined) {
                ok = this.definedDefaultSequence.equals((Object)this.session[i].getDatasourcePlatform().getDefaultSequence());
            } else {
                boolean bl2 = ok = !((DatasourcePlatform)this.session[i].getDatasourcePlatform()).hasDefaultSequence();
            }
            if (!ok) {
                throw new TestErrorException("Session " + this.sessionName[i] + " has wrong defaultSequence");
            }
            if (isSequencesDefined) {
                for (Sequence definedSequence : this.definedSequences.values()) {
                    Sequence sequence;
                    ok = definedSequence.equals((Object)(sequence = this.session[i].getDatasourcePlatform().getSequence(definedSequence.getName())));
                    if (ok) continue;
                    throw new TestErrorException("Session " + this.sessionName[i] + " has wrong " + sequence.getName() + " sequence");
                }
                continue;
            }
            boolean bl3 = ok = this.session[i].getDatasourcePlatform().getSequences() == null || this.session[i].getDatasourcePlatform().getSequences().isEmpty();
            if (ok) continue;
            throw new TestErrorException("Session " + this.sessionName[i] + " has sequences, but it's not supposed to.");
        }
    }
}

