/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.jpa.server;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.transaction.UserTransaction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.testing.framework.jpa.server.ServerPlatform;

public class JEEPlatform
implements ServerPlatform {
    public static EntityManager entityManager;
    public static EntityManagerFactory entityManagerFactory;
    public static final String EJB_LOOKUP = "ejb.lookup";
    public static boolean ejbLookup;

    @Override
    public void initialize() {
    }

    @Override
    public boolean isTransactionActive() {
        try {
            return this.getUserTransaction().getStatus() != 6;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean getRollbackOnly() {
        try {
            return this.getUserTransaction().getStatus() != 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void beginTransaction() {
        try {
            this.getUserTransaction().begin();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void commitTransaction() {
        try {
            this.getUserTransaction().commit();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.getUserTransaction().rollback();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void closeEntityManager(EntityManager entityManager) {
    }

    public UserTransaction getUserTransaction() {
        try {
            return (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        }
        catch (NamingException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setTransactionForRollback() {
        try {
            this.getUserTransaction().setRollbackOnly();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean isWeblogic() {
        return false;
    }

    @Override
    public boolean isJBoss() {
        return false;
    }

    @Override
    public boolean isSpring() {
        return false;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public EntityManager getEntityManager(String persistenceUnit) {
        boolean useLookup;
        boolean bl = useLookup = ejbLookup || Boolean.getBoolean(EJB_LOOKUP);
        if (!useLookup) {
            return entityManager;
        }
        String contextName = "java:comp/env/persistence/" + persistenceUnit + "/entity-manager";
        try {
            return (EntityManager)new InitialContext().lookup(contextName);
        }
        catch (NamingException exception) {
            if (persistenceUnit.contains("member")) {
                String appContextName = "java:app/persistence/" + persistenceUnit + "/entity-manager";
                try {
                    return (EntityManager)new InitialContext().lookup(appContextName);
                }
                catch (NamingException e) {
                    e.addSuppressed(exception);
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(exception);
        }
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String persistenceUnit) {
        boolean useLookup;
        boolean bl = useLookup = ejbLookup || Boolean.getBoolean(EJB_LOOKUP);
        if (!useLookup) {
            return entityManagerFactory;
        }
        String contextName = "java:comp/env/persistence/" + persistenceUnit + "/factory";
        try {
            return (EntityManagerFactory)new InitialContext().lookup(contextName);
        }
        catch (NamingException exception) {
            if (persistenceUnit.contains("member")) {
                String appContextName = "java:app/persistence/" + persistenceUnit + "/factory";
                try {
                    return (EntityManagerFactory)new InitialContext().lookup(appContextName);
                }
                catch (NamingException e) {
                    e.addSuppressed(exception);
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void joinTransaction(EntityManager em) {
        em.joinTransaction();
    }

    static {
        ejbLookup = false;
    }
}

