/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.nio.ByteBuffer;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.dialog.ChannelOutput;

class NioChannelOutput
extends ChannelOutput {
    private static final int ARRAY_LENGTH = 128;
    private final Bufs bufsToFlush;
    private final int arrayLength;
    private boolean lastChunkFetched;

    NioChannelOutput() {
        this(128);
    }

    NioChannelOutput(int arrayLength) {
        this.arrayLength = arrayLength;
        this.bufsToFlush = new Bufs();
    }

    Bufs getBufs() {
        this.bufsToFlush.fetch();
        return this.bufsToFlush;
    }

    boolean hasRemaining() {
        return !this.getChunkQueue().isEmpty() || this.bufsToFlush.length != 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelOutput");
        builder.append(":A");
        builder.append("(").append(this.bufsToFlush.offset()).append(",").append(this.bufsToFlush.length()).append(")");
        builder.append(BytesUtil.toString(this.bufsToFlush.array(), this.bufsToFlush.offset(), this.bufsToFlush.length(), 32));
        builder.append("Q");
        builder.append("(").append(this.getChunkQueue().size()).append(")");
        builder.append(BytesUtil.toString(this.getChunkQueue().peek().chunkArray(), 0, 4, 32));
        return builder.toString();
    }

    class Bufs {
        private ByteBuffer[] array;
        private int offset;
        private int length;
        private int posInFirstOfQueue;

        Bufs() {
            this.array = new ByteBuffer[NioChannelOutput.this.arrayLength];
            this.offset = 0;
            this.length = 0;
            this.posInFirstOfQueue = 0;
        }

        ByteBuffer[] array() {
            return this.array;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }

        void update() {
            int off = this.offset;
            int len = this.length;
            boolean empty = true;
            for (int i = off; i < off + len; ++i) {
                if (this.array[i].remaining() == 0) continue;
                this.length = off + len - i;
                this.offset = i;
                empty = false;
                break;
            }
            if (empty) {
                this.offset = 0;
                this.length = 0;
            }
        }

        void trim() {
            if (this.offset == 0) {
                return;
            }
            if (this.length == 0) {
                this.offset = 0;
                this.length = 0;
                return;
            }
            System.arraycopy(this.array, this.offset, this.array, 0, this.length);
            this.offset = 0;
        }

        void fetch() {
            ChannelOutput.Chunk nextChunk;
            this.update();
            if (NioChannelOutput.this.lastChunkFetched) {
                return;
            }
            if (this.offset > this.array.length / 2) {
                this.trim();
            }
            while ((nextChunk = NioChannelOutput.this.getChunkQueue().peek()) != null) {
                ByteBuffer[] nextBufs = nextChunk.chunkArray();
                int actualLenInNextBufs = nextBufs.length - this.posInFirstOfQueue;
                int numSlotsInArray = this.array.length - this.offset - this.length;
                int copyLen = Math.min(actualLenInNextBufs, numSlotsInArray);
                System.arraycopy(nextBufs, this.posInFirstOfQueue, this.array, this.offset + this.length, copyLen);
                this.posInFirstOfQueue += copyLen;
                this.length += copyLen;
                if (this.posInFirstOfQueue == nextBufs.length) {
                    NioChannelOutput.this.getChunkQueue().poll();
                    if (nextChunk.last()) {
                        NioChannelOutput.this.lastChunkFetched = true;
                        break;
                    }
                    this.posInFirstOfQueue = 0;
                }
                if (this.offset + this.length != this.array.length) continue;
                break;
            }
        }
    }
}

