/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.perf;

import com.sleepycat.utilint.Latency;
import com.sleepycat.utilint.LatencyStat;
import oracle.kv.impl.async.perf.DialogPerf;

public class DialogLatency {
    private static final long MAX_LATENCY_MS_DEFAULT = 1000L;
    private final String name;
    private final LatencyStat latencyStat = new LatencyStat(1000L);

    public DialogLatency(String name) {
        this.name = name;
    }

    public void update(DialogPerf dperf) {
        this.latencyStat.set(dperf.getLatencyNs());
    }

    public void reset() {
        this.latencyStat.clear();
    }

    public String get() {
        Latency stat = this.latencyStat.calculate();
        String result = String.format("[%s]stat=(%s)", this.name, stat);
        this.reset();
        return result;
    }
}

