/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.emulateddb;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedResultSetMetaData;

public class EmulatedResultSet
implements ResultSet {
    protected List<DatabaseRecord> rows;
    protected int index;

    public EmulatedResultSet(List<DatabaseRecord> rows) {
        this.rows = rows;
        this.index = 0;
    }

    public List<DatabaseRecord> getRows() {
        return this.rows;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.index;
        return this.index <= this.rows.size();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)this.getObject(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)this.getObject(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return ((Number)this.getObject(columnIndex)).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return ((Number)this.getObject(columnIndex)).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Number value = (Number)this.getObject(columnIndex);
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Number value = (Number)this.getObject(columnIndex);
        if (value == null) {
            return 0L;
        }
        return value.longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Number value = (Number)this.getObject(columnIndex);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Number value = (Number)this.getObject(columnIndex);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getObject(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        java.util.Date date = (java.util.Date)this.getObject(columnIndex);
        if (date != null && !(date instanceof Date)) {
            date = new Date(date.getTime());
        }
        return (Date)date;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return (String)this.getObject(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return (Boolean)this.getObject(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return ((Number)this.getObject(columnName)).byteValue();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return ((Number)this.getObject(columnName)).shortValue();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        Number value = (Number)this.getObject(columnName);
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        Number value = (Number)this.getObject(columnName);
        if (value == null) {
            return 0L;
        }
        return value.longValue();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        Number value = (Number)this.getObject(columnName);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        Number value = (Number)this.getObject(columnName);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return (BigDecimal)this.getObject(columnName);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return (byte[])this.getObject(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        java.util.Date date = (java.util.Date)this.getObject(columnName);
        if (date != null && !(date instanceof Date)) {
            date = new Date(date.getTime());
        }
        return (Date)date;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return (Time)this.getObject(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return (Timestamp)this.getObject(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new EmulatedResultSetMetaData(this);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.rows.get(this.index - 1).getValues().get(columnIndex - 1);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.rows.get(this.index - 1).get(columnName);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return 0;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getObject(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return (Reader)this.getObject(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return (BigDecimal)this.getObject(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.index == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.index - 1 == this.rows.size();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.index == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.index == this.rows.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.index = 0;
    }

    @Override
    public void afterLast() throws SQLException {
        this.index = this.rows.size() + 1;
    }

    @Override
    public boolean first() throws SQLException {
        this.index = 1;
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        this.index = this.rows.size();
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.index;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.index = row;
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.index += rows;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        --this.index;
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getObject(i);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.getObject(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return (Clob)this.getObject(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(colName);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return (Blob)this.getObject(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return (Clob)this.getObject(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream stream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream stream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream stream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream stream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowid) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowid) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return iFace.cast(this);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) {
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) {
        return null;
    }
}

