/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterManager;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class JsonValueMetadata
extends MetadataConverter {
    private static final String TYPE_NAME = JsonValueMetadata.class.getName();

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof JsonValueMetadata;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (accessor.getReferenceClass().extendsInterface("jakarta.json.JsonValue") || accessor.getReferenceClass().isArray() || accessor.getReferenceClass().isInterface()) {
            if (!ConverterManager.getInstance().hasConverter(TYPE_NAME)) throw new IllegalStateException("Missing JSON type converter on classpath");
            this.setConverter(mapping, ConverterManager.getInstance().createConverter(TYPE_NAME), isForMapKey);
            return;
        } else {
            if (accessor.getClassAccessor().isMappedSuperclass()) return;
            throw ValidationException.invalidTypeForSerializedAttribute(mapping.getAttributeName(), accessor.getReferenceClass(), accessor.getJavaClass());
        }
    }
}

