/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.DirectDirectMapHolder;
import org.eclipse.persistence.testing.tests.collections.map.TestReadDirectDirectMapMapping;

public class TestUpdateDirectDirectMapMapping
extends TestReadDirectDirectMapMapping {
    protected DirectDirectMapHolder changedHolder = null;

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(DirectDirectMapHolder.class, this.holderExp);
        this.changedHolder = (DirectDirectMapHolder)this.holders.get(0);
        this.changedHolder.removeDirectToDirectMapItem(1);
        this.changedHolder.addDirectToDirectMapItem(3, 3);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object initialHolder = this.holders.get(0);
        this.holders = this.getSession().readAllObjects(DirectDirectMapHolder.class, this.holderExp);
        DirectDirectMapHolder holder = (DirectDirectMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        if (holder.getDirectToDirectMap().containsKey(1)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        Integer value = (Integer)holder.getDirectToDirectMap().get(3);
        if (value != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
    }
}

