/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.TypedAssociation;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.interfaces.Actor;
import org.eclipse.persistence.testing.models.interfaces.Broadcastor;
import org.eclipse.persistence.testing.models.interfaces.Employee;
import org.eclipse.persistence.testing.models.interfaces.Secretary;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneMapping2;

public class VariableOneToOneCodeCoverageTest
extends TestCase {
    VariableOneToOneMapping mapping;
    private String testFailures;

    public void setup() {
        this.mapping = new VariableOneToOneMapping();
        this.testFailures = "";
    }

    public void verify() {
        if (this.testFailures.length() > 0) {
            throw new TestErrorException("Tests failures from VariableOneToOneMapping: " + this.testFailures);
        }
    }

    public void test() {
        this.runTests();
    }

    public void runTests() {
        this.mapping.addClassIndicator(Employee.class, null);
        if (this.mapping.getClassIndicatorAssociations().isEmpty()) {
            this.testFailures = this.testFailures + "addClassIndicator = null did not add a null wrapper type indicator";
        } else {
            Enumeration e = this.mapping.getClassIndicatorAssociations().elements();
            while (e.hasMoreElements()) {
                TypedAssociation association = (TypedAssociation)e.nextElement();
                if (association.getKey() != Employee.class || association.getValue() instanceof Helper) continue;
                this.testFailures = this.testFailures + "addClassIndicator = null, type indicator does not = Helper class";
            }
        }
        Vector<Association> vectorIn = new Vector<Association>();
        vectorIn.add(new Association(Actor.class, (Object)new String("ASHLEY JUDD")));
        vectorIn.add(new Association(Secretary.class, (Object)new String("DARTH VADER")));
        vectorIn.add(new Association(Broadcastor.class, (Object)new String("RED KELLY")));
        this.mapping.setClassIndicatorAssociations(vectorIn);
        Vector vectorOut = this.mapping.getClassIndicatorAssociations();
        if (vectorOut.size() != 3) {
            this.testFailures = this.testFailures + "setClassIndicatorAssociations - the set failed";
        } else {
            int foundCount = 0;
            for (int i = 0; i < vectorOut.size(); ++i) {
                Association ass = (Association)vectorOut.elementAt(i);
                if (ass.getKey() == Actor.class.getName() && ass.getValue().equals("ASHLEY JUDD")) {
                    ++foundCount;
                }
                if (ass.getKey() == Secretary.class.getName() && ass.getValue().equals("DARTH VADER")) {
                    ++foundCount;
                }
                if (ass.getKey() != Broadcastor.class.getName() || !ass.getValue().equals("RED KELLY")) continue;
                ++foundCount;
            }
            if (foundCount != 3) {
                this.testFailures = this.testFailures + "setClassIndicatorAssociations - association values not found";
            }
        }
        Association assoc = new Association((Object)new String("key"), (Object)new String("value"));
        Vector<Association> in = new Vector<Association>();
        in.add(assoc);
        this.mapping.setSourceToTargetQueryKeyFieldAssociations(in);
        Vector out = this.mapping.getSourceToTargetQueryKeyFieldAssociations();
        if (out.size() != 1) {
            this.testFailures = this.testFailures + "setSourceToTargetQueryFieldAssociations - the set failed";
        } else {
            Association a = (Association)out.elementAt(0);
            if (!a.getKey().equals("key") || !a.getValue().equals("value")) {
                this.testFailures = this.testFailures + "setSourceToTargetQueryFieldAssociations - value in the set failed";
            }
        }
        Vector<String> foreignKeyNames = new Vector<String>();
        foreignKeyNames.add("fkey1");
        foreignKeyNames.add("fkey2");
        foreignKeyNames.add("fkey3");
        this.mapping.setForeignKeyFieldNames(foreignKeyNames);
        Vector fieldNames = this.mapping.getForeignKeyFieldNames();
        if (!this.mapping.getForeignKeyFieldNames().contains("fkey1")) {
            this.testFailures = this.testFailures + "addForeignQueryKeyName - fkey1";
        }
        if (!this.mapping.getForeignKeyFieldNames().contains("fkey2")) {
            this.testFailures = this.testFailures + "addForeignQueryKeyName - fkey2";
        }
        if (!this.mapping.getForeignKeyFieldNames().contains("fkey3")) {
            this.testFailures = this.testFailures + "addForeignQueryKeyName - fkey3";
        }
        this.mapping.setTypeFieldName("doesNotExist");
        if (!this.mapping.getTypeFieldName().equals("doesNotExist")) {
            this.testFailures = this.testFailures + "setTypeFieldName failed";
        }
        VariableOneToOneMapping2 wrappedMapping = new VariableOneToOneMapping2();
        wrappedMapping.setTypeField(null);
        if (wrappedMapping.getTypeFieldName() != null) {
            this.testFailures = this.testFailures + "setTypeField - set to null failed";
        }
        wrappedMapping.addClassIndicator(Employee.class, null);
        if (wrappedMapping.getTypeForImplementor(Employee.class) != null) {
            this.testFailures = this.testFailures + "getTypeForImplementor failed";
        }
        if (wrappedMapping.getImplementorForType(null, this.getSession()) != Employee.class) {
            this.testFailures = this.testFailures + "getImplementorForType failed";
        }
    }
}

