/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.helper;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.testing.tests.junit.helper.ConcurrencySemaphoreThread;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcurrencySemaphoreTest {
    private static final int INITIAL_NO_OF_THREADS = 100;
    private static final long MAX_TIME_PERMIT = 500L;
    private static final long TIMEOUT_BETWEEN_LOG_MESSAGES = 20000L;

    @Before
    public void setup() {
        ConcurrencyUtil.SINGLETON.setConcurrencySemaphoreMaxTimePermit(500L);
        ConcurrencyUtil.SINGLETON.setConcurrencySemaphoreLogTimeout(20000L);
    }

    @Test
    public void testConcurrencySemaphore() throws Exception {
        Assert.assertEquals((long)500L, (long)ConcurrencyUtil.SINGLETON.getConcurrencySemaphoreMaxTimePermit());
        Assert.assertEquals((long)20000L, (long)ConcurrencyUtil.SINGLETON.getConcurrencySemaphoreLogTimeout());
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        for (int i = 1; i <= 100; ++i) {
            ConcurrencySemaphoreThread thread = new ConcurrencySemaphoreThread();
            executorService.execute(thread);
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(20L, TimeUnit.SECONDS)) {
            System.out.println("Awaiting completion of threads.");
        }
    }
}

