/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import org.eclipse.persistence.testing.framework.ConcurrentPerformanceRegressionTest;
import org.eclipse.persistence.testing.models.performance.Employee;

public class LazyInitConcurrentTest
extends ConcurrentPerformanceRegressionTest {
    protected Employee employee;

    public LazyInitConcurrentTest() {
        this.setDescription("This test tries to recreate concurrency issues in lazy initialization and also measure their performance.");
        this.setMaxThreads(100);
        this.setTestRunTime(1L);
    }

    public void runTask() throws Exception {
        Employee employee = this.getEmployee();
        int phone = System.identityHashCode(employee.getPhoneNumbers());
        int emp = System.identityHashCode(employee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Employee getEmployee() {
        if (this.employee == null) {
            LazyInitConcurrentTest lazyInitConcurrentTest = this;
            synchronized (lazyInitConcurrentTest) {
                if (this.employee == null) {
                    this.employee = new Employee();
                }
            }
        }
        return this.employee;
    }
}

