/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractSalesRep;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectListProject;
import org.eclipse.persistence.testing.models.transparentindirection.Order;
import org.eclipse.persistence.testing.models.transparentindirection.OrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.SalesRep;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectContainerTestDatabase;

public class IndirectListTestDatabase
extends IndirectContainerTestDatabase {
    int orderId;

    public IndirectListTestDatabase(String name) {
        super(name);
    }

    @Override
    protected AbstractOrder buildOrderShell() {
        return new Order();
    }

    @Override
    protected AbstractOrder buildTestOrderShell(String customerName) {
        return new Order(customerName);
    }

    @Override
    protected AbstractOrderLine newOrderLine(String item, int quanity) {
        return new OrderLine(item, quanity);
    }

    @Override
    protected AbstractSalesRep newSalesRep(String name) {
        return new SalesRep(name);
    }

    public Project setUpProjectFromCode() {
        return new IndirectListProject();
    }

    @Override
    protected void setUp() {
        super.setUp();
        AbstractOrder order = this.buildTestOrder3();
        this.writeNewOrder(order);
        this.orderId = order.id;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void tearDown() {
        Order order = new Order();
        order.id = this.orderId;
        this.getAbstractSession().deleteObject((Object)order);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        super.tearDown();
    }

    public void testConformWithAnyOfIsNull() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.readNullName(uow);
        this.readNullName(uow);
    }

    private void readNullName(UnitOfWork uow) {
        ReadAllQuery readAllQuery = new ReadAllQuery(Order.class);
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression e = expressionBuilder.anyOf("lines").get("itemName").isNull();
        readAllQuery.setSelectionCriteria(e);
        readAllQuery.conformResultsInUnitOfWork();
        Vector vector = (Vector)uow.executeQuery((DatabaseQuery)readAllQuery);
        IndirectListTestDatabase.assertEquals((String)"Result should have one element", (int)1, (int)vector.size());
        Order order = (Order)vector.get(0);
        AbstractOrderLine line = (AbstractOrderLine)((Collection)order.getLineContainer()).toArray()[0];
        IndirectListTestDatabase.assertEquals((String)"itemName in OrderLine should be null", (String)line.getKey(), null);
    }
}

