/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RoundRobinPartitioningPolicy;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkIsolatedAlwaysTestModel;

public class UnitOfWorkPartitionedIsolatedAlwaysTestModel
extends UnitOfWorkIsolatedAlwaysTestModel {
    @Override
    public void setup() {
        if (this.getSession().getPlatform().isSybase()) {
            throw new TestWarningException("This cannot be run on Sybase as it conflicts with its transaction isolation level.");
        }
        super.setup();
    }

    @Override
    public Server buildServerSession() {
        Server server = this.getSession().getProject().clone().createServerSession(1, 3);
        server.addConnectionPool("node2", (Login)this.getSession().getLogin(), 1, 3);
        server.addConnectionPool("node3", (Login)this.getSession().getLogin(), 1, 3);
        server.setSessionLog(this.getSession().getSessionLog());
        server.setPartitioningPolicy((PartitioningPolicy)new RoundRobinPartitioningPolicy(new String[]{"default", "node2", "node3"}));
        server.login();
        return server;
    }
}

