/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class MappingMustBeReadOnlyWhenStoredInCacheTest
extends ExceptionTest {
    ClassDescriptor descriptor;
    DirectToFieldMapping mapping;
    boolean orgReadOnly;
    IntegrityChecker orgIntegrityChecker;
    VersionLockingPolicy policy;

    public MappingMustBeReadOnlyWhenStoredInCacheTest() {
        this.setDescription("This tests Mapping must Be Read Only when stored in cache (TL-ERROR 119)");
    }

    protected void setup() {
        this.descriptor = this.getSession().getDescriptor(Employee.class);
        this.mapping = (DirectToFieldMapping)this.descriptor.getMappingForAttributeName("firstName");
        this.orgReadOnly = this.mapping.isReadOnly();
        this.mapping.readWrite();
        this.expectedException = DescriptorException.mustBeReadOnlyMappingWhenStoredInCache((DatabaseMapping)this.mapping);
        this.policy = new VersionLockingPolicy();
        this.policy.setWriteLockFieldName("EMPLOYEE.F_NAME");
        this.policy.storeInCache();
        this.descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.policy);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.mapping.setIsReadOnly(this.orgReadOnly);
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.policy.initialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

