/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.Serializable;
import java.util.Properties;
import oracle.kv.LoginCredentials;

public class KerberosCredentials
implements LoginCredentials,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String username;
    private Properties krbProperties;

    public KerberosCredentials(String username, Properties krbProperties) throws IllegalArgumentException {
        if (username == null) {
            throw new IllegalArgumentException("The username argument must not be null");
        }
        if (krbProperties == null) {
            throw new IllegalArgumentException("The krbProperties argument must not be null");
        }
        this.username = username;
        this.krbProperties = krbProperties;
        this.krbProperties.setProperty("oracle.kv.auth.username", username);
        this.krbProperties.setProperty("oracle.kv.auth.external.mechanism", "KERBEROS");
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public Properties getKrbProperties() {
        return this.krbProperties;
    }
}

