/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.IntegerValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.IntNode;

@Persistent(version=1)
public class IntegerValueImpl
extends FieldValueImpl
implements IntegerValue {
    private static final long serialVersionUID = 1L;
    protected int value;

    IntegerValueImpl(int value) {
        this.value = value;
    }

    IntegerValueImpl(String keyValue) {
        this.value = SortableString.intFromSortable(keyValue);
    }

    private IntegerValueImpl() {
        this.value = 0;
    }

    @Override
    public IntegerValueImpl clone() {
        return new IntegerValueImpl(this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 4;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof IntegerValueImpl) {
            return this.value == ((IntegerValueImpl)other).get();
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof IntegerValueImpl) {
            return IntegerValueImpl.compare(this.value, ((IntegerValueImpl)other).get());
        }
        if (other instanceof LongValueImpl) {
            return LongValueImpl.compare(this.value, ((LongValueImpl)other).get());
        }
        throw new ClassCastException("Object is not comparable to LongValue");
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.INTEGER;
    }

    @Override
    public IntegerDefImpl getDefinition() {
        return FieldDefImpl.integerDef;
    }

    @Override
    public IntegerValue asInteger() {
        return this;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public int get() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public void setInt(int v) {
        this.value = v;
    }

    @Override
    public int castAsInt() {
        return this.value;
    }

    @Override
    public long castAsLong() {
        return this.value;
    }

    @Override
    public float castAsFloat() {
        return this.value;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public BigDecimal castAsDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public String castAsString() {
        return Integer.toString(this.value);
    }

    @Override
    FieldValueImpl getNextValue() {
        if (this.value == Integer.MAX_VALUE) {
            return null;
        }
        return new IntegerValueImpl(this.value + 1);
    }

    @Override
    FieldValueImpl getMinimumValue() {
        return new IntegerValueImpl(Integer.MIN_VALUE);
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return IntegerValueImpl.toKeyString(this.value, field, storageSize);
    }

    @Override
    public JsonNode toJsonNode() {
        return new IntNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    void validateStorageSize(int size) {
        int requiredSize = SortableString.encodingLength(this.value);
        if (requiredSize > size) {
            throw new IllegalArgumentException("Integer value is too large for primary key storage size. It requires " + requiredSize + " bytes, and size must be less than or equal to " + size + " bytes");
        }
    }

    static String toKeyString(int val, FieldDef def, int storageSize) {
        int len;
        int n = len = def != null ? ((IntegerDefImpl)def).getEncodingLength() : 0;
        if ((len == 0 || len == 5) && storageSize != 0) {
            len = storageSize;
        }
        return SortableString.toSortable(val, len);
    }
}

