/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.Serializable;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Translator;
import oracle.kv.table.SequenceDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class SequenceDefImpl
implements SequenceDef,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean isSetStart = false;
    private FieldValueImpl start = null;
    private boolean isSetIncrement = false;
    private FieldValueImpl increment = null;
    private boolean isSetMax = false;
    private FieldValueImpl max = null;
    private boolean isSetMin = false;
    private FieldValueImpl min = null;
    private boolean isSetCache = false;
    private FieldValueImpl cache = null;
    private boolean isSetCycle = false;
    private boolean cycle = false;

    public SequenceDefImpl(FieldDefImpl fdi, Translator.IdentityDefHelper identityHelper) {
        if (identityHelper.isSetStart()) {
            this.setStartValue(this.init(fdi, identityHelper.getStart()));
        } else {
            this.start = this.init(fdi, "1");
        }
        if (identityHelper.isSetIncrement()) {
            this.setIncrementValue(this.init(fdi, identityHelper.getIncrement()));
        } else {
            this.increment = this.init(fdi, "1");
        }
        if (identityHelper.isSetMax()) {
            this.setMaxValue(this.init(fdi, identityHelper.getMax()));
        } else {
            this.max = this.init(fdi, "max");
        }
        if (identityHelper.isSetMin()) {
            this.setMinValue(this.init(fdi, identityHelper.getMin()));
        } else {
            this.min = this.init(fdi, "min");
        }
        if (identityHelper.isSetCache()) {
            this.setCacheValue(this.init(fdi, identityHelper.getCache()));
        } else {
            this.cache = this.init(fdi, "1000");
        }
        if (identityHelper.isSetCycle()) {
            this.setCycle(identityHelper.getCycle());
        }
    }

    private FieldValueImpl init(FieldDefImpl fdi, String value) {
        switch (fdi.getType()) {
            case INTEGER: {
                if (value.equals("max")) {
                    return (FieldValueImpl)((Object)fdi.createInteger(Integer.MAX_VALUE));
                }
                if (value.equals("min")) {
                    return (FieldValueImpl)((Object)fdi.createInteger(Integer.MIN_VALUE));
                }
                return (FieldValueImpl)((Object)fdi.createInteger(Integer.parseInt(value)));
            }
            case LONG: {
                if (value.equals("max")) {
                    return (FieldValueImpl)((Object)fdi.createLong(Long.MAX_VALUE));
                }
                if (value.equals("min")) {
                    return (FieldValueImpl)((Object)fdi.createLong(Long.MIN_VALUE));
                }
                return (FieldValueImpl)((Object)fdi.createLong(Long.parseLong(value)));
            }
            case NUMBER: {
                if (value.equals("max") || value.equals("min")) {
                    return null;
                }
                return (FieldValueImpl)((Object)fdi.createNumber(new BigDecimal(value)));
            }
        }
        throw new QueryException("Identity field must be one of the following numeric data types: INTEGER, LONG or NUMBER.");
    }

    @Override
    public SequenceDefImpl clone() {
        try {
            return (SequenceDefImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean isSetStartValue() {
        return this.isSetStart;
    }

    public SequenceDefImpl setStartValue(FieldValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        this.start = value;
        this.isSetStart = true;
        return this;
    }

    @Override
    public FieldValueImpl getStartValue() {
        return this.start;
    }

    @Override
    public boolean isSetIncrementValue() {
        return this.isSetIncrement;
    }

    public SequenceDefImpl setIncrementValue(FieldValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        this.increment = value;
        this.isSetIncrement = true;
        return this;
    }

    @Override
    public FieldValueImpl getIncrementValue() {
        return this.increment;
    }

    @Override
    public boolean isSetMaxValue() {
        return this.isSetMax;
    }

    public SequenceDefImpl setMaxValue(FieldValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        this.max = value;
        this.isSetMax = true;
        return this;
    }

    @Override
    public FieldValueImpl getMaxValue() {
        return this.max;
    }

    @Override
    public boolean isSetMinValue() {
        return this.isSetMin;
    }

    public SequenceDefImpl setMinValue(FieldValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        this.min = value;
        this.isSetMin = true;
        return this;
    }

    @Override
    public FieldValueImpl getMinValue() {
        return this.min;
    }

    @Override
    public boolean isSetCacheValue() {
        return this.isSetCache;
    }

    public SequenceDef setCacheValue(FieldValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        this.cache = value;
        this.isSetCache = true;
        return this;
    }

    @Override
    public FieldValueImpl getCacheValue() {
        return this.cache;
    }

    @Override
    public boolean isSetCycle() {
        return this.isSetCycle;
    }

    public SequenceDef setCycle(boolean cycle) {
        this.cycle = cycle;
        this.isSetCycle = true;
        return this;
    }

    @Override
    public boolean getCycle() {
        return this.cycle;
    }

    public JsonNode toJsonNode() {
        ObjectNode idObj = JsonNodeFactory.instance.objectNode();
        idObj.put("start", this.start.toJsonNode());
        idObj.put("increment", this.increment.toJsonNode());
        idObj.put("max", this.max.toJsonNode());
        idObj.put("min", this.min.toJsonNode());
        idObj.put("cache", this.cache.toJsonNode());
        idObj.put("cycle", this.cycle);
        return idObj;
    }

    public String toString() {
        return "SequenceDefImpl[start=" + this.start + ", increment=" + this.increment + ", max=" + this.max + ", min=" + this.min + ", cache=" + this.cache + ", cycle=" + this.cycle + ']';
    }
}

