/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.aggregate.Address;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Bicycle;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.aggregate.Car;
import org.eclipse.persistence.testing.models.aggregate.Client;
import org.eclipse.persistence.testing.models.aggregate.Company;
import org.eclipse.persistence.testing.models.aggregate.Computer;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.models.aggregate.Dependant;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.EvaluationClient;
import org.eclipse.persistence.testing.models.aggregate.GolfClub;
import org.eclipse.persistence.testing.models.aggregate.GolfClubShaft;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.Job;
import org.eclipse.persistence.testing.models.aggregate.Language;
import org.eclipse.persistence.testing.models.aggregate.Manufacturer;
import org.eclipse.persistence.testing.models.aggregate.Oid;
import org.eclipse.persistence.testing.models.aggregate.Period;
import org.eclipse.persistence.testing.models.aggregate.PeriodDescription;
import org.eclipse.persistence.testing.models.aggregate.ProjectDescription;
import org.eclipse.persistence.testing.models.aggregate.Responsibility;
import org.eclipse.persistence.testing.models.aggregate.RoomSellingPoint;
import org.eclipse.persistence.testing.models.aggregate.SellingPoint;
import org.eclipse.persistence.testing.models.aggregate.SingleHouse;
import org.eclipse.persistence.testing.models.aggregate.TownHouse;
import org.eclipse.persistence.testing.models.aggregate.Transport;
import org.eclipse.persistence.testing.models.aggregate.Vehicle;
import org.eclipse.persistence.testing.models.aggregate.Version;
import org.eclipse.persistence.testing.models.aggregate.Worker;

public class AggregateProject
extends Project {
    protected boolean useNewAggregateCollection;

    public AggregateProject() {
        this(false);
    }

    public AggregateProject(boolean useNewAggregateCollection) {
        this.useNewAggregateCollection = useNewAggregateCollection;
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildAddressDescriptor();
        this.buildAddressDescriptionDescriptor();
        this.buildClientDescriptor();
        this.buildComputerDescriptor();
        this.buildEmployeeDescriptor();
        this.buildEvaluationClientDescriptor();
        this.buildLanguageDescriptor();
        this.buildPeriodDescriptor();
        this.buildPeriodDescriptionDescriptor();
        this.buildProjectDescriptionDescriptor();
        this.buildResponsibilityDescriptor();
        this.buildOidDescriptor();
        this.buildVersionDescriptor();
        this.buildJobDescriptor();
        this.buildWorkerDescriptor();
        this.buildAgentDescriptor();
        this.buildCustomerDescriptor();
        this.buildHouseDescriptor();
        this.buildDependantDescriptor();
        this.buildCompanyDescriptor();
        this.buildSingleHouseDescriptor();
        this.buildTownHouseDescriptor();
        this.buildSellingPointDescriptor();
        this.buildRoomSellingPointDescriptor();
        if (useNewAggregateCollection) {
            this.buildBuilderDescriptor();
        }
        this.buildTransportDescriptor();
        this.buildVehicleDescriptor();
        this.buildBicycleDescriptor();
        this.buildCarDescriptor();
        this.buildGolfClubShaftDescriptor();
        this.buildGolfClubDescriptor();
        this.buildManufacturerDescriptor();
    }

    protected void applyLOGIN() {
    }

    protected void applyPROJECT() {
        this.setName("ComplexAggregateSystem");
    }

    protected void buildAddressDescriptionDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(AddressDescription.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("periodDescription");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getPeriodDescription");
        aggregateobjectmapping.setSetMethodName("setPeriodDescription");
        aggregateobjectmapping.setReferenceClass(PeriodDescription.class);
        aggregateobjectmapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("address");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(Address.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.setUsesBatchReading(true);
        onetoonemapping.addForeignKeyFieldName("AGG_EMP.EM_ADD", "AGG_ADD.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_ADD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ADD.ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("address");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_ADD.ADDRESS");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_ADD.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildAgentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Agent.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGENT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGENT_ID");
        descriptor.setSequenceNumberName("AGENT_SEQ");
        descriptor.setSequenceNumberFieldName("AGENT_ID");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateCollectionMapping aggregatecollectionmapping = new AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("customers");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(true);
        aggregatecollectionmapping.setGetMethodName("getCustomerValueHolder");
        aggregatecollectionmapping.setSetMethodName("setCustomerValueHolder");
        aggregatecollectionmapping.setReferenceClass(Customer.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("CUSTOMER.AGENT_ID", "AGENT.AGENT_ID");
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping);
        AggregateCollectionMapping aggregatecollectionmapping2 = new AggregateCollectionMapping();
        aggregatecollectionmapping2.setAttributeName("houses");
        aggregatecollectionmapping2.setIsReadOnly(false);
        aggregatecollectionmapping2.setUsesIndirection(true);
        aggregatecollectionmapping2.setGetMethodName("getHouseValueHolder");
        aggregatecollectionmapping2.setSetMethodName("setHouseValueHolder");
        aggregatecollectionmapping2.setReferenceClass(House.class);
        aggregatecollectionmapping2.addTargetForeignKeyFieldName("HOUSE.AGENT_ID", "AGENT.AGENT_ID");
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping2);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("AGENT_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("firstName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getFirstName");
        directtofieldmapping1.setSetMethodName("setFirstName");
        directtofieldmapping1.setFieldName("FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLastName");
        directtofieldmapping2.setSetMethodName("setLastName");
        directtofieldmapping2.setFieldName("LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildBicycleDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Bicycle.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(Vehicle.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.BICYCLE_DESC");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildBuilderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Builder.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("BUILDER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("BUILDER_ID");
        descriptor.setSequenceNumberName("BUILDER_SEQ");
        descriptor.setSequenceNumberFieldName("BUILDER_ID");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateCollectionMapping aggregatecollectionmapping = new AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("customers");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setReferenceClass(Customer.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("BUILDER_CUSTOMER.BUILDER_ID", "BUILDER.BUILDER_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.CUSTOMER_ID", "CUSTOMER_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.BUILDER_ID", "AGENT_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.COMPANY_ID", "COMPANY_ID");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.NAME", "NAME");
        aggregatecollectionmapping.addFieldNameTranslation("BUILDER_CUSTOMER.INCOME", "INCOME");
        aggregatecollectionmapping.addNestedFieldNameTranslation("dependants", "BUILDER_DEPENDANT.CUSTOMER_ID", "CUSTOMER_ID");
        aggregatecollectionmapping.addNestedFieldNameTranslation("dependants", "BUILDER_DEPENDANT.FIRST_NAME", "FIRST_NAME");
        aggregatecollectionmapping.addNestedFieldNameTranslation("dependants", "BUILDER_DEPENDANT.AGE", "AGE");
        aggregatecollectionmapping.useTransparentCollection();
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping);
        AggregateCollectionMapping aggregatecollectionmapping2 = new AggregateCollectionMapping();
        aggregatecollectionmapping2.setAttributeName("houses");
        aggregatecollectionmapping2.setIsReadOnly(false);
        aggregatecollectionmapping2.setReferenceClass(House.class);
        aggregatecollectionmapping2.addTargetForeignKeyFieldName("BUILDER_HOUSE.BUILDER_ID", "BUILDER.BUILDER_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.BUILDER_ID", "AGENT_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.LOCATION", "LOCATION");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.DESCRIPTIONS", "DESCRIPTIONS");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.INS_ID", "INS_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.VERSION", "VERSION");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_HOUSE.TYPE", "TYPE");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_SINGLE_HOUSE.BUILDER_ID", "SINGLE_HOUSE.AGENT_ID");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_SINGLE_HOUSE.LOCATION", "SINGLE_HOUSE.LOCATION");
        aggregatecollectionmapping2.addFieldNameTranslation("BUILDER_SINGLE_HOUSE.GARAGE", "SINGLE_HOUSE.GARAGE");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.BUILDER_ID", "AGENT_ID");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.LOCATION", "LOCATION");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.AREA", "AREA");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.DESCRIPTION", "DESCRIPTION");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.TYPE", "TYPE");
        aggregatecollectionmapping2.addNestedFieldNameTranslation("sellingPoints", "BUILDER_SELLING_POINT.SQUARE_FEET", "SQUARE_FEET");
        aggregatecollectionmapping2.useTransparentCollection();
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping2);
        AggregateCollectionMapping aggregatecollectionmapping3 = new AggregateCollectionMapping();
        aggregatecollectionmapping3.setAttributeName("vehicles");
        aggregatecollectionmapping3.setIsReadOnly(false);
        aggregatecollectionmapping3.setReferenceClass(Vehicle.class);
        aggregatecollectionmapping3.addTargetForeignKeyFieldName("BUILDER_VEHICLE.BUILDER_ID", "BUILDER.BUILDER_ID");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.TYPE", "TYPE");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.CAPACITY", "CAPACITY");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.COLOUR", "COLOUR");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.BICYCLE_DESC", "BICYCLE_DESC");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.CAR_MAKE", "CAR_MAKE");
        aggregatecollectionmapping3.addFieldNameTranslation("BUILDER_VEHICLE.CAR_MODEL", "CAR_MODEL");
        aggregatecollectionmapping3.useTransparentCollection();
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping3);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("BUILDER_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("firstName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getFirstName");
        directtofieldmapping1.setSetMethodName("setFirstName");
        directtofieldmapping1.setFieldName("FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLastName");
        directtofieldmapping2.setSetMethodName("setLastName");
        directtofieldmapping2.setFieldName("LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCarDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Car.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(Vehicle.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("make");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.CAR_MAKE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("model");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGGVEHICLE.CAR_MODEL");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildClientDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Client.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_CLNT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_CLNT.CL_ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("CL_ID");
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(false);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(Client.class, (Object)"Client");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(EvaluationClient.class, (Object)"Eval");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("AGG_CLNT.VERSION");
        lockingPolicy.storeInObject();
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("addressDescription");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(AddressDescription.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_ADD", "AGG_EMP.EM_ADD");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_EDATE", "AGG_EMP.EM_EDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_SDATE", "AGG_EMP.EM_SDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_EEDATE", "AGG_EMP.EM_EEDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_CLNT.CL_ESDATE", "AGG_EMP.EM_ESDATE");
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        AggregateObjectMapping aggregateobjectmapping2 = new AggregateObjectMapping();
        aggregateobjectmapping2.setAttributeName("id");
        aggregateobjectmapping2.setIsReadOnly(false);
        aggregateobjectmapping2.setGetMethodName("getOid");
        aggregateobjectmapping2.setSetMethodName("setOid");
        aggregateobjectmapping2.setReferenceClass(Oid.class);
        aggregateobjectmapping2.addFieldNameTranslation("AGG_CLNT.CL_ID", "ID");
        aggregateobjectmapping2.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping2);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_CLNT.CL_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        AggregateObjectMapping versionMapping = new AggregateObjectMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setReferenceClass(Version.class);
        versionMapping.setIsNullAllowed(false);
        versionMapping.addFieldNameTranslation("AGG_CLNT.VERSION", "VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCompanyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Company.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COMPANY_AGG");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COMPANY_ID");
        descriptor.setSequenceNumberName("COMPANY_SEQ");
        descriptor.setSequenceNumberFieldName("COMPANY_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("companyId");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getCompanyId");
        directtofieldmapping.setSetMethodName("setCompanyId");
        directtofieldmapping.setFieldName("COMPANY_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getName");
        directtofieldmapping1.setSetMethodName("setName");
        directtofieldmapping1.setFieldName("NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildComputerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Computer.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_COM");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_COM.ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_COM.DESCRIP");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("id");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getOid");
        aggregateobjectmapping.setSetMethodName("setOid");
        aggregateobjectmapping.setReferenceClass(Oid.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCustomerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Customer.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("CUSTOMER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("CUSTOMER_ID");
        descriptor.setSequenceNumberName("CUSTOMER_SEQ");
        descriptor.setSequenceNumberFieldName("CUSTOMER_ID");
        descriptor.descriptorIsAggregateCollection();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateCollectionMapping aggregatecollectionmapping = new AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("dependants");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(true);
        aggregatecollectionmapping.setGetMethodName("getDependantValueHolder");
        aggregatecollectionmapping.setSetMethodName("setDependantValueHolder");
        aggregatecollectionmapping.setReferenceClass(Dependant.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("DEPENDANT.CUSTOMER_ID", "CUSTOMER.CUSTOMER_ID");
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("name");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getName");
        directtofieldmapping.setSetMethodName("setName");
        directtofieldmapping.setFieldName("NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("income");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getIncome");
        directtofieldmapping1.setSetMethodName("setIncome");
        directtofieldmapping1.setFieldName("INCOME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getId");
        directtofieldmapping2.setSetMethodName("setId");
        directtofieldmapping2.setFieldName("CUSTOMER_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping oneToOnemapping = new OneToOneMapping();
        oneToOnemapping.setAttributeName("company");
        oneToOnemapping.setIsReadOnly(false);
        oneToOnemapping.setIsPrivateOwned(true);
        oneToOnemapping.setUsesIndirection(true);
        oneToOnemapping.setReferenceClass(Company.class);
        oneToOnemapping.addForeignKeyFieldName("CUSTOMER.COMPANY_ID", "COMPANY_AGG.COMPANY_ID");
        descriptor.addMapping((DatabaseMapping)oneToOnemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildDependantDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Dependant.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("DEPENDANT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("CUSTOMER_ID");
        descriptor.addPrimaryKeyFieldName("FIRST_NAME");
        descriptor.descriptorIsAggregateCollection();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFirstName");
        directtofieldmapping.setSetMethodName("setFirstName");
        directtofieldmapping.setFieldName("FIRST_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("age");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getAge");
        directtofieldmapping1.setSetMethodName("setAge");
        directtofieldmapping1.setFieldName("AGE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_EMP.EM_ADD");
        descriptor.addPrimaryKeyFieldName("AGG_EMP.EM_ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("EM_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("address");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getAddressDescription");
        aggregateobjectmapping.setSetMethodName("setAddressDescription");
        aggregateobjectmapping.setReferenceClass(AddressDescription.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        AggregateObjectMapping aggregateobjectmapping1 = new AggregateObjectMapping();
        aggregateobjectmapping1.setAttributeName("projectDescription");
        aggregateobjectmapping1.setIsReadOnly(false);
        aggregateobjectmapping1.setGetMethodName("getProjectDescription");
        aggregateobjectmapping1.setSetMethodName("setProjectDescription");
        aggregateobjectmapping1.setReferenceClass(ProjectDescription.class);
        aggregateobjectmapping1.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping1);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFirstName");
        directtofieldmapping.setSetMethodName("setFirstName");
        directtofieldmapping.setFieldName("AGG_EMP.EM_FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("lastName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getLastName");
        directtofieldmapping1.setSetMethodName("setLastName");
        directtofieldmapping1.setFieldName("AGG_EMP.EM_LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEvaluationClientDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EvaluationClient.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(Client.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_ECNT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_ECNT.CL_ID");
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("evaluationPeriod");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(Period.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        aggregateobjectmapping.addFieldNameTranslation("AGG_ECNT.EV_EDATE", "AGG_EMP.EM_EDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_ECNT.EV_SDATE", "AGG_EMP.EM_SDATE");
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildGolfClubDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(GolfClub.class);
        descriptor.addTableName("GOLF_CLUB");
        descriptor.addPrimaryKeyFieldName("GOLF_CLUB.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("GolfClub");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.getDescriptorQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setGetMethodName("getId");
        idMapping.setSetMethodName("setId");
        idMapping.setFieldName("GOLF_CLUB.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        AggregateObjectMapping shaftMapping = new AggregateObjectMapping();
        shaftMapping.setAttributeName("shaft");
        shaftMapping.setGetMethodName("getShaft");
        shaftMapping.setSetMethodName("setShaft");
        shaftMapping.setReferenceClass(GolfClubShaft.class);
        shaftMapping.setIsNullAllowed(false);
        shaftMapping.addFieldNameTranslation("GOLF_CLUB.SHAFT_STIFFNESS", "SHAFT_STIFFNESS");
        shaftMapping.addFieldNameTranslation("GOLF_CLUB.SHAFT_STIFFNESS", "QUERY_KEY flexibility");
        descriptor.addMapping((DatabaseMapping)shaftMapping);
        OneToOneMapping manufacturerMapping = new OneToOneMapping();
        manufacturerMapping.setAttributeName("manufacturer");
        manufacturerMapping.setGetMethodName("getManufacturer");
        manufacturerMapping.setSetMethodName("setManufacturer");
        manufacturerMapping.setReferenceClass(Manufacturer.class);
        manufacturerMapping.dontUseIndirection();
        manufacturerMapping.addForeignKeyFieldName("GOLF_CLUB.MANUFACTURER_ID", "MANUFACTURER.ID");
        descriptor.addMapping((DatabaseMapping)manufacturerMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildGolfClubShaftDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(GolfClubShaft.class);
        descriptor.setAlias("GolfClubShaft");
        descriptor.addDirectQueryKey("flexibility", "QUERY_KEY flexibility");
        DirectToFieldMapping stiffnessRatingMapping = new DirectToFieldMapping();
        stiffnessRatingMapping.setAttributeName("stiffnessRating");
        stiffnessRatingMapping.setFieldName("SHAFT_STIFFNESS");
        descriptor.addMapping((DatabaseMapping)stiffnessRatingMapping);
        OneToOneMapping manufacturerMapping = new OneToOneMapping();
        manufacturerMapping.setAttributeName("manufacturer");
        manufacturerMapping.setReferenceClass(Manufacturer.class);
        manufacturerMapping.dontUseIndirection();
        manufacturerMapping.addForeignKeyFieldName("GOLF_CLUB.SHAFT_MANUFACTURER_ID", "MANUFACTURER.ID");
        descriptor.addMapping((DatabaseMapping)manufacturerMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildHouseDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(House.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("HOUSE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGENT_ID");
        descriptor.addPrimaryKeyFieldName("LOCATION");
        descriptor.descriptorIsAggregateCollection();
        descriptor.useTimestampLocking("VERSION", false);
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(House.class, (Object)"H");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(TownHouse.class, (Object)"TH");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(SingleHouse.class, (Object)"SH");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateCollectionMapping aggregatecollectionmapping = new AggregateCollectionMapping();
        aggregatecollectionmapping.setAttributeName("sellingPoints");
        aggregatecollectionmapping.setIsReadOnly(false);
        aggregatecollectionmapping.setUsesIndirection(false);
        aggregatecollectionmapping.useBatchReading();
        aggregatecollectionmapping.setGetMethodName("getSellingPoints");
        aggregatecollectionmapping.setSetMethodName("setSellingPoints");
        aggregatecollectionmapping.setReferenceClass(SellingPoint.class);
        aggregatecollectionmapping.addTargetForeignKeyFieldName("SELLING_POINT.AGENT_ID", "HOUSE.AGENT_ID");
        aggregatecollectionmapping.addTargetForeignKeyFieldName("SELLING_POINT.LOCATION", "HOUSE.LOCATION");
        descriptor.addMapping((DatabaseMapping)aggregatecollectionmapping);
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("insuranceId");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getInsuranceId");
        aggregateobjectmapping.setSetMethodName("setInsuranceId");
        aggregateobjectmapping.setReferenceClass(Oid.class);
        aggregateobjectmapping.addFieldNameTranslation("HOUSE.INS_ID", "ID");
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("location");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getLocation");
        directtofieldmapping.setSetMethodName("setLocation");
        directtofieldmapping.setFieldName("LOCATION");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("descriptions");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getDescriptions");
        directtofieldmapping2.setSetMethodName("setDescriptions");
        directtofieldmapping2.setFieldName("DESCRIPTIONS");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("version");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getVersion");
        directtofieldmapping3.setSetMethodName("setVersion");
        directtofieldmapping3.setFieldName("VERSION");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildJobDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Job.class);
        descriptor.setAmendmentClass(AggregateProject.class);
        descriptor.setAmendmentMethodName("amendJobDescriptor");
        Vector<String> vector = new Vector<String>();
        vector.addElement("WORKER");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("title");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getTitle");
        directtofieldmapping.setSetMethodName("setTitle");
        directtofieldmapping.setFieldName("WORKER.TITLE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        TransformationMapping transformationmapping = new TransformationMapping();
        transformationmapping.setAttributeName("normalHours");
        transformationmapping.setIsReadOnly(false);
        transformationmapping.setUsesIndirection(false);
        transformationmapping.setGetMethodName("getNormalHours");
        transformationmapping.setSetMethodName("setNormalHours");
        transformationmapping.setAttributeTransformation("getNormalHoursFromRow");
        DatabaseField field = new DatabaseField("WORKER.END_TIME");
        field.setType(Time.class);
        transformationmapping.addFieldTransformation(field, "getEndTime");
        field = new DatabaseField("WORKER.START_TIME");
        field.setType(Time.class);
        transformationmapping.addFieldTransformation(field, "getStartTime");
        descriptor.addMapping((DatabaseMapping)transformationmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    public static void amendJobDescriptor(ClassDescriptor descriptor) {
        TransformationMapping transformationmapping = (TransformationMapping)descriptor.getMappingForAttributeName("normalHours");
        transformationmapping.getFieldTransformations().clear();
        DatabaseField field = new DatabaseField("WORKER.END_TIME");
        field.setType(Time.class);
        transformationmapping.addFieldTransformation(field, "getEndTime");
        field = new DatabaseField("WORKER.START_TIME");
        field.setType(Time.class);
        transformationmapping.addFieldTransformation(field, "getStartTime");
    }

    protected void buildLanguageDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Language.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_LAN");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_LAN.ID");
        descriptor.getDescriptorQueryManager().checkDatabaseForDoesExist();
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_LAN.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("language");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_LAN.LANG");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildManufacturerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Manufacturer.class);
        descriptor.addTableName("MANUFACTURER");
        descriptor.addPrimaryKeyFieldName("MANUFACTURER.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("Manufacturer");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.getDescriptorQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setGetMethodName("getId");
        idMapping.setSetMethodName("setId");
        idMapping.setFieldName("MANUFACTURER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setGetMethodName("getName");
        nameMapping.setSetMethodName("setName");
        nameMapping.setFieldName("MANUFACTURER.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildOidDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Oid.class);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        descriptor.addDirectMapping("id", "ID");
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPeriodDescriptionDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PeriodDescription.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("endPeriod");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(Period.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        aggregateobjectmapping.addFieldNameTranslation("AGG_EMP.EM_EEDATE", "AGG_EMP.EM_EDATE");
        aggregateobjectmapping.addFieldNameTranslation("AGG_EMP.EM_ESDATE", "AGG_EMP.EM_SDATE");
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        AggregateObjectMapping aggregateobjectmapping1 = new AggregateObjectMapping();
        aggregateobjectmapping1.setAttributeName("period");
        aggregateobjectmapping1.setIsReadOnly(false);
        aggregateobjectmapping1.setGetMethodName("getPeriod");
        aggregateobjectmapping1.setSetMethodName("setPeriod");
        aggregateobjectmapping1.setReferenceClass(Period.class);
        aggregateobjectmapping1.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Period.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("endDate");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_EMP.EM_EDATE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("startDate");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_EMP.EM_SDATE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildProjectDescriptionDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(ProjectDescription.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_EMP");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getDescription");
        directtofieldmapping.setSetMethodName("setDescription");
        directtofieldmapping.setFieldName("AGG_EMP.EM_PDESC");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_EMP.EM_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("languages");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(true);
        manytomanymapping.setReferenceClass(Language.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("EMP_LAN");
        manytomanymapping.addSourceRelationKeyFieldName("EMP_LAN.EMP_ID", "AGG_EMP.EM_ID");
        manytomanymapping.addTargetRelationKeyFieldName("EMP_LAN.LAN_ID", "AGG_LAN.ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("responsibilities");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(true);
        onetomanymapping.setReferenceClass(Responsibility.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("AGG_RES.EMP_ID", "AGG_EMP.EM_ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("computer");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(Computer.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("AGG_EMP.COMP_ID", "AGG_COM.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildResponsibilityDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Responsibility.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGG_RES");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGG_RES.ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGG_RES.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("responsibility");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGG_RES.DUTY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("AGG_RES.EMP_ID", "AGG_EMP.EM_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildRoomSellingPointDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(RoomSellingPoint.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(SellingPoint.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("SELLING_POINT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.LOCATION");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AREA");
        descriptor.descriptorIsAggregateCollection();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("squareFeet");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getSquareFeet");
        directtofieldmapping.setSetMethodName("setSquareFeet");
        directtofieldmapping.setFieldName("SELLING_POINT.SQUARE_FEET");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildSellingPointDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SellingPoint.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("SELLING_POINT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.LOCATION");
        descriptor.addPrimaryKeyFieldName("SELLING_POINT.AREA");
        descriptor.descriptorIsAggregateCollection();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(SellingPoint.class, (Object)"SP");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(RoomSellingPoint.class, (Object)"R");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("area");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getArea");
        directtofieldmapping.setSetMethodName("setArea");
        directtofieldmapping.setFieldName("AREA");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("description");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getDescription");
        directtofieldmapping2.setSetMethodName("setDescription");
        directtofieldmapping2.setFieldName("SELLING_POINT.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildSingleHouseDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SingleHouse.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(House.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("SINGLE_HOUSE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SINGLE_HOUSE.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("SINGLE_HOUSE.LOCATION");
        descriptor.descriptorIsAggregateCollection();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("numberOfGarages");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getNumberOfGarages");
        directtofieldmapping.setSetMethodName("setNumberOfGarages");
        directtofieldmapping.setFieldName("SINGLE_HOUSE.GARAGE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildTownHouseDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(TownHouse.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(House.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("HOUSE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("HOUSE.AGENT_ID");
        descriptor.addPrimaryKeyFieldName("HOUSE.LOCATION");
        descriptor.descriptorIsAggregateCollection();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildTransportDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Transport.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("AGGVEHICLE.ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("vehicle");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getVehicle");
        aggregateobjectmapping.setSetMethodName("setVehicle");
        aggregateobjectmapping.setReferenceClass(Vehicle.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    public void buildVehicleDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Vehicle.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("AGGVEHICLE");
        descriptor.setTableNames(vector);
        descriptor.descriptorIsAggregate();
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(Car.class, (Object)1);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(Bicycle.class, (Object)2);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("capacity");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("AGGVEHICLE.CAPACITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("colour");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("AGGVEHICLE.COLOUR");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    public void buildVersionDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(Version.class);
        descriptor.setAlias("Version");
        DirectToFieldMapping versionNumberMapping = new DirectToFieldMapping();
        versionNumberMapping.setAttributeName("versionNumber");
        versionNumberMapping.setFieldName("VERSION");
        descriptor.addMapping((DatabaseMapping)versionNumberMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildWorkerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Worker.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("WORKER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("WORKER.ID");
        descriptor.setSequenceNumberName("SEQ_WORKER");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("job");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setGetMethodName("getJob");
        aggregateobjectmapping.setSetMethodName("setJob");
        aggregateobjectmapping.setReferenceClass(Job.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("fName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFName");
        directtofieldmapping.setSetMethodName("setFName");
        directtofieldmapping.setFieldName("WORKER.FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getId");
        directtofieldmapping1.setSetMethodName("setId");
        directtofieldmapping1.setFieldName("WORKER.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLName");
        directtofieldmapping2.setSetMethodName("setLName");
        directtofieldmapping2.setFieldName("WORKER.LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

