/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.inheritance.Person;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.testing.tests.expressions.ReadAllOuterJoinExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.ReadAllOuterJoinExpressionTest2;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ExpressionOuterJoinTestSuite
extends TestSuite {
    protected PopulationManager manager;

    public ExpressionOuterJoinTestSuite() {
        this.setDescription("This suite tests expressions.");
    }

    private void addOuterJoinJoiningComplexTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Project.class, 15);
        test.setName("OuterJoinJoiningComplexTest");
        test.setDescription("Test joining with outer joins");
        ReadAllQuery query = new ReadAllQuery(Project.class);
        query.addJoinedAttribute(emp.getAllowingNull("teamLeader"));
        test.setQuery(query);
        this.addTest((Test)test);
    }

    private void addOuterJoinAcrossInheritanceTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Person.class, 1);
        test.setName("OuterJoinAcrossInheritanceTest");
        test.setDescription("Test joining with outer joins across inheritance");
        ReadAllQuery query = new ReadAllQuery(Person.class);
        query.addOrdering(emp.getAllowingNull("representitive").get("name"));
        test.setQuery(query);
        this.addTest((Test)test);
    }

    private void addOuterJoinJoiningTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 12);
        test.setName("OuterJoinJoiningTest");
        test.setDescription("Test joining with outer joins");
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addJoinedAttribute(emp.getAllowingNull("address"));
        test.setQuery(query);
        this.addTest((Test)test);
    }

    private void addOuterJoinJoiningTest2() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ReadAllOuterJoinExpressionTest2 test = new ReadAllOuterJoinExpressionTest2(PolicyHolder.class, 4);
        test.setName("OuterJoinJoiningTest2");
        test.setDescription("Test joining with outer joins");
        ReadAllQuery query = new ReadAllQuery(PolicyHolder.class);
        query.addJoinedAttribute(emp.getAllowingNull("address"));
        test.setQuery(query);
        this.addTest((Test)test);
    }

    private void addOuterJoinManyToManyTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").like("%").or(emp.anyOfAllowingNone("projects").get("description").like("%"));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 12);
        test.setName("OuterJoinManytoManyTest");
        test.setDescription("Tests manytomany relationships with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrAnyWhereClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").like("Sarah%").or(emp.anyOfAllowingNone("phoneNumbers").get("areaCode").equal((Object)"613"));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 10);
        test.setName("OuterJoinOrAnyWhereClauseTest");
        test.setDescription("Test expression anyof with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrderByComplexTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 12);
        test.setName("OuterJoinOrderByComplexTest");
        test.setDescription("Test order by with outer joins");
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addOrdering(emp.getAllowingNull("manager").get("firstName"));
        test.setQuery(query);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrderByTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 12);
        test.setName("OuterJoinOrderByTest");
        test.setDescription("Test order by with outer joins");
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addOrdering(emp.getAllowingNull("address").get("city"));
        test.setQuery(query);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrWhereClauseTest1() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").like("Bob%").or(emp.getAllowingNull("address").get("city").like("Ot%"));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 2);
        test.setName("OuterJoinOrWhereClauseTest1");
        test.setDescription("Test expression with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrWhereClauseTest2() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").like("Sarah%").or(emp.getAllowingNull("manager").get("firstName").like("Sarah%"));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 3);
        test.setName("OuterJoinOrWhereClauseTest2");
        test.setDescription("Test expression with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrWhereClauseTest3() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").like("Sarah%").and(emp.get("lastName").like("Smit%")).or(emp.getAllowingNull("manager").get("firstName").like("Sarah%").and(emp.getAllowingNull("manager").get("lastName").like("Smit%")));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 2);
        test.setName("OuterJoinOrWhereClauseTest3");
        test.setDescription("Test expression with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinOrWhereClauseTest4() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").like("Bob%").or(emp.getAllowingNull("address").get("city").like("Ot%").and(emp.getAllowingNull("address").get("city").like("%wa")));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 2);
        test.setName("OuterJoinOrWhereClauseTest4");
        test.setDescription("Test expression with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinSimpleTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.getAllowingNull("address").get("city").equal((Object)"Ottawa");
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 1);
        test.setName("OuterJoinSimpleTest");
        test.setDescription("Test expression with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinGetOnClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression address = emp.getAllowingNull("address");
        emp.join(address, address.get("city").notEqual((Object)"Ottawa"));
        Expression expression = address.get("city").equal((Object)"Ottawa");
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 0);
        test.setName("OuterJoinGetOnClauseTest");
        test.setDescription("Test expression with outer joins and on clause");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinAnyOfOnClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression phone = emp.anyOfAllowingNone("phoneNumbers");
        emp.join(phone, phone.get("areaCode").notEqual((Object)"613"));
        Expression expression = phone.get("areaCode").equal((Object)"613");
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 0);
        test.setName("OuterJoinAnyOfOnClauseTest");
        test.setDescription("Test expression with outer joins and on clause");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addJoinAnyOfOnClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression phone = emp.anyOf("phoneNumbers");
        emp.join(phone, phone.get("areaCode").notEqual((Object)"613"));
        Expression expression = phone.get("areaCode").equal((Object)"613");
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 0);
        test.setName("JoinAnyOfOnClauseTest");
        test.setDescription("Test expression with outer joins and on clause");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addJoinGetOnClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression address = emp.get("address");
        emp.join(address, address.get("city").notEqual((Object)"Ottawa"));
        Expression expression = address.get("city").equal((Object)"Ottawa");
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 0);
        test.setName("JoinGetOnClauseTest");
        test.setDescription("Test expression with outer joins and on clause");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addJoinOnClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder(Employee.class);
        ExpressionBuilder project = new ExpressionBuilder(Project.class);
        emp.join((Expression)project, project.get("teamLeader").equal((Expression)emp));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 3);
        test.setName("JoinOnClauseTest");
        test.setDescription("Test expression with parrallel joins and on clause");
        test.setExpression(null);
        test.getQuery(true).setExpressionBuilder(emp);
        test.getQuery(true).addNonFetchJoin((Expression)project);
        this.addTest((Test)test);
    }

    private void addOuterJoinOnClauseTest() {
        ExpressionBuilder emp = new ExpressionBuilder(Employee.class);
        ExpressionBuilder project = new ExpressionBuilder(Project.class);
        emp.leftJoin((Expression)project, project.get("teamLeader").equal((Expression)emp));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 12);
        test.setName("OuterJoinOnClauseTest");
        test.setDescription("Test expression with parrallel joins and on clause");
        test.setExpression(null);
        test.getQuery(true).setExpressionBuilder(emp);
        test.getQuery(true).addNonFetchJoin((Expression)project);
        this.addTest((Test)test);
    }

    private void addOuterJoinDirectCollectionTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").equal((Object)"Nancy").or(emp.anyOfAllowingNone("responsibilitiesList").equal((Object)"Write lots of Java code."));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 2);
        test.setName("OuterJoinDirectCollectionTest");
        test.setDescription("Tests direct collection relationships with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinIsNullTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("firstName").equal((Object)"Bob").or(emp.getAllowingNull("address").isNull()).or(emp.getAllowingNull("address").get("city").equal((Object)"Ottawa"));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 2);
        test.setName("OuterJoinIsNullTest");
        test.setDescription("Test using isNull with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    private void addOuterJoinParallelExpressionTest() {
        ExpressionBuilder emp = new ExpressionBuilder(Employee.class);
        ExpressionBuilder addr = new ExpressionBuilder(Address.class);
        Expression expression = emp.get("firstName").equal((Object)"Bob").or(emp.getAllowingNull("address").get("city").equal((Object)"Ottawa")).or(emp.getAllowingNull("address").equal((Expression)addr).and(addr.get("city").equal((Object)"Ottawa")));
        ReadAllOuterJoinExpressionTest test = new ReadAllOuterJoinExpressionTest(Employee.class, 22);
        test.setName("OuterJoinParallelExpressionTest");
        test.setDescription("Test using isNull with outer joins");
        test.setExpression(expression);
        this.addTest((Test)test);
    }

    public void addTests() {
        this.setManager(PopulationManager.getDefaultManager());
        this.addOuterJoinSimpleTest();
        this.addOuterJoinOrWhereClauseTest1();
        this.addOuterJoinOrWhereClauseTest2();
        this.addOuterJoinOrWhereClauseTest3();
        this.addOuterJoinOrWhereClauseTest4();
        this.addOuterJoinOrderByTest();
        this.addOuterJoinOrderByComplexTest();
        this.addOuterJoinJoiningTest();
        this.addOuterJoinManyToManyTest();
        this.addOuterJoinJoiningTest2();
        this.addOuterJoinJoiningComplexTest();
        this.addOuterJoinOrAnyWhereClauseTest();
        this.addOuterJoinAcrossInheritanceTest();
        this.addOuterJoinDirectCollectionTest();
        this.addOuterJoinParallelExpressionTest();
        this.addOuterJoinIsNullTest();
        this.addOuterJoinGetOnClauseTest();
        this.addJoinGetOnClauseTest();
        this.addOuterJoinAnyOfOnClauseTest();
        this.addJoinAnyOfOnClauseTest();
        this.addOuterJoinOnClauseTest();
        this.addJoinOnClauseTest();
    }

    protected PopulationManager getManager() {
        return this.manager;
    }

    protected void setManager(PopulationManager theManager) {
        this.manager = theManager;
    }
}

