/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.Camera;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullDirectToFieldValueTest
extends SwitchableOptimisticLockingPolicyTest {
    protected Camera original;
    protected Camera original2;

    public UpdateNullDirectToFieldValueTest(Class<?> optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(Camera.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new Camera();
        this.original.setName(null);
        this.original2 = new Camera();
        this.original2.setName("LookyHere");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAssertAndChangeAttributeValue(null, "LookyThere");
            this.readObjectAssertAndChangeAttributeValue("LookyThere", null);
            this.readObjectAssertAndChangeAttributeValue(null, "DumbCam");
            this.readObjectAssertAndChangeAttributeValue("DumbCam", null);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
        }
    }

    public void readObjectAssertAndChangeAttributeValue(String expectedAttributeValue, String newAttributeValue) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Camera clone = (Camera)uow.readObject(Camera.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullDirectToFieldValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        UpdateNullDirectToFieldValueTest.assertEquals((String)("The object's field should be [" + expectedAttributeValue + "]"), (String)expectedAttributeValue, (String)clone.getName());
        clone.setName(newAttributeValue);
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

