/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class BatchReadingTest
extends TestCase {
    BatchFetchType batchType;
    public Vector result;

    public BatchReadingTest(BatchFetchType batchType) {
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void setup() {
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Restaurant.class);
        query.addBatchReadAttribute("menus");
        this.result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        Vector v = manager.getAllObjectsForClass(Restaurant.class);
        Enumeration enumtr = this.result.elements();
        while (enumtr.hasMoreElements()) {
            Restaurant resDatabase = (Restaurant)enumtr.nextElement();
            Enumeration enum1 = v.elements();
            while (enum1.hasMoreElements()) {
                Restaurant resPop = (Restaurant)enum1.nextElement();
                if (!resDatabase.getName().equals(resPop.getName()) || ((AbstractSession)this.getSession()).compareObjects((Object)resDatabase, (Object)resPop)) continue;
                throw new TestErrorException("Batchreading - one To Many Relationship : Object from database (" + resDatabase + ")is not equal to Object from PopulationManager(" + resPop + ")");
            }
        }
    }
}

