/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.legacy.Shipment;

public class NestedBatchReadingNPETest
extends TestCase {
    public Vector result;
    BatchFetchType batchType;

    public NestedBatchReadingNPETest(BatchFetchType batchType) {
        this.setDescription("Tests batch reading nesting across 1-m and 1-1 mappings, shipment, orders and employee");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        if (this.batchType == BatchFetchType.IN && !this.getSession().getPlatform().isOracle()) {
            this.throwWarning("Nested arrays not supported on this database");
        }
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setBatchFetchType(this.batchType);
        query.setReferenceClass(Shipment.class);
        ExpressionBuilder expression = query.getExpressionBuilder();
        Expression expression2List = expression.anyOfAllowingNone("orders");
        query.addBatchReadAttribute(expression2List);
        query.addBatchReadAttribute(expression2List.getAllowingNull("employee").getAllowingNull("computer"));
        this.result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
    }
}

