/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.EmployeeCustomSQLSystem;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class EmployeeCustomSQLMWIntegrationSystem
extends EmployeeCustomSQLSystem {
    public static String PROJECT_FILE = "MWIntegrationCustomSQLEmployeeProject";
    public ClassDescriptor employeeDescriptor;

    public EmployeeCustomSQLMWIntegrationSystem() {
        this(PROJECT_FILE);
    }

    public EmployeeCustomSQLMWIntegrationSystem(String fileName) {
        this.initializeProject(this.getInitialProject(), fileName);
    }

    public Project getInitialProject() {
        EmployeeProject initialProject = new EmployeeProject();
        this.employeeDescriptor = (ClassDescriptor)initialProject.getDescriptors().get(Employee.class);
        this.addQueries();
        return initialProject;
    }

    public void initializeProject(Project initialProject, String fileName) {
        XMLProjectWriter.write((String)(fileName + ".xml"), (Project)initialProject);
        this.project = XMLProjectReader.read((String)(fileName + ".xml"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    @Override
    public void createTables(DatabaseSession session) {
        super.createTables(session);
        DatabasePlatform platform = session.getLogin().getPlatform();
        SchemaManager schema = new SchemaManager(session);
        if (platform.isOracle()) {
            // empty if block
        }
    }

    public void addQueries() {
        this.buildStoredProcedureCallInQueryIntoDescriptor();
        this.buildUNamedStoredProcedureCallInQueryIntoDescriptor();
        this.buildNamedQueryWithStoredFunctionIntoDescriptor();
    }

    public StoredProcedureDefinition buildOracleStoredProcedureForProjectXML() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        return proc;
    }

    public void buildStoredProcedureCallInQueryIntoDescriptor() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("StoredProcedure_InOut_Out_In");
        call.addNamedInOutputArgumentValue("P_INOUT", (Object)100, "P_INOUT_FIELD_NAME", Integer.class);
        call.addNamedOutputArgument("P_OUT", "P_OUT_FIELD_NAME", Integer.class);
        call.addNamedArgumentValue("P_IN", (Object)1000);
        DataReadQuery dataReadQuery = new DataReadQuery();
        dataReadQuery.setCall((Call)call);
        this.employeeDescriptor.getQueryManager().addQuery("StoredProcedureCallInDataReadQuery", (DatabaseQuery)dataReadQuery);
    }

    public void buildUNamedStoredProcedureCallInQueryIntoDescriptor() {
        StoredProcedureCall unamedcall = new StoredProcedureCall();
        unamedcall.setProcedureName("StoredProcedure_InOut_Out_In");
        unamedcall.addUnamedInOutputArgumentValue((Object)100, "P_INOUT_FIELD_NAME", Integer.class);
        unamedcall.addUnamedOutputArgument("P_OUT_FIELD_NAME", Integer.class);
        unamedcall.addUnamedArgumentValue((Object)1000);
        DataReadQuery unameddataReadQuery = new DataReadQuery();
        unameddataReadQuery.setCall((Call)unamedcall);
        this.employeeDescriptor.getQueryManager().addQuery("UNamedStoredProcedureCallInDataReadQuery", (DatabaseQuery)unameddataReadQuery);
    }

    public void buildNamedQueryWithStoredFunctionIntoDescriptor() {
        DataReadQuery drq = new DataReadQuery();
        drq.setName("StoredFunctionCallInNamedQuery");
        drq.addArgument("P_INOUT", Long.class);
        drq.addArgument("P_IN", Long.class);
        StoredFunctionCall sfc = new StoredFunctionCall();
        sfc.setProcedureName("StoredFunction_InOut_Out_In");
        sfc.addNamedInOutputArgument("P_INOUT", "P_INOUT", Long.class);
        sfc.addNamedOutputArgument("P_OUT", "P_OUT", Long.class);
        sfc.addNamedArgument("P_IN", "P_IN", Long.class);
        sfc.setResult("", Long.class);
        drq.addCall((Call)sfc);
        this.employeeDescriptor.getQueryManager().addQuery("StoredFunctionCallInNamedQuery", (DatabaseQuery)drq);
    }
}

