/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.FieldResult;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class EntityResult
extends SQLResult {
    protected String entityClassName;
    protected transient Class<?> entityClass;
    protected Map fieldResults;
    protected DatabaseField discriminatorColumn;

    public EntityResult(Class<?> entityClass) {
        this.entityClass = entityClass;
        if (this.entityClass == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_entity_result"));
        }
        this.entityClassName = entityClass.getName();
    }

    public EntityResult(String entityClassName) {
        this.entityClassName = entityClassName;
        if (this.entityClassName == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_entity_result"));
        }
    }

    public void addFieldResult(FieldResult fieldResult) {
        if (fieldResult == null || fieldResult.getAttributeName() == null) {
            return;
        }
        FieldResult existingFieldResult = (FieldResult)this.getFieldResults().get(fieldResult.getAttributeName());
        if (existingFieldResult == null) {
            this.getFieldResults().put(fieldResult.getAttributeName(), fieldResult);
        } else {
            existingFieldResult.add(fieldResult);
        }
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class entityClass;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            entityClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        entityClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.entityClassName, true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.entityClassName, exception.getException());
                    }
                }
                entityClass = PrivilegedAccessHelper.getClassForName(this.entityClassName, true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.entityClassName, exc);
            }
        }
        this.entityClass = entityClass;
    }

    public Map getFieldResults() {
        if (this.fieldResults == null) {
            this.fieldResults = new HashMap();
        }
        return this.fieldResults;
    }

    public DatabaseField getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(String column) {
        if (column == null) {
            return;
        }
        this.discriminatorColumn = new DatabaseField(column);
    }

    public void setDiscriminatorColumn(DatabaseField column) {
        if (column == null) {
            return;
        }
        this.discriminatorColumn = column;
    }

    @Override
    public Object getValueFromRecord(DatabaseRecord record, ResultSetMappingQuery query) {
        CoreDescriptor descriptor = query.getSession().getDescriptor((Class)this.entityClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("@EntityResult: entityClass points to unknown entity: " + (this.entityClass != null ? this.entityClass.getName() : "null"));
        }
        DatabaseRecord entityRecord = new DatabaseRecord(((ClassDescriptor)descriptor).getFields().size());
        if (((ClassDescriptor)descriptor).hasInheritance()) {
            Object value = null;
            if (this.discriminatorColumn == null) {
                value = record.get(((ClassDescriptor)descriptor).getInheritancePolicy().getClassIndicatorField());
            } else {
                value = record.getIndicatingNoEntry(this.discriminatorColumn);
                if (value == AbstractRecord.noEntry) {
                    throw QueryException.discriminatorColumnNotSelected(this.discriminatorColumn.getName(), this.getSQLResultMapping().getName());
                }
            }
            entityRecord.put(((ClassDescriptor)descriptor).getInheritancePolicy().getClassIndicatorField(), value);
            if (((ClassDescriptor)descriptor).getInheritancePolicy().shouldReadSubclasses()) {
                Class<?> classValue = ((ClassDescriptor)descriptor).getInheritancePolicy().classFromRow(entityRecord, query.getSession());
                descriptor = query.getSession().getDescriptor((Class)classValue);
            }
        }
        for (DatabaseMapping mapping : ((ClassDescriptor)descriptor).getMappings()) {
            FieldResult fieldResult = (FieldResult)this.getFieldResults().get(mapping.getAttributeName());
            if (fieldResult != null) {
                if (mapping.getFields().size() == 1) {
                    entityRecord.put(mapping.getFields().firstElement(), record.get(fieldResult.getColumn()));
                    continue;
                }
                if (mapping.getFields().size() <= 1) continue;
                this.getValueFromRecordForMapping(entityRecord, mapping, fieldResult, record);
                continue;
            }
            for (DatabaseField field : mapping.getFields()) {
                entityRecord.put(field, record.get(field));
            }
        }
        query.setReferenceClass(this.entityClass);
        query.setDescriptor((ClassDescriptor)descriptor);
        return ((ClassDescriptor)descriptor).getObjectBuilder().buildObject(query, entityRecord, null);
    }

    @Override
    public boolean isEntityResult() {
        return true;
    }

    public void getValueFromRecordForMapping(DatabaseRecord entityRecord, DatabaseMapping mapping, FieldResult fieldResult, DatabaseRecord databaseRecord) {
        ClassDescriptor currentDescriptor = mapping.getReferenceDescriptor();
        if (fieldResult.getFieldResults() == null) {
            DatabaseField dbfield = this.processValueFromRecordForMapping(currentDescriptor, fieldResult.getMultipleFieldIdentifiers(), 1);
            if (mapping.isOneToOneMapping()) {
                dbfield = ((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(dbfield);
            }
            entityRecord.put(dbfield, databaseRecord.get(fieldResult.getColumn()));
            return;
        }
        for (FieldResult tempFieldResult : fieldResult.getFieldResults()) {
            DatabaseField dbfield = this.processValueFromRecordForMapping(currentDescriptor, tempFieldResult.getMultipleFieldIdentifiers(), 1);
            if (mapping.isOneToOneMapping()) {
                dbfield = ((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(dbfield);
            }
            entityRecord.put(dbfield, databaseRecord.get(tempFieldResult.getColumn()));
        }
    }

    public DatabaseField processValueFromRecordForMapping(ClassDescriptor descriptor, String[] attributeNames, int currentLoc) {
        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(attributeNames[currentLoc]);
        if (mapping == null) {
            throw QueryException.mappingForFieldResultNotFound(attributeNames, currentLoc);
        }
        if (attributeNames.length != ++currentLoc) {
            ClassDescriptor currentDescriptor = mapping.getReferenceDescriptor();
            DatabaseField df = this.processValueFromRecordForMapping(currentDescriptor, attributeNames, currentLoc);
            if (mapping.isOneToOneMapping()) {
                return ((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(df);
            }
            return df;
        }
        return mapping.getFields().firstElement();
    }
}

