/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.AggrIterState;
import oracle.kv.impl.query.runtime.FuncMinMaxIter;
import oracle.kv.impl.query.runtime.FuncSumIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncSeqAggrIter
extends PlanIter {
    private final PlanIter theInput;
    private final FunctionLib.FuncCode theCode;

    public FuncSeqAggrIter(Expr e, FunctionLib.FuncCode code, int resultReg, PlanIter input) {
        super(e, resultReg);
        this.theCode = code;
        this.theInput = input;
    }

    FuncSeqAggrIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = FuncSeqAggrIter.readOrdinal(in, FunctionLib.FuncCode.values().length);
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theInput = FuncSeqAggrIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        FuncSeqAggrIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SEQ_AGGR;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new AggrIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInput.next(rcb);
        if (!more) {
            state.done();
            return false;
        }
        switch (this.theCode) {
            case FN_SEQ_COUNT: {
                this.nextCount(rcb, state);
                break;
            }
            case FN_SEQ_SUM: 
            case FN_SEQ_AVG: {
                this.nextSumAvg(rcb, state);
                break;
            }
            case FN_SEQ_MIN: 
            case FN_SEQ_MAX: {
                this.nextMinMax(rcb, state);
                break;
            }
            default: {
                throw new QueryStateException("Unexpected function: " + (Object)((Object)this.theCode));
            }
        }
        state.done();
        return true;
    }

    private void nextCount(RuntimeControlBlock rcb, AggrIterState state) {
        boolean more = true;
        while (more) {
            ++state.theCount;
            more = this.theInput.next(rcb);
        }
        rcb.setRegVal(this.theResultReg, FieldDefImpl.longDef.createLong(state.theCount));
    }

    private void nextSumAvg(RuntimeControlBlock rcb, AggrIterState state) {
        FieldValueImpl res;
        block13: {
            block12: {
                boolean more = true;
                while (more) {
                    FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
                    if (val.isNull()) {
                        rcb.setRegVal(this.theResultReg, val);
                        return;
                    }
                    FuncSumIter.sumNewValue(state, val);
                    more = this.theInput.next(rcb);
                }
                res = null;
                if (this.theCode != FunctionLib.FuncCode.FN_SEQ_SUM) break block12;
                switch (state.theSumType) {
                    case LONG: {
                        res = FieldDefImpl.longDef.createLong(state.theLongSum);
                        break block13;
                    }
                    case DOUBLE: {
                        res = FieldDefImpl.doubleDef.createDouble(state.theDoubleSum);
                        break block13;
                    }
                    case NUMBER: {
                        res = FieldDefImpl.numberDef.createNumber(state.theNumberSum);
                        break block13;
                    }
                    default: {
                        throw new QueryStateException("Unexpected result type for SUM function: " + state.theSumType);
                    }
                }
            }
            switch (state.theSumType) {
                case LONG: {
                    double avg = (double)state.theLongSum / (double)state.theCount;
                    res = FieldDefImpl.doubleDef.createDouble(avg);
                    break;
                }
                case DOUBLE: {
                    double avg = state.theDoubleSum / (double)state.theCount;
                    res = FieldDefImpl.doubleDef.createDouble(avg);
                    break;
                }
                case NUMBER: {
                    BigDecimal bcount = new BigDecimal(state.theCount);
                    BigDecimal bavg = state.theNumberSum.divide(bcount, rcb.getMathContext());
                    res = FieldDefImpl.numberDef.createNumber(bavg);
                    break;
                }
                default: {
                    throw new QueryStateException("Unexpected result type for SUM function: " + state.theSumType);
                }
            }
        }
        rcb.setRegVal(this.theResultReg, res);
    }

    private void nextMinMax(RuntimeControlBlock rcb, AggrIterState state) {
        boolean more = true;
        while (more) {
            FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
            if (val.isNull()) {
                rcb.setRegVal(this.theResultReg, val);
                return;
            }
            FuncMinMaxIter.minmaxNewVal(rcb, state, this.theCode, this.theLocation, val);
            more = this.theInput.next(rcb);
        }
        rcb.setRegVal(this.theResultReg, state.theMinMax);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

