/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import oracle.kv.impl.security.MethodHandler;

final class MethodHandlerUtils {
    private MethodHandlerUtils() {
    }

    static Object invokeMethod(Object target, Method method, Object[] args) throws Exception {
        try {
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    static <T> T[] stripAuthCtxArg(T[] args) {
        T[] newArgs = Arrays.copyOfRange(args, 0, args.length - 1);
        newArgs[newArgs.length - 1] = args[args.length - 1];
        return newArgs;
    }

    static class StripAuthCtxHandler
    implements MethodHandler {
        private final Object target;
        private final Method useMethod;

        StripAuthCtxHandler(Object target, Method method) {
            this.target = target;
            Class<?>[] newTypes = MethodHandlerUtils.stripAuthCtxArg(method.getParameterTypes());
            try {
                Method newMethod;
                this.useMethod = newMethod = target.getClass().getMethod(method.getName(), newTypes);
            }
            catch (NoSuchMethodException nsme) {
                throw new UnsupportedOperationException("Unable to call method " + method.getName() + " on a pre-R3 implementation");
            }
        }

        @Override
        public Object invoke(Method method, Object[] args) throws Exception {
            return MethodHandlerUtils.invokeMethod(this.target, this.useMethod, MethodHandlerUtils.stripAuthCtxArg(args));
        }
    }

    static class DirectHandler
    implements MethodHandler {
        private final Object target;

        DirectHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Method method, Object[] args) throws Exception {
            return MethodHandlerUtils.invokeMethod(this.target, method, args);
        }
    }
}

