/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampUtils;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.NumberValue;
import oracle.kv.table.StringValue;
import oracle.kv.table.TimestampValue;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class FieldValueFactory {
    public static FieldValue createValueFromJson(String jsonString) {
        return FieldValueFactory.createValueFromJson((FieldDef)FieldDefImpl.jsonDef, jsonString);
    }

    public static FieldValue createValueFromJson(Reader jsonReader) throws IOException {
        return FieldValueFactory.createValueFromJson((FieldDef)FieldDefImpl.jsonDef, jsonReader);
    }

    public static FieldValue createValueFromJson(FieldDef type, String jsonString) {
        if (jsonString == null) {
            throw new IllegalArgumentException("Not a valid JSON input.");
        }
        switch (type.getType()) {
            case ARRAY: {
                ArrayValueImpl arrayValue = ((ArrayDefImpl)type).createArray();
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(jsonString.getBytes());
                ComplexValueImpl.createFromJson(arrayValue, jsonInput, false);
                return arrayValue;
            }
            case BINARY: {
                int l = jsonString.length();
                if (jsonString.charAt(0) != '\"' || jsonString.charAt(l - 1) != '\"' || l <= 1) {
                    throw new IllegalArgumentException("Invalid input for BinaryValue: " + jsonString);
                }
                return ((BinaryDefImpl)type).fromString(jsonString.substring(1, l - 1));
            }
            case BOOLEAN: {
                if ("true".equals(jsonString.toLowerCase())) {
                    return FieldValueFactory.createBoolean(true);
                }
                if ("false".equals(jsonString.toLowerCase())) {
                    return FieldValueFactory.createBoolean(false);
                }
                throw new IllegalArgumentException("Illegal input for a BooleanValue");
            }
            case DOUBLE: {
                try {
                    return FieldValueFactory.createDouble(Double.parseDouble(jsonString));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Failed to parse DoubleValue: " + e.getMessage(), e);
                }
            }
            case ENUM: {
                int l = jsonString.length();
                if (jsonString.charAt(0) != '\"' || jsonString.charAt(l - 1) != '\"' || l <= 1) {
                    throw new IllegalArgumentException("Invalid input for a StringValue: " + jsonString);
                }
                return ((EnumDefImpl)type).createEnum(jsonString.substring(1, l - 1));
            }
            case FIXED_BINARY: {
                int l = jsonString.length();
                if (jsonString.charAt(0) != '\"' || jsonString.charAt(l - 1) != '\"' || l <= 1) {
                    throw new IllegalArgumentException("Invalid input for FixedBinaryValue: " + jsonString);
                }
                return ((FixedBinaryDefImpl)type).fromString(jsonString.substring(1, l - 1));
            }
            case FLOAT: {
                try {
                    return FieldValueFactory.createFloat(Float.parseFloat(jsonString));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Failed to parse FloatValue: " + e.getMessage(), e);
                }
            }
            case INTEGER: {
                try {
                    return FieldValueFactory.createInteger(Integer.parseInt(jsonString));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Failed to parse IntegerValue: " + e.getMessage(), e);
                }
            }
            case LONG: {
                try {
                    return FieldValueFactory.createLong(Long.parseLong(jsonString));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Failed to parse LongValue: " + e.getMessage(), e);
                }
            }
            case NUMBER: {
                try {
                    return FieldValueFactory.createNumber(new BigDecimal(jsonString));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Failed to parse NumberValue: Malformed numeric value: " + jsonString, e);
                }
            }
            case TIMESTAMP: {
                int l = jsonString.length();
                if (jsonString.charAt(0) != '\"' || jsonString.charAt(l - 1) != '\"' || l <= 1) {
                    throw new IllegalArgumentException("Invalid input for TimestampValue: " + jsonString);
                }
                return ((TimestampDefImpl)type).fromString(jsonString.substring(1, l - 1));
            }
            case MAP: {
                MapValueImpl mapValue = ((MapDefImpl)type).createMap();
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(jsonString.getBytes());
                ComplexValueImpl.createFromJson(mapValue, jsonInput, false);
                return mapValue;
            }
            case RECORD: {
                RecordValueImpl recordValue = ((RecordDefImpl)type).createRecord();
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(jsonString.getBytes());
                ComplexValueImpl.createFromJson(recordValue, jsonInput, false);
                return recordValue;
            }
            case STRING: {
                int l = jsonString.length();
                if (jsonString.charAt(0) != '\"' || jsonString.charAt(l - 1) != '\"' || l <= 1) {
                    throw new IllegalArgumentException("Invalid input for a StringValue: " + jsonString);
                }
                return ((StringDefImpl)type).createString(jsonString.substring(1, l - 1));
            }
            case JSON: {
                StringReader reader = new StringReader(jsonString);
                try {
                    FieldValue fieldValue = FieldValueFactory.createValueFromJson((FieldDef)FieldDefImpl.jsonDef, reader);
                    return fieldValue;
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Unable to parse JSON input: " + jsonString + ": " + ioe);
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new IllegalArgumentException("Type not supported by fromJson: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldValue createValueFromJson(FieldDef type, Reader jsonReader) throws IOException {
        try (JsonParser jp = null;){
            jp = TableJsonUtils.createJsonParser(jsonReader);
            FieldValue fieldValue = FieldValueFactory.fromJson(type, jp);
            return fieldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldValue createValueFromJson(FieldDef type, InputStream jsonStream) throws IOException {
        try (JsonParser jp = null;){
            jp = TableJsonUtils.createJsonParser(jsonStream);
            FieldValue fieldValue = FieldValueFactory.fromJson(type, jp);
            return fieldValue;
        }
    }

    private static FieldValue fromJson(FieldDef type, JsonParser jp) throws IOException {
        switch (type.getType()) {
            case ARRAY: {
                ArrayValueImpl arrayValue = ((ArrayDefImpl)type).createArray();
                jp.nextToken();
                arrayValue.addJsonFields(jp, null, false, true);
                arrayValue.validate();
                return arrayValue;
            }
            case BINARY: {
                JsonToken t = jp.nextToken();
                if (t == JsonToken.VALUE_STRING) {
                    return ((BinaryDefImpl)type).fromString(jp.getText());
                }
                throw new IllegalArgumentException("Invalid input for BinaryValue.");
            }
            case BOOLEAN: {
                JsonToken t = jp.nextToken();
                return FieldValueFactory.createBoolean(jp.getBooleanValue());
            }
            case DOUBLE: {
                JsonToken t = jp.nextToken();
                return FieldValueFactory.createDouble(jp.getDoubleValue());
            }
            case ENUM: {
                JsonToken t = jp.nextToken();
                if (t == JsonToken.VALUE_STRING) {
                    return ((EnumDefImpl)type).createEnum(jp.getText());
                }
                throw new IllegalArgumentException("Invalid input for StringValue.");
            }
            case FIXED_BINARY: {
                JsonToken t = jp.nextToken();
                if (t == JsonToken.VALUE_STRING) {
                    return ((FixedBinaryDefImpl)type).fromString(jp.getText());
                }
                throw new IllegalArgumentException("Invalid input for FixedBinaryValue.");
            }
            case FLOAT: {
                JsonToken t = jp.nextToken();
                return FieldValueFactory.createFloat(jp.getFloatValue());
            }
            case INTEGER: {
                JsonToken t = jp.nextToken();
                return FieldValueFactory.createInteger(jp.getIntValue());
            }
            case LONG: {
                JsonToken t = jp.nextToken();
                return FieldValueFactory.createLong(jp.getLongValue());
            }
            case NUMBER: {
                JsonToken t = jp.nextToken();
                return FieldValueFactory.createNumber(TableJsonUtils.jsonParserGetDecimalValue(jp));
            }
            case TIMESTAMP: {
                JsonToken t = jp.nextToken();
                if (t == JsonToken.VALUE_STRING) {
                    return ((TimestampDefImpl)type).fromString(jp.getText());
                }
                throw new IllegalArgumentException("Invalid input for TimestampValue.");
            }
            case MAP: {
                MapValueImpl mapValue = ((MapDefImpl)type).createMap();
                jp.nextToken();
                mapValue.addJsonFields(jp, null, false, true);
                mapValue.validate();
                return mapValue;
            }
            case RECORD: {
                RecordValueImpl recordValue = ((RecordDefImpl)type).createRecord();
                jp.nextToken();
                recordValue.addJsonFields(jp, null, false, true);
                recordValue.validate();
                return recordValue;
            }
            case STRING: {
                JsonToken t = jp.nextToken();
                if (t == JsonToken.VALUE_STRING) {
                    return ((StringDefImpl)type).createString(jp.getText());
                }
                throw new IllegalArgumentException("Invalid input for StringValue.");
            }
            case JSON: {
                return JsonDefImpl.createFromJson(jp, true);
            }
        }
        throw new IllegalArgumentException("Type not supported by fromJson: " + type);
    }

    public static BinaryValue createBinary(byte[] v) {
        return FieldDefImpl.binaryDef.createBinary(v);
    }

    public static BooleanValue createBoolean(boolean v) {
        return FieldDefImpl.booleanDef.createBoolean(v);
    }

    public static DoubleValue createDouble(double v) {
        return FieldDefImpl.doubleDef.createDouble(v);
    }

    public static FloatValue createFloat(float v) {
        return FieldDefImpl.floatDef.createFloat(v);
    }

    public static IntegerValue createInteger(int v) {
        return FieldDefImpl.integerDef.createInteger(v);
    }

    public static LongValue createLong(long v) {
        return FieldDefImpl.longDef.createLong(v);
    }

    public static NumberValue createNumber(int v) {
        return FieldDefImpl.numberDef.createNumber(v);
    }

    public static NumberValue createNumber(long v) {
        return FieldDefImpl.numberDef.createNumber(v);
    }

    public static NumberValue createNumber(float v) {
        return FieldDefImpl.numberDef.createNumber(v);
    }

    public static NumberValue createNumber(double v) {
        return FieldDefImpl.numberDef.createNumber(v);
    }

    public static NumberValue createNumber(BigDecimal v) {
        return FieldDefImpl.numberDef.createNumber(v);
    }

    public static FieldValue createJsonNull() {
        return FieldDefImpl.jsonDef.createJsonNull();
    }

    public static StringValue createString(String v) {
        return FieldDefImpl.stringDef.createString(v);
    }

    public static TimestampValue createTimestamp(Timestamp v, int precision) {
        if (precision < 0 || precision >= FieldDefImpl.timestampDefs.length) {
            throw new IllegalArgumentException("Invalid precision, it should be in range from 0 to " + (FieldDefImpl.timestampDefs.length - 1) + ": " + precision);
        }
        return FieldDefImpl.timestampDefs[precision].createTimestamp(v);
    }

    public static TimestampValue createTimestamp(String s, int precision) {
        if (precision < 0 || precision >= FieldDefImpl.timestampDefs.length) {
            throw new IllegalArgumentException("Invalid precision, it should be in range from 0 to " + (FieldDefImpl.timestampDefs.length - 1) + ": " + precision);
        }
        return FieldDefImpl.timestampDefs[precision].fromString(s);
    }

    public static TimestampValue createTimestamp(int year, int month, int day, int hour, int minute, int second, int fracSeconds, int precision) {
        if (precision < 0 || precision >= FieldDefImpl.timestampDefs.length) {
            throw new IllegalArgumentException("Invalid precision, it should be in range from 0 to " + (FieldDefImpl.timestampDefs.length - 1) + ": " + precision);
        }
        TimestampUtils.validateComponent(0, year);
        TimestampUtils.validateComponent(1, month);
        TimestampUtils.validateComponent(2, day);
        TimestampUtils.validateComponent(3, hour);
        TimestampUtils.validateComponent(4, minute);
        TimestampUtils.validateComponent(5, second);
        if (precision == 0) {
            if (fracSeconds != 0) {
                throw new IllegalArgumentException("Invalid fracSeconds, it should be 0 with precision 0");
            }
        } else {
            int max = (int)Math.pow(10.0, precision) - 1;
            if (fracSeconds < 0 || fracSeconds > max) {
                throw new IllegalArgumentException("Invalid fracSeconds, it should be in range 0 ~ " + max);
            }
        }
        byte[] bytes = TimestampUtils.toBytes(year, month, day, hour, minute, second, fracSeconds, precision);
        return FieldDefImpl.timestampDefs[precision].createTimestamp(bytes);
    }
}

