/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedChild;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedParent;

public class IsolatedOneToManyQueryModificationTest
extends TestCase {
    public IsolatedOneToManyQueryModificationTest() {
        this.setDescription("IsolatedOneToManyQueryModificationTest");
    }

    public void test() {
        IsolatedParent exampleParent = IsolatedParent.buildIsolatedParentExample2();
        for (int i = 0; i < 100; ++i) {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            exampleParent = (IsolatedParent)uow.readObject((Object)exampleParent);
            IsolatedParent result = (IsolatedParent)uow.executeQuery("findParentBySerial", IsolatedParent.class, (Object)exampleParent.getSerial());
            IsolatedOneToManyQueryModificationTest.assertNotNull((String)"Parent should not be null", (Object)result);
            IsolatedOneToManyQueryModificationTest.assertNotNull((String)"Parent should not have a null collection", result.getChildren());
            IsolatedOneToManyQueryModificationTest.assertEquals((String)"Parent should be the same id", (String)exampleParent.getId(), (String)result.getId());
            IsolatedOneToManyQueryModificationTest.assertEquals((String)"Parent should be the same serial", (String)exampleParent.getSerial(), (String)result.getSerial());
            IsolatedOneToManyQueryModificationTest.assertEquals((String)"Parent should not have a zero length collection", (int)exampleParent.getChildren().size(), (int)result.getChildren().size());
            IsolatedChild child = result.getChildren().get(0);
            IsolatedChild exampleChild = exampleParent.getChildren().get(0);
            IsolatedOneToManyQueryModificationTest.assertNotNull((String)"Only child should not be null", (Object)child);
            IsolatedOneToManyQueryModificationTest.assertEquals((String)"Only child should have the same id", (String)exampleChild.getId(), (String)child.getId());
            IsolatedOneToManyQueryModificationTest.assertNotNull((String)"Only child should have a valid parent", (Object)child.getParent());
            IsolatedOneToManyQueryModificationTest.assertEquals((String)"Only child should reference the found parent", (Object)result, (Object)child.getParent());
            uow.release();
        }
    }
}

