/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.isolatedsession.ClientServerTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedSessionEventAdaptor;

public class VerifyExclusiveConnectionTest
extends ClientServerTest {
    public boolean isPostEventFired = false;
    public boolean isPreEventFired = false;

    public VerifyExclusiveConnectionTest() {
        super(true);
        this.setDescription("This test verifies that an exclusive connection is created for the client. and the appropriate events are thrown.");
    }

    public VerifyExclusiveConnectionTest(String exclusiveConnectionMode, boolean isIsolated) {
        super(exclusiveConnectionMode, isIsolated);
        Object str = exclusiveConnectionMode;
        if (isIsolated) {
            str = (String)str + "_Isolated";
        }
        this.setDescription("This test verifies that an exclusive connection is created for the client and the appropriate events are thrown. " + (String)str);
        this.setName(this.getName() + " " + (String)str);
    }

    @Override
    public void test() {
        this.server.getEventManager().addListener((SessionEventListener)new IsolatedSessionEventAdaptor(this));
        ((Session)this.clients.get(0)).readObject(IsolatedEmployee.class);
        ((Session)this.clients.get(0)).release();
        this.clients.remove(0);
    }

    @Override
    public void verify() {
        if (!this.isPostEventFired) {
            throw new TestErrorException("The post acquire Exclusive Connection event was not fired");
        }
        if (!this.isPreEventFired) {
            throw new TestErrorException("The pre release Exclusive Connection event was not fired");
        }
    }

    @Override
    public void setup() {
        super.setup();
        this.isPostEventFired = false;
        this.isPreEventFired = false;
    }
}

