/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TranslatedStringsTest
extends AutoVerifyTestCase {
    protected List translatedSQLStrings = null;
    protected List sqlStrings = null;
    protected List calls = null;
    protected String translatedSQLString = null;
    protected String sqlString = null;
    protected Call call;

    public TranslatedStringsTest() {
        this.setDescription("Ensure it is possible to get the translated strings from a multiple call query.");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void test() {
        Employee employee = new Employee();
        employee.setFirstName("Sonny");
        employee.setLastName("Corleone");
        employee.setSalary(1000);
        WriteObjectQuery query = new WriteObjectQuery((Object)employee);
        this.getSession().getDescriptor(Employee.class).getEventManager().addListener((DescriptorEventListener)new DescriptorEventAdapter(){

            public void postInsert(DescriptorEvent event) {
                TranslatedStringsTest.this.translatedSQLStrings = event.getQuery().getTranslatedSQLStrings((Session)event.getSession(), (DataRecord)event.getQuery().getTranslationRow());
                TranslatedStringsTest.this.sqlStrings = event.getQuery().getSQLStrings();
                TranslatedStringsTest.this.calls = event.getQuery().getDatasourceCalls();
                TranslatedStringsTest.this.translatedSQLString = event.getQuery().getTranslatedSQLString((Session)event.getSession(), (DataRecord)event.getQuery().getTranslationRow());
                TranslatedStringsTest.this.sqlString = event.getQuery().getSQLString();
                TranslatedStringsTest.this.call = event.getQuery().getCall();
            }
        });
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.translatedSQLStrings.size() != 2) {
            throw new TestErrorException("Translated SQL Strings were not properly returned.");
        }
        if (this.sqlStrings.size() != 2) {
            throw new TestErrorException("SQL Strings were not properly returned.");
        }
        if (this.calls.size() != 2) {
            throw new TestErrorException("Calls were not properly returned.");
        }
        if (this.translatedSQLString != null) {
            throw new TestErrorException("Translated SQL String was returned even though it should be null..");
        }
        if (this.sqlString == null) {
            throw new TestErrorException("SQL String was not returned even though it should have been.");
        }
        if (this.call == null) {
            throw new TestErrorException("A Call was not returned even though it should have been..");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }
}

