/*
 * Copyright (c) 2011, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
// Oracle = 2.2 - Initial implementation
package org.eclipse.persistence.testing.jaxb.classloader;

import java.net.URL;
import java.net.URLClassLoader;

import jakarta.xml.bind.JAXBContext;

import org.eclipse.persistence.jaxb.JAXBContextFactory;

import junit.framework.TestCase;

public class InnerClassTestCases extends TestCase {

    public void testCreateContext() throws Exception {
        Class<?>[] classes = new Class<?>[1];

        URL[] urls = new URL[1];
        urls[0] = Thread.currentThread().getContextClassLoader().getResource("org/eclipse/persistence/testing/jaxb/classloader/innerClass.jar");
        URLClassLoader classLoader = new URLClassLoader(urls);

        Class<?> classAClass = classLoader.loadClass("org.eclipse.persistence.testing.jaxb.classloader.ClassWithInnerClass");

        classes[0] = classAClass;
        JAXBContext ctx = JAXBContextFactory.createContext(classes, null, Thread.currentThread().getContextClassLoader());

    }

}
