/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.xml.parser;

import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLNodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathEngine {
    private static final String ATTRIBUTE = "@";
    private static final String TEXT = "text()";
    private static final String ALL_CHILDREN = "child::*";
    private static final String NAMESPACE_URI = "https://jakarta.ee/xml/ns/persistence/orm";
    private static final String OLD_NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence/orm";
    private static XPathEngine instance = null;

    private XPathEngine() {
    }

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    public Node selectSingleNode(Node contextNode, String[] xPathFragments) {
        if (contextNode == null) {
            return null;
        }
        return this.selectSingleNode(contextNode, xPathFragments, 0);
    }

    private Node selectSingleNode(Node contextNode, String[] xPathFragments, int index) {
        Node resultNode = this.getSingleNode(contextNode, xPathFragments[index]);
        if (resultNode == null || xPathFragments.length == index + 1) {
            return resultNode;
        }
        return this.selectSingleNode(resultNode, xPathFragments, index + 1);
    }

    public NodeList selectNodes(Node contextNode, String[] xPathFragments) {
        if (contextNode == null) {
            return null;
        }
        return this.selectNodes(contextNode, xPathFragments, 0);
    }

    private NodeList selectNodes(Node contextNode, String[] xPathFragments, int index) {
        NodeList resultNodes = this.getNodes(contextNode, xPathFragments[index]);
        if (xPathFragments.length != index + 1) {
            XMLNodeList result = new XMLNodeList();
            int numberOfResultNodes = resultNodes.getLength();
            for (int x = 0; x < numberOfResultNodes; ++x) {
                Node resultNode = resultNodes.item(x);
                result.addAll(this.selectNodes(resultNode, xPathFragments, index + 1));
            }
            return result;
        }
        return resultNodes;
    }

    private Node getSingleNode(Node contextNode, String xPathFragment) {
        if (xPathFragment.startsWith(ATTRIBUTE)) {
            return this.selectSingleAttribute(contextNode, xPathFragment);
        }
        if (TEXT.equals(xPathFragment)) {
            return this.selectSingleText(contextNode);
        }
        return this.selectSingleElement(contextNode, xPathFragment);
    }

    private NodeList getNodes(Node contextNode, String xPathFragment) {
        if (xPathFragment.startsWith(ATTRIBUTE)) {
            return this.selectAttributeNodes(contextNode, xPathFragment);
        }
        if (TEXT.equals(xPathFragment)) {
            return this.selectTextNodes(contextNode);
        }
        if (xPathFragment.equals(ALL_CHILDREN)) {
            return this.selectChildElements(contextNode);
        }
        return this.selectElementNodes(contextNode, xPathFragment);
    }

    private Node selectSingleAttribute(Node contextNode, String xPathFragment) {
        Element contextElement = (Element)contextNode;
        return contextElement.getAttributeNode(xPathFragment.substring(1));
    }

    private NodeList selectAttributeNodes(Node contextNode, String xPathFragment) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = this.selectSingleAttribute(contextNode, xPathFragment);
        if (null != child) {
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleElement(Node contextNode, String xPathFragment) {
        for (Node child = contextNode.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !this.sameName(child, xPathFragment) || !this.sameNamespaceURI(child, NAMESPACE_URI) && !this.sameNamespaceURI(child, OLD_NAMESPACE_URI)) continue;
            return child;
        }
        return null;
    }

    private NodeList selectChildElements(Node contextNode) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        for (Node child = contextNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private NodeList selectElementNodes(Node contextNode, String xPathFragment) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        for (Node child = contextNode.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !this.sameName(child, xPathFragment) || !this.sameNamespaceURI(child, NAMESPACE_URI) && !this.sameNamespaceURI(child, OLD_NAMESPACE_URI)) continue;
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleText(Node contextNode) {
        NodeList childrenNodes = contextNode.getChildNodes();
        if (childrenNodes.getLength() == 0) {
            return null;
        }
        if (childrenNodes.getLength() == 1) {
            Node child = childrenNodes.item(0);
            if (child.getNodeType() == 3) {
                return child;
            }
            return null;
        }
        Object returnVal = null;
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            String val;
            Node next = childrenNodes.item(i);
            if (next.getNodeType() != 3 || (val = next.getNodeValue()) == null) continue;
            if (returnVal == null) {
                returnVal = "";
            }
            returnVal = (String)returnVal + val;
        }
        if (returnVal != null) {
            return contextNode.getOwnerDocument().createTextNode((String)returnVal);
        }
        return null;
    }

    private NodeList selectTextNodes(Node contextNode) {
        Node n = this.selectSingleText(contextNode);
        XMLNodeList xmlNodeList = new XMLNodeList();
        if (n != null) {
            xmlNodeList.add(n);
        }
        return xmlNodeList;
    }

    private boolean sameNamespaceURI(Node node, String namespaceURI) {
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI == namespaceURI) {
            return true;
        }
        if (nodeNamespaceURI == null && namespaceURI.equals("")) {
            return true;
        }
        if (namespaceURI == null && nodeNamespaceURI.equals("")) {
            return true;
        }
        return null != nodeNamespaceURI && nodeNamespaceURI.equals(namespaceURI);
    }

    private boolean sameName(Node node, String name) {
        return name.equals(node.getLocalName()) || name.equals(node.getNodeName());
    }
}

