/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.descriptors.WrapperPolicy;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.descriptors.copying.InstantiationCopyPolicy;
import org.eclipse.persistence.descriptors.copying.PersistenceEntityCopyPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.MappingCompare;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
implements Cloneable,
Serializable {
    protected Class javaClass;
    protected String javaClassName;
    protected Vector<DatabaseTable> tables = NonSynchronizedVector.newInstance(3);
    protected transient DatabaseTable defaultTable;
    protected List<DatabaseField> primaryKeyFields;
    protected transient Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields;
    protected transient Vector<DatabaseTable> multipleTableInsertOrder;
    protected transient Map<DatabaseTable, Set<DatabaseTable>> multipleTableForeignKeys;
    protected transient Vector<DatabaseField> fields;
    protected transient Vector<DatabaseField> allFields;
    protected Vector<DatabaseMapping> mappings = NonSynchronizedVector.newInstance();
    protected List<DatabaseMapping> lockableMappings;
    protected Map<String, QueryKey> queryKeys;
    protected Class identityMapClass;
    protected Class remoteIdentityMapClass = null;
    protected int identityMapSize = -1;
    protected int remoteIdentityMapSize = -1;
    protected String sequenceNumberName;
    protected DatabaseField sequenceNumberField;
    protected transient String sessionName;
    protected boolean shouldAlwaysRefreshCache = false;
    protected boolean shouldOnlyRefreshCacheIfNewerVersion = false;
    protected boolean shouldDisableCacheHits = false;
    protected transient Vector constraintDependencies;
    protected transient String amendmentMethodName;
    protected transient Class amendmentClass;
    protected transient String amendmentClassName;
    protected boolean shouldAlwaysRefreshCacheOnRemote = false;
    protected boolean shouldDisableCacheHitsOnRemote = false;
    protected String alias;
    protected boolean shouldBeReadOnly = false;
    protected boolean shouldAlwaysConformResultsInUnitOfWork = false;
    protected Boolean isIsolated;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected DescriptorEventManager eventManager;
    protected DescriptorQueryManager queryManager;
    protected ObjectBuilder objectBuilder;
    protected CopyPolicy copyPolicy;
    protected String copyPolicyClassName;
    protected InstantiationPolicy instantiationPolicy;
    protected InheritancePolicy inheritancePolicy;
    protected InterfacePolicy interfacePolicy;
    protected OptimisticLockingPolicy optimisticLockingPolicy;
    protected Vector cascadeLockingPolicies;
    protected WrapperPolicy wrapperPolicy;
    protected ObjectChangePolicy changePolicy;
    protected ReturningPolicy returningPolicy;
    protected HistoryPolicy historyPolicy;
    protected CMPPolicy cmpPolicy;
    protected FetchGroupManager fetchGroupManager;
    protected Map properties;
    protected transient int initializationStage = 0;
    protected transient int interfaceInitializationStage = 0;
    protected static final int UNINITIALIZED = 0;
    protected static final int PREINITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int POST_INITIALIZED = 3;
    protected static final int ERROR = -1;
    protected int descriptorType = 0;
    protected static final int NORMAL = 0;
    protected static final int INTERFACE = 1;
    protected static final int AGGREGATE = 2;
    protected static final int AGGREGATE_COLLECTION = 3;
    protected boolean shouldOrderMappings = true;
    protected CacheInvalidationPolicy cacheInvalidationPolicy = null;
    protected boolean shouldAcquireCascadedLocks = false;
    protected boolean hasSimplePrimaryKey = false;
    protected int cacheSynchronizationType = 1;
    public static final int UNDEFINED_OBJECT_CHANGE_BEHAVIOR = 0;
    public static final int SEND_OBJECT_CHANGES = 1;
    public static final int INVALIDATE_CHANGED_OBJECTS = 2;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES = 3;
    public static final int DO_NOT_SEND_CHANGES = 4;
    protected int unitOfWorkCacheIsolationLevel = -1;
    public static final int UNDEFINED_ISOLATATION = -1;
    public static final int USE_SESSION_CACHE_AFTER_TRANSACTION = 0;
    public static final int ISOLATE_NEW_DATA_AFTER_TRANSACTION = 1;
    public static final int ISOLATE_CACHE_AFTER_TRANSACTION = 2;
    public static final int ISOLATE_CACHE_ALWAYS = 3;
    public static boolean shouldUseFullChangeSetsForNewObjects = false;
    protected boolean isNativeConnectionRequired;
    protected IdValidation idValidation;
    protected Class cacheInterceptorClass;
    protected String cacheInterceptorClassName;
    protected QueryRedirector defaultQueryRedirector;
    protected QueryRedirector defaultReadAllQueryRedirector;
    protected QueryRedirector defaultReadObjectQueryRedirector;
    protected QueryRedirector defaultReportQueryRedirector;
    protected QueryRedirector defaultUpdateObjectQueryRedirector;
    protected QueryRedirector defaultInsertObjectQueryRedirector;
    protected QueryRedirector defaultDeleteObjectQueryRedirector;
    protected String defaultQueryRedirectorClassName;
    protected String defaultReadAllQueryRedirectorClassName;
    protected String defaultReadObjectQueryRedirectorClassName;
    protected String defaultReportQueryRedirectorClassName;
    protected String defaultUpdateObjectQueryRedirectorClassName;
    protected String defaultInsertObjectQueryRedirectorClassName;
    protected String defaultDeleteObjectQueryRedirectorClassName;
    protected Sequence sequence;
    protected List<DatabaseMapping> mappingsPostCalculateChanges;
    protected List<DatabaseMapping> mappingsPostCalculateChangesOnDeleted;

    public ClassDescriptor() {
        this.primaryKeyFields = new ArrayList<DatabaseField>(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap<DatabaseTable, Set<DatabaseTable>>(5);
        this.queryKeys = new HashMap<String, QueryKey>(5);
        this.objectBuilder = new ObjectBuilder(this);
        this.cascadeLockingPolicies = NonSynchronizedVector.newInstance();
    }

    public void addAbstractQueryKey(String queryKeyName) {
        QueryKey queryKey = new QueryKey();
        queryKey.setName(queryKeyName);
        this.addQueryKey(queryKey);
    }

    public void addCascadeLockingPolicy(CascadeLockingPolicy policy) {
        this.cascadeLockingPolicies.add(policy);
        if (this.hasInheritance()) {
            Iterator anIterator = this.getInheritancePolicy().getAllChildDescriptors().iterator();
            while (anIterator.hasNext()) {
                ((ClassDescriptor)anIterator.next()).addCascadeLockingPolicy(policy);
            }
        }
        if (!(this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || !this.isInitialized(2))) {
            Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
            while (mappings.hasMoreElements()) {
                this.prepareCascadeLockingPolicy(mappings.nextElement());
            }
        }
    }

    public void addConstraintDependencies(Class dependencies) {
        this.addConstraintDependency(dependencies);
    }

    public void addConstraintDependency(Class dependencies) {
        this.getConstraintDependencies().add(dependencies);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setAttributeName(attributeName);
        mapping.setFieldName(fieldName);
        return this.addMapping(mapping);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        mapping.setFieldName(fieldName);
        return this.addMapping(mapping);
    }

    public void addDirectQueryKey(String queryKeyName, String fieldName) {
        DirectQueryKey queryKey = new DirectQueryKey();
        DatabaseField field = new DatabaseField(fieldName);
        queryKey.setName(queryKeyName);
        queryKey.setField(field);
        this.getQueryKeys().put(queryKeyName, queryKey);
    }

    public void addForeignKeyFieldNameForMultipleTable(String sourceForeignKeyFieldName, String targetPrimaryKeyFieldName) throws DescriptorException {
        this.addForeignKeyFieldForMultipleTable(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField sourceForeignKeyField, DatabaseField targetPrimaryKeyField) throws DescriptorException {
        if (!sourceForeignKeyField.hasTableName() || !targetPrimaryKeyField.hasTableName()) {
            throw DescriptorException.multipleTablePrimaryKeyMustBeFullyQualified(this);
        }
        this.setAdditionalTablePrimaryKeyFields(sourceForeignKeyField.getTable(), targetPrimaryKeyField, sourceForeignKeyField);
        Set<DatabaseTable> sourceTables = this.getMultipleTableForeignKeys().get(targetPrimaryKeyField.getTable());
        if (sourceTables == null) {
            sourceTables = new HashSet<DatabaseTable>(3);
            this.getMultipleTableForeignKeys().put(targetPrimaryKeyField.getTable(), sourceTables);
        }
        sourceTables.add(sourceForeignKeyField.getTable());
    }

    public DatabaseMapping addMapping(DatabaseMapping mapping) {
        if (mapping.getDescriptor() == null) {
            mapping.setDescriptor(this);
        }
        this.getMappings().addElement(mapping);
        return mapping;
    }

    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isRelationalMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void addPrimaryKeyFieldName(String fieldName) {
        this.getPrimaryKeyFields().add(new DatabaseField(fieldName));
    }

    public void addPrimaryKeyField(DatabaseField field) {
        this.getPrimaryKeyFields().add(field);
    }

    public void addQueryKey(QueryKey queryKey) {
        this.getQueryKeys().put(queryKey.getName(), queryKey);
    }

    public void addTable(DatabaseTable table) {
        this.getTables().addElement(table);
    }

    public void addTableName(String tableName) {
        this.addTable(new DatabaseTable(tableName));
    }

    public void adjustMultipleTableInsertOrder() {
        if (this.getMultipleTableInsertOrder() == null || this.getMultipleTableInsertOrder().isEmpty()) {
            this.createMultipleTableInsertOrder();
        } else {
            this.verifyMultipleTableInsertOrder();
        }
        this.toggleAdditionalTablePrimaryKeyFields();
    }

    public void alwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(true);
    }

    public void alwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(true);
    }

    public void alwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(true);
    }

    public void applyAmendmentMethod() {
        this.applyAmendmentMethod(null);
    }

    public void applyAmendmentMethod(DescriptorEvent event) {
        if (this.getAmendmentClass() == null || this.getAmendmentMethodName() == null) {
            return;
        }
        Method method = null;
        Class[] argTypes = new Class[]{ClassDescriptor.class};
        try {
            method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
        }
        catch (Exception ignore) {
            argTypes[0] = ClassDescriptor.class;
            try {
                method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
            }
            catch (Exception exception) {
                throw DescriptorException.invalidAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
            }
        }
        Object[] args = new Object[]{this};
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedMethodInvoker(method, null, args));
            } else {
                PrivilegedAccessHelper.invokeMethod(method, null, args);
            }
        }
        catch (Exception exception) {
            throw DescriptorException.errorOccuredInAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
        }
    }

    public boolean arePrimaryKeyFields(Vector fields) {
        if (fields.size() != this.getPrimaryKeyFields().size()) {
            return false;
        }
        Enumeration enumFields = fields.elements();
        while (enumFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)enumFields.nextElement();
            if (this.getPrimaryKeyFields().contains(field)) continue;
            return false;
        }
        return true;
    }

    protected void assignDefaultValues(AbstractSession session) {
        if (this.identityMapSize == -1) {
            this.identityMapSize = session.getProject().getDefaultIdentityMapSize();
        }
        if (this.identityMapClass == null) {
            this.identityMapClass = session.getProject().getDefaultIdentityMapClass();
        }
        if (this.isIsolated == null) {
            this.isIsolated = session.getProject().getDefaultIsIsolated();
        }
    }

    public DatabaseCall buildCallFromStatement(SQLStatement statement, AbstractSession session) {
        DatabaseCall call = statement.buildCall(session);
        if (this.isNativeConnectionRequired()) {
            call.setIsNativeConnectionRequired(true);
        }
        return call;
    }

    public Vector buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseField buildField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        DatabaseTable table = field.hasTableName() ? this.getTable(field.getTableName()) : (this.getDefaultTable() != null ? this.getDefaultTable() : this.getTable(this.getTableName()));
        field.setTable(table);
        return field;
    }

    public DatabaseField buildField(DatabaseField field) {
        DatabaseField builtField = this.getObjectBuilder().getFieldsMap().get(field);
        if (builtField == null) {
            builtField = field;
            DatabaseTable table = field.hasTableName() ? this.getTable(field.getTableName()) : this.getDefaultTable();
            field.setTable(table);
            this.getObjectBuilder().getFieldsMap().put(builtField, builtField);
        }
        return builtField;
    }

    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromForeignKeys(Vector foreignKeys, String referenceDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    protected void checkDatabase(AbstractSession session) {
        if (session.getIntegrityChecker().shouldCheckDatabase()) {
            for (DatabaseTable table : this.getTables()) {
                if (session.getIntegrityChecker().checkTable(table, session)) {
                    ArrayList<Object> databaseFields = new ArrayList<Object>();
                    Vector result = session.getAccessor().getColumnInfo(null, null, table.getName(), null, session);
                    if (result.isEmpty() && session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                        result = session.getAccessor().getColumnInfo(null, null, table.getName().toLowerCase(), null, session);
                    }
                    for (AbstractRecord row : result) {
                        if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                            databaseFields.add(((String)row.get("COLUMN_NAME")).toUpperCase());
                            continue;
                        }
                        databaseFields.add(row.get("COLUMN_NAME"));
                    }
                    for (DatabaseField field : this.getFields()) {
                        if (!field.getTable().equals(table) || databaseFields.contains(field.getName())) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.fieldIsNotPresentInDatabase(this, table.getName(), field.getName()));
                    }
                    continue;
                }
                session.getIntegrityChecker().handleError(DescriptorException.tableIsNotPresentInDatabase(this));
            }
        }
    }

    public void checkInheritanceTreeAggregateSettings(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.hasInheritance()) {
            return;
        }
        if (this.isChildDescriptor()) {
            Class parentClass = this.getInheritancePolicy().getParentClass();
            if (parentClass == this.getJavaClass()) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            session.getDescriptor(parentClass).checkInheritanceTreeAggregateSettings(session, mapping);
        } else {
            this.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    private void checkInheritanceTreeAggregateSettingsForChildren(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getJavaClass().getName(), mapping));
        }
        Enumeration stream = this.getInheritancePolicy().getChildDescriptors().elements();
        while (stream.hasMoreElements()) {
            ClassDescriptor childDescriptor = (ClassDescriptor)stream.nextElement();
            childDescriptor.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    protected void createMultipleTableInsertOrder() {
        int nParentTables = 0;
        if (this.isChildDescriptor()) {
            nParentTables = this.getInheritancePolicy().getParentDescriptor().getTables().size();
            this.setMultipleTableInsertOrder((Vector)this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder().clone());
            if (nParentTables == this.getTables().size()) {
                return;
            }
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            if (nParentTables == 0) {
                this.setMultipleTableInsertOrder((Vector)this.getTables().clone());
            } else {
                for (int k = nParentTables; k < this.getTables().size(); ++k) {
                    this.getMultipleTableInsertOrder().add(this.getTables().get(k));
                }
            }
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] tableComparison = this.createTableComparison(this.getTables(), nParentTables);
        this.createMultipleTableInsertOrderFromComparison(tableComparison, nParentTables);
    }

    protected void verifyMultipleTableInsertOrder() {
        int nParentTables = 0;
        if (this.isChildDescriptor() && (nParentTables = this.getInheritancePolicy().getParentDescriptor().getTables().size()) + this.getMultipleTableInsertOrder().size() == this.getTables().size()) {
            Vector<DatabaseTable> childMultipleTableInsertOrder = this.getMultipleTableInsertOrder();
            this.setMultipleTableInsertOrder((Vector)this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder().clone());
            this.getMultipleTableInsertOrder().addAll(childMultipleTableInsertOrder);
        }
        if (this.getMultipleTableInsertOrder().size() != this.getTables().size()) {
            throw DescriptorException.multipleTableInsertOrderMismatch(this);
        }
        if (nParentTables == this.getTables().size()) {
            return;
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] tableComparison = this.createTableComparison(this.getMultipleTableInsertOrder(), nParentTables);
        for (int i = nParentTables; i < this.getMultipleTableInsertOrder().size(); ++i) {
            for (int j = i + 1; j < this.getTables().size(); ++j) {
                if (tableComparison[i - nParentTables][j - nParentTables] <= 0) continue;
                throw DescriptorException.insertOrderConflictsWithMultipleTableForeignKeys(this, this.getMultipleTableInsertOrder().get(i), this.getMultipleTableInsertOrder().get(j));
            }
        }
    }

    protected void verifyMultipleTablesForeignKeysTables() {
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable targetTable = entry.getKey();
            if (this.getTables().indexOf(targetTable) == -1) {
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
            }
            for (DatabaseTable sourceTable : entry.getValue()) {
                if (this.getTables().indexOf(sourceTable) != -1) continue;
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
            }
        }
    }

    protected int[][] createTableComparison(Vector tables, int nStart) {
        int nTables = tables.size();
        int[][] tableComparison = new int[nTables - nStart][nTables - nStart];
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable targetTable = entry.getKey();
            int targetIndex = tables.indexOf(targetTable) - nStart;
            if (targetIndex < 0) continue;
            Set<DatabaseTable> sourceTables = entry.getValue();
            for (DatabaseTable sourceTable : sourceTables) {
                int sourceIndex = tables.indexOf(sourceTable) - nStart;
                if (sourceIndex >= 0) {
                    if (tableComparison[targetIndex][sourceIndex] == 1) {
                        throw DescriptorException.insertOrderCyclicalDependencyBetweenTwoTables(this, sourceTable, targetTable);
                    }
                    tableComparison[targetIndex][sourceIndex] = -1;
                    tableComparison[sourceIndex][targetIndex] = 1;
                    continue;
                }
                throw DescriptorException.insertOrderChildBeforeParent(this, sourceTable, targetTable);
            }
        }
        return tableComparison;
    }

    protected void createMultipleTableInsertOrderFromComparison(int[][] tableComparison, int nStart) {
        int[] tableOrder;
        int nTables = this.getTables().size();
        boolean bOk = this.createTableOrder(0, nTables - nStart, tableOrder = new int[nTables - nStart], tableComparison);
        if (bOk) {
            if (nStart == 0) {
                this.setMultipleTableInsertOrder(NonSynchronizedVector.newInstance(nTables));
            }
            for (int k = 0; k < nTables - nStart; ++k) {
                this.getMultipleTableInsertOrder().add(this.getTables().get(tableOrder[k] + nStart));
            }
        } else {
            throw DescriptorException.insertOrderCyclicalDependencyBetweenThreeOrMoreTables(this);
        }
    }

    protected boolean createTableOrder(int k, int nTables, int[] tableOrder, int[][] tableComparison) {
        if (k == nTables) {
            return true;
        }
        int[] iAvailable = new int[nTables - k];
        int l = 0;
        for (int i = 0; i < nTables; ++i) {
            boolean isUsed = false;
            for (int j = 0; j < k && !isUsed; ++j) {
                if (i != tableOrder[j]) continue;
                isUsed = true;
            }
            if (isUsed) continue;
            iAvailable[l] = i;
            ++l;
        }
        boolean bOk = false;
        for (int i = 0; i < nTables - k && !bOk; ++i) {
            boolean isSmallest = true;
            for (int j = 0; j < nTables - k && isSmallest; ++j) {
                if (i == j || tableComparison[iAvailable[i]][iAvailable[j]] <= 0) continue;
                isSmallest = false;
            }
            if (!isSmallest) continue;
            tableOrder[k] = iAvailable[i];
            bOk = this.createTableOrder(k + 1, nTables, tableOrder, tableComparison);
        }
        return bOk;
    }

    public Object clone() {
        ClassDescriptor clonedDescriptor = null;
        try {
            clonedDescriptor = (ClassDescriptor)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NonSynchronizedVector mappingsVector = NonSynchronizedVector.newInstance();
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappingsEnum.nextElement().clone();
            mapping.setDescriptor(clonedDescriptor);
            ((Vector)mappingsVector).addElement(mapping);
        }
        clonedDescriptor.setMappings(mappingsVector);
        HashMap<String, QueryKey> queryKeyVector = new HashMap<String, QueryKey>(this.getQueryKeys().size() + 2);
        Iterator<QueryKey> queryKeysEnum = this.getQueryKeys().values().iterator();
        while (queryKeysEnum.hasNext()) {
            QueryKey queryKey = (QueryKey)queryKeysEnum.next().clone();
            queryKey.setDescriptor(clonedDescriptor);
            queryKeyVector.put(queryKey.getName(), queryKey);
        }
        clonedDescriptor.setQueryKeys(queryKeyVector);
        ArrayList<DatabaseField> primaryKeyVector = new ArrayList<DatabaseField>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKey = (DatabaseField)primaryKeyFields.get(index).clone();
            primaryKeyVector.add(primaryKey);
        }
        clonedDescriptor.setPrimaryKeyFields(primaryKeyVector);
        clonedDescriptor.setFields(NonSynchronizedVector.newInstance());
        if (clonedDescriptor.hasInheritance()) {
            clonedDescriptor.setInheritancePolicy((InheritancePolicy)this.getInheritancePolicy().clone());
            clonedDescriptor.getInheritancePolicy().setDescriptor(clonedDescriptor);
        }
        if (clonedDescriptor.hasReturningPolicy()) {
            clonedDescriptor.setReturningPolicy((ReturningPolicy)this.getReturningPolicy().clone());
            clonedDescriptor.getReturningPolicy().setDescriptor(clonedDescriptor);
        }
        clonedDescriptor.setObjectBuilder((ObjectBuilder)this.getObjectBuilder().clone());
        clonedDescriptor.getObjectBuilder().setDescriptor(clonedDescriptor);
        clonedDescriptor.setEventManager((DescriptorEventManager)this.getEventManager().clone());
        clonedDescriptor.getEventManager().setDescriptor(clonedDescriptor);
        clonedDescriptor.setQueryManager((DescriptorQueryManager)this.getQueryManager().clone());
        clonedDescriptor.getQueryManager().setDescriptor(clonedDescriptor);
        if (this.hasFetchGroupManager()) {
            clonedDescriptor.setFetchGroupManager((FetchGroupManager)this.getFetchGroupManager().clone());
        }
        clonedDescriptor.setIsIsolated(this.isIsolated());
        clonedDescriptor.setInstantiationPolicy((InstantiationPolicy)this.getInstantiationPolicy().clone());
        clonedDescriptor.setCopyPolicy((CopyPolicy)this.getCopyPolicy().clone());
        if (this.getOptimisticLockingPolicy() != null) {
            clonedDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getOptimisticLockingPolicy().clone());
        }
        clonedDescriptor.setObjectChangePolicy(this.getObjectChangePolicyInternal());
        return clonedDescriptor;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block105: {
            Class redirectorClass;
            block104: {
                block103: {
                    block102: {
                        block101: {
                            block100: {
                                block99: {
                                    block98: {
                                        CopyPolicy newCopyPolicy;
                                        Class amendmentClass;
                                        Class descriptorClass;
                                        block97: {
                                            block96: {
                                                block95: {
                                                    descriptorClass = null;
                                                    amendmentClass = null;
                                                    redirectorClass = null;
                                                    newCopyPolicy = null;
                                                    try {
                                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                            try {
                                                                descriptorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getJavaClassName(), true, classLoader));
                                                                break block95;
                                                            }
                                                            catch (PrivilegedActionException exception) {
                                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), exception.getException());
                                                            }
                                                        }
                                                        descriptorClass = PrivilegedAccessHelper.getClassForName(this.getJavaClassName(), true, classLoader);
                                                    }
                                                    catch (ClassNotFoundException exc) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), exc);
                                                    }
                                                }
                                                try {
                                                    if (this.getAmendmentClassName() == null) break block96;
                                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                        try {
                                                            amendmentClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getAmendmentClassName(), true, classLoader));
                                                            break block96;
                                                        }
                                                        catch (PrivilegedActionException exception) {
                                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exception.getException());
                                                        }
                                                    }
                                                    amendmentClass = PrivilegedAccessHelper.getClassForName(this.getAmendmentClassName(), true, classLoader);
                                                }
                                                catch (ClassNotFoundException exc) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exc);
                                                }
                                            }
                                            try {
                                                Class copyPolicyClass = null;
                                                if (this.copyPolicy != null || this.getCopyPolicyClassName() == null) break block97;
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        copyPolicyClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getCopyPolicyClassName(), true, classLoader));
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), exception.getException());
                                                    }
                                                } else {
                                                    copyPolicyClass = PrivilegedAccessHelper.getClassForName(this.getCopyPolicyClassName(), true, classLoader);
                                                }
                                                if (copyPolicyClass == null) break block97;
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        newCopyPolicy = (CopyPolicy)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(copyPolicyClass));
                                                        break block97;
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), exception.getException());
                                                    }
                                                }
                                                newCopyPolicy = (CopyPolicy)PrivilegedAccessHelper.newInstanceFromClass(copyPolicyClass);
                                            }
                                            catch (ClassNotFoundException exc) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), exc);
                                            }
                                            catch (IllegalAccessException ex) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), ex);
                                            }
                                            catch (InstantiationException e) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), e);
                                            }
                                        }
                                        this.setJavaClass(descriptorClass);
                                        if (amendmentClass != null) {
                                            this.setAmendmentClass(amendmentClass);
                                        }
                                        if (newCopyPolicy != null) {
                                            this.setCopyPolicy(newCopyPolicy);
                                        }
                                        try {
                                            if (this.cacheInterceptorClass != null || this.cacheInterceptorClassName == null) break block98;
                                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                try {
                                                    this.cacheInterceptorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.cacheInterceptorClassName, true, classLoader));
                                                    break block98;
                                                }
                                                catch (PrivilegedActionException exception) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.cacheInterceptorClassName, exception.getException());
                                                }
                                            }
                                            this.cacheInterceptorClass = PrivilegedAccessHelper.getClassForName(this.cacheInterceptorClassName, true, classLoader);
                                        }
                                        catch (ClassNotFoundException exc) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.cacheInterceptorClassName, exc);
                                        }
                                    }
                                    if (this.defaultQueryRedirectorClassName != null) {
                                        try {
                                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                try {
                                                    redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultQueryRedirectorClassName, true, classLoader));
                                                }
                                                catch (PrivilegedActionException exception) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exception.getException());
                                                }
                                                try {
                                                    this.setDefaultQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                                    break block99;
                                                }
                                                catch (PrivilegedActionException exception) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exception.getException());
                                                }
                                            }
                                            redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultQueryRedirectorClassName, true, classLoader);
                                            this.setDefaultQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                                        }
                                        catch (ClassNotFoundException exc) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exc);
                                        }
                                        catch (Exception e) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, e);
                                        }
                                    }
                                }
                                if (this.defaultReadObjectQueryRedirectorClassName != null) {
                                    try {
                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                            try {
                                                redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader));
                                            }
                                            catch (PrivilegedActionException exception) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exception.getException());
                                            }
                                            try {
                                                this.setDefaultReadObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                                break block100;
                                            }
                                            catch (PrivilegedActionException exception) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exception.getException());
                                            }
                                        }
                                        redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader);
                                        this.setDefaultReadObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                                    }
                                    catch (ClassNotFoundException exc) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exc);
                                    }
                                    catch (Exception e) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, e);
                                    }
                                }
                            }
                            if (this.defaultReadAllQueryRedirectorClassName != null) {
                                try {
                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                        try {
                                            redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader));
                                        }
                                        catch (PrivilegedActionException exception) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exception.getException());
                                        }
                                        try {
                                            this.setDefaultReadAllQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                            break block101;
                                        }
                                        catch (PrivilegedActionException exception) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exception.getException());
                                        }
                                    }
                                    redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader);
                                    this.setDefaultReadAllQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                                }
                                catch (ClassNotFoundException exc) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exc);
                                }
                                catch (Exception e) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, e);
                                }
                            }
                        }
                        if (this.defaultReportQueryRedirectorClassName != null) {
                            try {
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader));
                                    }
                                    catch (PrivilegedActionException exception) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exception.getException());
                                    }
                                    try {
                                        this.setDefaultReportQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                        break block102;
                                    }
                                    catch (PrivilegedActionException exception) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exception.getException());
                                    }
                                }
                                redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader);
                                this.setDefaultReportQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                            }
                            catch (ClassNotFoundException exc) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exc);
                            }
                            catch (Exception e) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, e);
                            }
                        }
                    }
                    if (this.defaultInsertObjectQueryRedirectorClassName != null) {
                        try {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader));
                                }
                                catch (PrivilegedActionException exception) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exception.getException());
                                }
                                try {
                                    this.setDefaultInsertObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                    break block103;
                                }
                                catch (PrivilegedActionException exception) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exception.getException());
                                }
                            }
                            redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader);
                            this.setDefaultInsertObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                        }
                        catch (ClassNotFoundException exc) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exc);
                        }
                        catch (Exception e) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, e);
                        }
                    }
                }
                if (this.defaultUpdateObjectQueryRedirectorClassName != null) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader));
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exception.getException());
                            }
                            try {
                                this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                break block104;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exception.getException());
                            }
                        }
                        redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader);
                        this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exc);
                    }
                    catch (Exception e) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, e);
                    }
                }
            }
            if (this.defaultDeleteObjectQueryRedirectorClassName != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            redirectorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exception.getException());
                        }
                        try {
                            this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                            break block105;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exception.getException());
                        }
                    }
                    redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader);
                    this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, e);
                }
            }
        }
        Iterator<DatabaseMapping> mappings = this.getMappings().iterator();
        while (mappings.hasNext()) {
            mappings.next().convertClassNamesToClasses(classLoader);
        }
        if (this.inheritancePolicy != null) {
            this.inheritancePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.instantiationPolicy != null) {
            this.instantiationPolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.hasCMPPolicy()) {
            this.getCMPPolicy().convertClassNamesToClasses(classLoader);
        }
        this.queryManager.convertClassNamesToClasses(classLoader);
    }

    public void createCopyPolicy(String policyType) {
        if (policyType.equals("clone")) {
            this.useCloneCopyPolicy();
            return;
        }
        if (policyType.equals("constructor")) {
            this.useInstantiationCopyPolicy();
            return;
        }
    }

    public void createInstantiationPolicy(String policyType) {
        if (policyType.equals("static method")) {
            return;
        }
        if (policyType.equals("constructor")) {
            this.useDefaultConstructorInstantiationPolicy();
            return;
        }
        if (policyType.equals("factory")) {
            return;
        }
    }

    public void descriptorIsAggregate() {
        this.setDescriptorType(2);
    }

    public void descriptorIsAggregateCollection() {
        this.setDescriptorType(3);
    }

    public void descriptorIsForInterface() {
        this.setDescriptorType(1);
    }

    public void descriptorIsNormal() {
        this.setDescriptorType(0);
    }

    public void disableCacheHits() {
        this.setShouldDisableCacheHits(true);
    }

    public void disableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(true);
    }

    public void dontAlwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(false);
    }

    public void dontAlwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(false);
    }

    public void dontAlwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(false);
    }

    public void dontDisableCacheHits() {
        this.setShouldDisableCacheHits(false);
    }

    public void dontDisableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(false);
    }

    public void dontOnlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(false);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.getTables().isEmpty()) {
            if (this.isChildDescriptor()) {
                return this.getInheritancePolicy().getParentDescriptor().extractDefaultTable();
            }
            return null;
        }
        return this.getTables().get(0);
    }

    public Map<DatabaseTable, Map<DatabaseField, DatabaseField>> getAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            this.additionalTablePrimaryKeyFields = new HashMap<DatabaseTable, Map<DatabaseField, DatabaseField>>(5);
        }
        return this.additionalTablePrimaryKeyFields;
    }

    public String getAlias() {
        if (this.alias == null && this.getJavaClassName() != null) {
            this.alias = Helper.getShortClassName(this.getJavaClassName());
        }
        return this.alias;
    }

    public Vector<DatabaseField> getAllFields() {
        return this.allFields;
    }

    public Class getAmendmentClass() {
        return this.amendmentClass;
    }

    public String getAmendmentClassName() {
        if (this.amendmentClassName == null && this.amendmentClass != null) {
            this.amendmentClassName = this.amendmentClass.getName();
        }
        return this.amendmentClassName;
    }

    public String getAmendmentMethodName() {
        return this.amendmentMethodName;
    }

    public ObjectChangePolicy getObjectChangePolicy() {
        if (this.changePolicy == null) {
            this.changePolicy = new DeferredChangeDetectionPolicy();
        }
        return this.changePolicy;
    }

    public ObjectChangePolicy getObjectChangePolicyInternal() {
        return this.changePolicy;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public Class getCacheInterceptorClass() {
        return this.cacheInterceptorClass;
    }

    public String getCacheInterceptorClassName() {
        return this.cacheInterceptorClassName;
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        if (this.cacheInvalidationPolicy == null) {
            this.cacheInvalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        }
        return this.cacheInvalidationPolicy;
    }

    public int getCacheSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Vector getCascadeLockingPolicies() {
        return this.cascadeLockingPolicies;
    }

    public Vector getConstraintDependencies() {
        return this.constraintDependencies;
    }

    public CopyPolicy getCopyPolicy() {
        if (this.copyPolicy == null) {
            this.setCopyPolicy(new InstantiationCopyPolicy());
        }
        return this.copyPolicy;
    }

    public String getCopyPolicyClassName() {
        return this.copyPolicyClassName;
    }

    public DatabaseTable getDefaultTable() {
        return this.defaultTable;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public String getDescriptorTypeValue() {
        if (this.isAggregateCollectionDescriptor()) {
            return "Aggregate collection";
        }
        if (this.isAggregateDescriptor()) {
            return "Aggregate";
        }
        if (this.isDescriptorForInterface()) {
            return "Interface";
        }
        return "Normal";
    }

    public DescriptorEventManager getDescriptorEventManager() {
        return this.getEventManager();
    }

    public DescriptorEventManager getEventManager() {
        if (this.eventManager == null) {
            this.setEventManager(new DescriptorEventManager());
        }
        return this.eventManager;
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public Class getIdentityMapClass() {
        return this.identityMapClass;
    }

    public int getIdentityMapSize() {
        return this.identityMapSize;
    }

    public InheritancePolicy getDescriptorInheritancePolicy() {
        return this.getInheritancePolicy();
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new InheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public InheritancePolicy getInheritancePolicyOrNull() {
        return this.inheritancePolicy;
    }

    public InstantiationPolicy getInstantiationPolicy() {
        if (this.instantiationPolicy == null) {
            this.setInstantiationPolicy(new InstantiationPolicy());
        }
        return this.instantiationPolicy;
    }

    public InterfacePolicy getInterfacePolicy() {
        if (this.interfacePolicy == null) {
            this.setInterfacePolicy(new InterfacePolicy(this));
        }
        return this.interfacePolicy;
    }

    public InterfacePolicy getInterfacePolicyOrNull() {
        return this.interfacePolicy;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public List<DatabaseMapping> getLockableMappings() {
        if (this.lockableMappings == null) {
            this.lockableMappings = new ArrayList<DatabaseMapping>();
        }
        return this.lockableMappings;
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        Enumeration<DatabaseMapping> mappingsNum = this.mappings.elements();
        while (mappingsNum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsNum.nextElement();
            if (mapping.getAttributeName() == null || !mapping.getAttributeName().equals(attributeName)) continue;
            return mapping;
        }
        return null;
    }

    public DatabaseMapping removeMappingForAttributeName(String attributeName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(attributeName);
        this.getMappings().remove(mapping);
        return mapping;
    }

    public Vector<DatabaseMapping> getMappings() {
        return this.mappings;
    }

    public Vector getMultipleTableForeignKeyAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (!this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.addElement(association);
            }
        }
        return associations;
    }

    public Map<DatabaseTable, Set<DatabaseTable>> getMultipleTableForeignKeys() {
        return this.multipleTableForeignKeys;
    }

    public Vector<DatabaseTable> getMultipleTableInsertOrder() throws DescriptorException {
        return this.multipleTableInsertOrder;
    }

    public Vector getMultipleTablePrimaryKeyAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.addElement(association);
            }
        }
        return associations;
    }

    public ObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    public OptimisticLockingPolicy getOptimisticLockingPolicy() {
        return this.optimisticLockingPolicy;
    }

    public Vector<String> getPrimaryKeyFieldNames() {
        Vector<String> result = new Vector<String>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            result.addElement(primaryKeyFields.get(index).getQualifiedName());
        }
        return result;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public QueryKey getQueryKeyNamed(String queryKeyName) {
        return this.getQueryKeys().get(queryKeyName);
    }

    public Map<String, QueryKey> getQueryKeys() {
        return this.queryKeys;
    }

    public DescriptorQueryManager getDescriptorQueryManager() {
        return this.getQueryManager();
    }

    public DescriptorQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.setQueryManager(new DescriptorQueryManager());
        }
        return this.queryManager;
    }

    public Class getRemoteIdentityMapClass() {
        if (this.remoteIdentityMapClass == null) {
            this.remoteIdentityMapClass = this.getIdentityMapClass();
        }
        return this.remoteIdentityMapClass;
    }

    public ClassDescriptor getRootDescriptor() {
        if (this.hasInheritance()) {
            return this.getInheritancePolicy().getRootParentDescriptor();
        }
        return this;
    }

    public int getRemoteIdentityMapSize() {
        if (this.remoteIdentityMapSize == -1) {
            this.remoteIdentityMapSize = this.getIdentityMapSize();
        }
        return this.remoteIdentityMapSize;
    }

    public ReturningPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    public DatabaseField getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public String getSequenceNumberFieldName() {
        if (this.getSequenceNumberField() == null) {
            return null;
        }
        return this.getSequenceNumberField().getQualifiedName();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DatabaseTable getTable(String tableName) throws DescriptorException {
        if (this.getTables().isEmpty()) {
            return null;
        }
        Enumeration<DatabaseTable> tables = this.getTables().elements();
        while (tables.hasMoreElements()) {
            String currentTableName;
            DatabaseTable table = tables.nextElement();
            if (tableName.indexOf(32) != -1 && (currentTableName = table.getName()).substring(1, currentTableName.length() - 1).equals(tableName)) {
                return table;
            }
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        if (this.isAggregateDescriptor()) {
            return this.getDefaultTable();
        }
        throw DescriptorException.tableNotPresent(tableName, this);
    }

    public String getTableName() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().get(0).getName();
    }

    public Vector getTableNames() {
        Vector<String> tableNames = new Vector<String>(this.getTables().size());
        Enumeration<DatabaseTable> fieldsEnum = this.getTables().elements();
        while (fieldsEnum.hasMoreElements()) {
            tableNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return tableNames;
    }

    public TablePerClassPolicy getTablePerClassPolicy() {
        return (TablePerClassPolicy)this.interfacePolicy;
    }

    public Vector<DatabaseTable> getTables() {
        return this.tables;
    }

    public DatabaseField getTypedField(DatabaseField field) {
        DatabaseField returnField;
        boolean mayBeMoreThanOne = this.hasMultipleTables() && !field.hasTableName();
        DatabaseField foundField = null;
        for (int index = 0; index < this.getFields().size(); ++index) {
            DatabaseField descField = this.getFields().get(index);
            if (!field.equals(descField) || descField.getType() == null) continue;
            foundField = descField;
            if (!mayBeMoreThanOne || descField.getTable().equals(this.getDefaultTable())) break;
        }
        if (foundField == null && this.hasReturningPolicy() && (returnField = this.getReturningPolicy().getField(field)) != null && returnField.getType() != null) {
            foundField = returnField;
        }
        if (foundField != null) {
            foundField = (DatabaseField)foundField.clone();
            if (!field.hasTableName()) {
                foundField.setTableName("");
            }
        }
        return foundField;
    }

    public WrapperPolicy getWrapperPolicy() {
        return this.wrapperPolicy;
    }

    public boolean hasDependencyOnParts() {
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.hasDependency()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInheritance() {
        return this.inheritancePolicy != null;
    }

    public boolean hasInterfacePolicy() {
        return this.interfacePolicy != null;
    }

    public boolean hasMultipleTables() {
        return this.getTables().size() > 1;
    }

    public boolean hasPrivatelyOwnedParts() {
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isPrivateOwned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryKeyOrMapping(String attributeName) {
        return this.getQueryKeys().containsKey(attributeName) || this.getObjectBuilder().getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasReturningPolicy() {
        return this.returningPolicy != null;
    }

    public boolean hasWrapperPolicy() {
        return this.wrapperPolicy != null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        ClassDescriptor parentDescriptor;
        DatabaseMapping mapping2;
        int index;
        Object[] mappingsArray;
        Vector mappings;
        if (this.shouldBeReadOnly() && !session.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            session.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.getHistoryPolicy() != null) {
            session.getProject().setHasGenericHistorySupport(true);
        }
        if (this.isIsolated()) {
            session.getProject().setHasIsolatedClasses(true);
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            this.getInheritancePolicy().getParentDescriptor().initialize(session);
            if (this.getInheritancePolicy().getParentDescriptor().isIsolated()) {
                this.setIsIsolated(true);
            }
            this.getInheritancePolicy().initializeOptimisticLocking();
        }
        if (this.shouldOrderMappings()) {
            mappings = this.getMappings();
            mappingsArray = new Object[mappings.size()];
            for (index = 0; index < mappings.size(); ++index) {
                mappingsArray[index] = mappings.elementAt(index);
            }
            Arrays.sort(mappingsArray, new MappingCompare());
            mappings = NonSynchronizedVector.newInstance(mappingsArray.length);
            for (index = 0; index < mappingsArray.length; ++index) {
                mappings.addElement(mappingsArray[index]);
            }
            this.setMappings(mappings);
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            mapping2 = mappingsEnum.nextElement();
            this.validateMappingType(mapping2);
            mapping2.initialize(session);
            if (mapping2.isAggregateObjectMapping() || mapping2.isForeignReferenceMapping() && !mapping2.isDirectCollectionMapping() && !((ForeignReferenceMapping)mapping2).usesIndirection()) {
                this.getLockableMappings().add(mapping2);
            }
            if (mapping2.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping2).getIndirectionPolicy() instanceof ProxyIndirectionPolicy) {
                session.getProject().setHasProxyIndirection(true);
            }
            if (this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || this.hasCascadeLockingPolicies()) {
                this.prepareCascadeLockingPolicy(mapping2);
            }
            Helper.addAllUniqueToVector(this.getFields(), mapping2.getFields());
        }
        if (this.hasMappingsPostCalculateChangesOnDeleted()) {
            session.getProject().setHasMappingsPostCalculateChangesOnDeleted(true);
        }
        if (!this.isAggregateDescriptor() && !this.isChildDescriptor() && this.usesOptimisticLocking()) {
            this.getOptimisticLockingPolicy().initializeProperties();
        }
        for (QueryKey queryKey : this.getQueryKeys().values()) {
            queryKey.initialize(this);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
            if (this.getInheritancePolicy().isChildDescriptor()) {
                for (DatabaseMapping mapping2 : this.getInheritancePolicy().getParentDescriptor().getMappings()) {
                    if (!mapping2.isAggregateObjectMapping() && (!mapping2.isForeignReferenceMapping() || mapping2.isDirectCollectionMapping() || ((ForeignReferenceMapping)mapping2).usesIndirection())) continue;
                    this.getLockableMappings().add(mapping2);
                }
            }
        }
        if (this.hasInheritance() && this.shouldOrderMappings()) {
            mappings = this.getMappings();
            mappingsArray = new Object[mappings.size()];
            for (index = 0; index < mappings.size(); ++index) {
                mappingsArray[index] = mappings.elementAt(index);
            }
            Arrays.sort(mappingsArray, new MappingCompare());
            mappings = NonSynchronizedVector.newInstance(mappingsArray.length);
            for (index = 0; index < mappingsArray.length; ++index) {
                mappings.addElement(mappingsArray[index]);
            }
            this.setMappings(mappings);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(session);
        if (this.shouldOrderMappings()) {
            for (int index2 = this.getObjectBuilder().getPrimaryKeyMappings().size() - 1; index2 >= 0; --index2) {
                mapping2 = this.getObjectBuilder().getPrimaryKeyMappings().get(index2);
                if (mapping2 == null || !mapping2.isDirectToFieldMapping()) continue;
                this.getMappings().remove(mapping2);
                this.getMappings().add(0, mapping2);
                DatabaseField field = ((AbstractDirectMapping)mapping2).getField();
                this.getFields().remove(field);
                this.getFields().add(0, field);
                this.getAllFields().remove(field);
                this.getAllFields().add(0, field);
            }
        }
        if (this.usesOptimisticLocking() && !this.isChildDescriptor()) {
            this.getOptimisticLockingPolicy().initialize(session);
        }
        if (this.hasInterfacePolicy()) {
            this.interfaceInitialization(session);
        }
        if (this.hasWrapperPolicy()) {
            this.getWrapperPolicy().initialize(session);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(session);
        }
        this.getQueryManager().initialize(session);
        this.getEventManager().initialize(session);
        this.getCopyPolicy().initialize(session);
        this.getInstantiationPolicy().initialize(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        } else if (this.hasInheritance() && (parentDescriptor = this.getInheritancePolicy().getParentDescriptor()) != null && parentDescriptor.getHistoryPolicy() != null) {
            this.setHistoryPolicy((HistoryPolicy)parentDescriptor.getHistoryPolicy().clone());
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().initialize(this, session);
        }
        if (this.hasFetchGroupManager()) {
            this.getFetchGroupManager().initialize(session);
        }
        if (this.getObjectChangePolicyInternal() == null && ChangeTracker.class.isAssignableFrom(this.getJavaClass()) && Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceWeavedChangeTracking.class) && this.supportsChangeTracking(session.getProject())) {
            this.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        }
        this.getObjectChangePolicy().initialize(session, this);
        if (this.getUnitOfWorkCacheIsolationLevel() == -1) {
            if (this.isIsolated()) {
                this.setUnitOfWorkCacheIsolationLevel(3);
            } else {
                this.setUnitOfWorkCacheIsolationLevel(1);
            }
        }
        if (this.getIdValidation() == null) {
            if (this.getPrimaryKeyFields().size() > 1) {
                this.setIdValidation(IdValidation.NULL);
            } else {
                this.setIdValidation(IdValidation.ZERO);
            }
        }
        if (this.defaultReadAllQueryRedirector == null) {
            this.defaultReadAllQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReadObjectQueryRedirector == null) {
            this.defaultReadObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReportQueryRedirector == null) {
            this.defaultReportQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultInsertObjectQueryRedirector == null) {
            this.defaultInsertObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultUpdateObjectQueryRedirector == null) {
            this.defaultUpdateObjectQueryRedirector = this.defaultQueryRedirector;
        }
    }

    public void initializeAggregateInheritancePolicy(AbstractSession session) {
        ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
        parentDescriptor.getInheritancePolicy().addChildDescriptor(this);
    }

    public void initializeMultipleTablePrimaryKeyFields() {
        boolean isChild;
        int additionalTablesSize = this.getTables().size() - 1;
        boolean bl = isChild = this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
        if (isChild) {
            additionalTablesSize = this.getTables().size() - this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        if (additionalTablesSize < 1) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression joinExpression = this.getQueryManager().getMultipleTableJoinExpression();
        for (int index = this.getTables().size() - additionalTablesSize; index < this.getTables().size(); ++index) {
            DatabaseTable table = this.getTables().get(index);
            Map<DatabaseField, DatabaseField> oldKeyMapping = this.getAdditionalTablePrimaryKeyFields().get(table);
            if (oldKeyMapping != null) {
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                for (DatabaseField sourceTableField : oldKeyMapping.keySet()) {
                    DatabaseField targetTableField = oldKeyMapping.get(sourceTableField);
                    DatabaseTable targetTable = targetTableField.getTable();
                    if (!this.getFields().contains(sourceTableField)) {
                        this.getFields().addElement(sourceTableField);
                    }
                    if (!this.getFields().contains(targetTableField)) {
                        this.getFields().addElement(targetTableField);
                    }
                    Expression keyJoinExpression = builder.getField(targetTableField).equal(builder.getField(sourceTableField));
                    joinExpression = keyJoinExpression.and(joinExpression);
                    this.getQueryManager().getTablesJoinExpressions().put(targetTable, keyJoinExpression);
                    if (!isChild) continue;
                    this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(targetTable, keyJoinExpression);
                }
                continue;
            }
            HashMap<DatabaseField, DatabaseField> newKeyMapping = new HashMap<DatabaseField, DatabaseField>(this.getPrimaryKeyFields().size() + 1);
            this.getAdditionalTablePrimaryKeyFields().put(table, newKeyMapping);
            List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
            for (int pkIndex = 0; pkIndex < primaryKeyFields.size(); ++pkIndex) {
                DatabaseField primaryKeyField = primaryKeyFields.get(pkIndex);
                DatabaseField secondaryKeyField = (DatabaseField)primaryKeyField.clone();
                secondaryKeyField.setTable(table);
                newKeyMapping.put(primaryKeyField, secondaryKeyField);
                this.getFields().addElement(secondaryKeyField);
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                Expression keyJoinExpression = builder.getField(secondaryKeyField).equal(builder.getField(primaryKeyField));
                joinExpression = keyJoinExpression.and(joinExpression);
                this.getQueryManager().getTablesJoinExpressions().put(table, keyJoinExpression);
                if (!isChild) continue;
                this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(table, keyJoinExpression);
            }
        }
        if (joinExpression != null) {
            this.getQueryManager().setInternalMultipleTableJoinExpression(joinExpression);
        }
        if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) {
            Map tablesJoinExpressions = SQLSelectStatement.mapTableToExpression(joinExpression, this.getTables());
            this.getQueryManager().getTablesJoinExpressions().putAll(tablesJoinExpressions);
            if (isChild) {
                for (int index = this.getTables().size() - additionalTablesSize; index < this.getTables().size(); ++index) {
                    DatabaseTable table = this.getTables().elementAt(index);
                    this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(table, (Expression)tablesJoinExpressions.get(table));
                }
            }
        }
    }

    protected void initializeProperties(AbstractSession session) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor()) {
                for (int index = 0; index < this.getPrimaryKeyFields().size(); ++index) {
                    DatabaseField primaryKey = this.getPrimaryKeyFields().get(index);
                    primaryKey = this.buildField(primaryKey);
                    this.getPrimaryKeyFields().set(index, primaryKey);
                }
                List primaryKeyFields = (List)((ArrayList)this.getPrimaryKeyFields()).clone();
                for (int index = 0; index < primaryKeyFields.size(); ++index) {
                    DatabaseField primaryKey = (DatabaseField)primaryKeyFields.get(index);
                    if (primaryKey.getTable().equals(this.getDefaultTable())) continue;
                    this.getPrimaryKeyFields().remove(primaryKey);
                }
            }
            if (this.getSequenceNumberField() != null) {
                this.setSequenceNumberField(this.buildField(this.getSequenceNumberField()));
            }
        }
        this.setSessionName(session.getName());
    }

    public void interfaceInitialization(AbstractSession session) throws DescriptorException {
        if (this.isInterfaceInitialized(2)) {
            return;
        }
        this.setInterfaceInitializationStage(2);
        if (this.isInterfaceChildDescriptor()) {
            Enumeration interfaces = this.getInterfacePolicy().getParentInterfaces().elements();
            while (interfaces.hasMoreElements()) {
                Class parentInterface = (Class)interfaces.nextElement();
                ClassDescriptor parentDescriptor = session.getDescriptor(parentInterface);
                parentDescriptor.interfaceInitialization(session);
                if (this.isDescriptorForInterface()) {
                    this.setQueryKeys(Helper.concatenateMaps(this.getQueryKeys(), parentDescriptor.getQueryKeys()));
                } else {
                    for (String queryKeyName : parentDescriptor.getQueryKeys().keySet()) {
                        if (this.hasQueryKeyOrMapping(queryKeyName)) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent(this, parentDescriptor, queryKeyName));
                    }
                }
                if (parentDescriptor != this) continue;
                return;
            }
        }
        this.getInterfacePolicy().initialize(session);
    }

    protected boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    public boolean isAggregateCollectionDescriptor() {
        return this.descriptorType == 3;
    }

    public boolean isAggregateDescriptor() {
        return this.descriptorType == 2;
    }

    public boolean isChildDescriptor() {
        return this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
    }

    public boolean isDescriptorForInterface() {
        return this.getDescriptorType() == 1;
    }

    public boolean isFullyInitialized() {
        return this.initializationStage == 3;
    }

    protected boolean isInitialized(int initializationStage) {
        return this.initializationStage >= initializationStage;
    }

    public boolean isInterfaceChildDescriptor() {
        return this.hasInterfacePolicy() && this.getInterfacePolicy().isInterfaceChildDescriptor();
    }

    protected boolean isInterfaceInitialized(int interfaceInitializationStage) {
        return this.interfaceInitializationStage >= interfaceInitializationStage;
    }

    public boolean isInvalid() {
        return this.initializationStage == -1;
    }

    public boolean isIsolated() {
        if (this.isIsolated == null) {
            return false;
        }
        return this.isIsolated;
    }

    public boolean isMultipleTableDescriptor() {
        return this.getTables().size() > 1;
    }

    public boolean isObjectRelationalDataTypeDescriptor() {
        return false;
    }

    public boolean isPrimaryKeySetAfterInsert(AbstractSession session) {
        return this.usesSequenceNumbers() && this.getSequence().shouldAcquireValueAfterInsert() || this.hasReturningPolicy() && this.getReturningPolicy().isUsedToSetPrimaryKey();
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return this.cacheSynchronizationType == 3 || shouldUseFullChangeSetsForNewObjects;
    }

    public void onlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        int index;
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            Enumeration childEnum = this.getInheritancePolicy().getChildDescriptors().elements();
            while (childEnum.hasMoreElements()) {
                ((ClassDescriptor)childEnum.nextElement()).postInitialize(session);
            }
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            mapping.postInitialize(session);
            if (this.shouldAcquireCascadedLocks()) continue;
            if (mapping instanceof ForeignReferenceMapping && !((ForeignReferenceMapping)mapping).usesIndirection()) {
                this.setShouldAcquireCascadedLocks(true);
            }
            if (!(mapping instanceof AggregateObjectMapping) || !mapping.getReferenceDescriptor().shouldAcquireCascadedLocks()) continue;
            this.setShouldAcquireCascadedLocks(true);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        for (index = this.getPrimaryKeyFields().size() - 1; index >= 0; --index) {
            DatabaseField primaryKeyField = this.getPrimaryKeyFields().get(index);
            int fieldIndex = this.getFields().indexOf(primaryKeyField);
            if (fieldIndex == -1) continue;
            primaryKeyField = this.getFields().get(fieldIndex);
            this.getPrimaryKeyFields().set(index, primaryKeyField);
        }
        for (index = 0; index < this.getFields().size(); ++index) {
            DatabaseMapping mapping;
            DatabaseField field = this.getFields().elementAt(index);
            if (field.getType() == null && (mapping = this.getObjectBuilder().getMappingForField(field)) != null) {
                field.setType(mapping.getFieldClassification(field));
            }
            field.setIndex(index);
        }
        this.getObjectBuilder().postInitialize(session);
        this.validateAfterInitialization(session);
        this.checkDatabase(session);
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        this.assignDefaultValues(session);
        if (FetchGroupTracker.class.isAssignableFrom(this.getJavaClass()) && this.getFetchGroupManager() == null) {
            this.setFetchGroupManager(new FetchGroupManager());
        }
        if (PersistenceObject.class.isAssignableFrom(this.getJavaClass()) && this.copyPolicy == null) {
            boolean isMethodAccess = false;
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.isUsingMethodAccess()) continue;
                if (mapping.isOneToOneMapping() && ((ForeignReferenceMapping)mapping).usesIndirection()) break;
                isMethodAccess = true;
                break;
            }
            if (!isMethodAccess) {
                this.setCopyPolicy(new PersistenceEntityCopyPolicy());
            }
        }
        for (DatabaseTable next : this.getTables()) {
            if (next.getName().indexOf(32) == -1) continue;
            String quoteChar = ((DatasourcePlatform)session.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (next.getName().indexOf(quoteChar) != -1) continue;
            next.setName(quoteChar + next.getName() + quoteChar);
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            try {
                DatabaseMapping mapping;
                mapping = mappingsEnum.nextElement();
                mapping.preInitialize(session);
            }
            catch (DescriptorException exception) {
                session.getIntegrityChecker().handleError(exception);
            }
        }
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(session);
        } else {
            this.setInternalDefaultTable();
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (!this.isAggregateDescriptor()) {
            this.adjustMultipleTableInsertOrder();
            this.initializeMultipleTablePrimaryKeyFields();
        }
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(session);
        }
        this.getQueryManager().preInitialize(session);
    }

    protected void prepareCascadeLockingPolicy(DatabaseMapping mapping) {
        if (mapping.isPrivateOwned() && mapping.isForeignReferenceMapping()) {
            if (mapping.isCascadedLockingSupported()) {
                if (((ForeignReferenceMapping)mapping).hasCustomSelectionQuery()) {
                    throw ValidationException.unsupportedCascadeLockingMappingWithCustomQuery(mapping);
                }
                if (this.isAggregateDescriptor() || this.isAggregateCollectionDescriptor()) {
                    throw ValidationException.unsupportedCascadeLockingDescriptor(this);
                }
                mapping.prepareCascadeLockingPolicy();
            } else {
                throw ValidationException.unsupportedCascadeLockingMapping(mapping);
            }
        }
    }

    protected void preInitializeInheritancePolicy(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor() && this.requiresInitialization()) {
            if (this.getInheritancePolicy().getParentClass().equals(this.getJavaClass())) {
                this.setInterfaceInitializationStage(-1);
                throw DescriptorException.parentClassIsSelf(this);
            }
            ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            parentDescriptor.getInheritancePolicy().addChildDescriptor(this);
            this.getInheritancePolicy().setParentDescriptor(parentDescriptor);
            parentDescriptor.preInitialize(session);
        }
    }

    public void preInterfaceInitialization(AbstractSession session) throws DescriptorException {
        if (this.isInterfaceInitialized(1)) {
            return;
        }
        this.setInterfaceInitializationStage(1);
        this.assignDefaultValues(session);
        if (this.isInterfaceChildDescriptor()) {
            Enumeration interfaces = this.getInterfacePolicy().getParentInterfaces().elements();
            while (interfaces.hasMoreElements()) {
                Class parentInterface = (Class)interfaces.nextElement();
                ClassDescriptor parentDescriptor = session.getDescriptor(parentInterface);
                if (parentDescriptor == null || parentDescriptor.getJavaClass() == this.getJavaClass() || parentDescriptor.getInterfacePolicy().usesImplementorDescriptor()) {
                    session.getProject().getDescriptors().put(parentInterface, this);
                    session.clearLastDescriptorAccessed();
                    continue;
                }
                if (!parentDescriptor.isDescriptorForInterface()) {
                    throw DescriptorException.descriptorForInterfaceIsMissing(parentInterface.getName());
                }
                parentDescriptor.preInterfaceInitialization(session);
                parentDescriptor.getInterfacePolicy().addChildDescriptor(this);
                this.getInterfacePolicy().addParentDescriptor(parentDescriptor);
            }
        }
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.getObjectBuilder().rehashFieldDependancies(session);
        Enumeration<DatabaseMapping> enumtr = this.getMappings().elements();
        while (enumtr.hasMoreElements()) {
            enumtr.nextElement().rehashFieldDependancies(session);
        }
    }

    public void reInitializeJoinedAttributes() {
        if (!this.isInitialized(3)) {
            return;
        }
        this.getObjectBuilder().initializeJoinedAttributes();
        if (this.hasInheritance()) {
            Vector children = this.getInheritancePolicy().getChildDescriptors();
            for (int i = 0; i < children.size(); ++i) {
                ClassDescriptor child = (ClassDescriptor)children.elementAt(i);
                child.reInitializeJoinedAttributes();
            }
        }
    }

    public void remoteInitialization(DistributedSession session) {
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            mapping.remoteInitialization(session);
        }
        this.getEventManager().remoteInitialization(session);
        this.getInstantiationPolicy().initialize(session);
        this.getCopyPolicy().initialize(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().remoteInitialization(session);
        }
    }

    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    public boolean requiresInitialization() {
        return !this.isAggregateDescriptor() && !this.isDescriptorForInterface() && !this.isAggregateCollectionDescriptor();
    }

    protected void selfValidationAfterInitialization(AbstractSession session) throws DescriptorException {
        if (!(this.hasInheritance() && (this.getInheritancePolicy().shouldReadSubclasses() || this.isAbstract()) || this.hasTablePerClassPolicy() && this.isAbstract() || !session.getIntegrityChecker().shouldCheckInstantiationPolicy())) {
            this.getInstantiationPolicy().buildNewInstance();
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().validationAfterDescriptorInitialization(session);
        }
        this.getObjectBuilder().validate(session);
    }

    protected void selfValidationBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            if (parentDescriptor == null) {
                session.getIntegrityChecker().handleError(DescriptorException.parentDescriptorNotSpecified(this.getInheritancePolicy().getParentClass().getName(), this));
            }
        } else if (this.getTables().isEmpty() && !this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.tableNotSpecified(this));
        }
        if (!this.isChildDescriptor() && !this.isAggregateDescriptor() && !this.isAggregateCollectionDescriptor() && this.getPrimaryKeyFieldNames().isEmpty()) {
            session.getIntegrityChecker().handleError(DescriptorException.primaryKeyFieldsNotSepcified(this));
        }
        if (this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class && this.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            session.getIntegrityChecker().handleError(DescriptorException.identityMapNotSpecified(this));
        }
        if (this.getSequenceNumberName() != null && this.getSequenceNumberField() == null || this.getSequenceNumberName() == null && this.getSequenceNumberField() != null) {
            session.getIntegrityChecker().handleError(DescriptorException.sequenceNumberPropertyNotSpecified(this));
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(DatabaseTable table, DatabaseField field1, DatabaseField field2) {
        Map<DatabaseField, DatabaseField> tableAdditionalPKFields = this.getAdditionalTablePrimaryKeyFields().get(table);
        if (tableAdditionalPKFields == null) {
            tableAdditionalPKFields = new HashMap<DatabaseField, DatabaseField>(2);
            this.getAdditionalTablePrimaryKeyFields().put(table, tableAdditionalPKFields);
        }
        tableAdditionalPKFields.put(field1, field2);
    }

    protected void toggleAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            return;
        }
        int nProcessedTables = 1;
        if (this.isChildDescriptor()) {
            nProcessedTables = this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFieldsOld = this.additionalTablePrimaryKeyFields;
        this.additionalTablePrimaryKeyFields = null;
        for (Map.Entry<DatabaseTable, Map<DatabaseField, DatabaseField>> entryTable : additionalTablePrimaryKeyFieldsOld.entrySet()) {
            DatabaseTable sourceTable = entryTable.getKey();
            boolean isSourceProcessed = this.getTables().indexOf(sourceTable) < nProcessedTables;
            int sourceInsertOrderIndex = this.getMultipleTableInsertOrder().indexOf(sourceTable);
            Map<DatabaseField, DatabaseField> targetTableAdditionalPKFields = entryTable.getValue();
            for (Map.Entry<DatabaseField, DatabaseField> entryField : targetTableAdditionalPKFields.entrySet()) {
                DatabaseField targetField = entryField.getKey();
                DatabaseField sourceField = entryField.getValue();
                DatabaseTable targetTable = targetField.getTable();
                boolean isTargetProcessed = this.getTables().indexOf(targetTable) < nProcessedTables;
                int targetInsertOrderIndex = this.getMultipleTableInsertOrder().indexOf(targetTable);
                if (!isTargetProcessed && (isSourceProcessed || sourceInsertOrderIndex > targetInsertOrderIndex)) {
                    this.setAdditionalTablePrimaryKeyFields(targetTable, sourceField, targetField);
                    continue;
                }
                this.setAdditionalTablePrimaryKeyFields(sourceTable, targetField, sourceField);
            }
        }
    }

    public void setAdditionalTablePrimaryKeyFields(Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields) {
        this.additionalTablePrimaryKeyFields = additionalTablePrimaryKeyFields;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    protected void setAllFields(Vector<DatabaseField> allFields) {
        this.allFields = allFields;
    }

    public void setAmendmentClass(Class amendmentClass) {
        this.amendmentClass = amendmentClass;
    }

    public void setAmendmentClassName(String amendmentClassName) {
        this.amendmentClassName = amendmentClassName;
    }

    public void setAmendmentMethodName(String amendmentMethodName) {
        this.amendmentMethodName = amendmentMethodName;
    }

    public void setCacheSynchronizationType(int type) {
        if (!this.isIsolated()) {
            this.cacheSynchronizationType = type;
        }
    }

    public void setObjectChangePolicy(ObjectChangePolicy policy) {
        this.changePolicy = policy;
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setCacheInterceptorClass(Class cacheInterceptorClass) {
        this.cacheInterceptorClass = cacheInterceptorClass;
    }

    public void setCacheInterceptorClassName(String cacheInterceptorClassName) {
        this.cacheInterceptorClassName = cacheInterceptorClassName;
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy policy) {
        this.cacheInvalidationPolicy = policy;
    }

    public void setConstraintDependencies(Vector constraintDependencies) {
        this.constraintDependencies = constraintDependencies;
    }

    public void setCopyPolicy(CopyPolicy policy) {
        this.copyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setCopyPolicyClassName(String className) {
        this.copyPolicyClassName = className;
    }

    public void setDefaultTable(DatabaseTable defaultTable) {
        this.defaultTable = defaultTable;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.setDefaultTable(new DatabaseTable(defaultTableName));
    }

    public void setDescriptorType(int descriptorType) {
        this.descriptorType = descriptorType;
    }

    public void setDescriptorTypeValue(String value) {
        if (value.equals("Aggregate collection")) {
            this.descriptorIsAggregateCollection();
        } else if (value.equals("Aggregate")) {
            this.descriptorIsAggregate();
        } else if (value.equals("Interface")) {
            this.descriptorIsForInterface();
        } else {
            this.descriptorIsNormal();
        }
    }

    public void setEventManager(DescriptorEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            eventManager.setDescriptor(this);
        }
    }

    public void setExistenceChecking(String token) throws DescriptorException {
        this.getQueryManager().setExistenceCheck(token);
    }

    public void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setForeignKeyFieldNamesForMultipleTable(Vector associations) throws DescriptorException {
        Enumeration foreignKeys = associations.elements();
        while (foreignKeys.hasMoreElements()) {
            Association association = (Association)foreignKeys.nextElement();
            this.addForeignKeyFieldNameForMultipleTable((String)association.getKey(), (String)association.getValue());
        }
    }

    public void setIdentityMapClass(Class theIdentityMapClass) {
        this.identityMapClass = theIdentityMapClass;
    }

    public void setIdentityMapSize(int identityMapSize) {
        this.identityMapSize = identityMapSize;
    }

    public void setInheritancePolicy(InheritancePolicy inheritancePolicy) {
        this.inheritancePolicy = inheritancePolicy;
        if (inheritancePolicy != null) {
            inheritancePolicy.setDescriptor(this);
        }
    }

    public void setReturningPolicy(ReturningPolicy returningPolicy) {
        this.returningPolicy = returningPolicy;
        if (returningPolicy != null) {
            returningPolicy.setDescriptor(this);
        }
    }

    protected void setInitializationStage(int initializationStage) {
        this.initializationStage = initializationStage;
    }

    public void setInstantiationPolicy(InstantiationPolicy instantiationPolicy) {
        this.instantiationPolicy = instantiationPolicy;
        if (instantiationPolicy != null) {
            instantiationPolicy.setDescriptor(this);
        }
    }

    protected void setInterfaceInitializationStage(int interfaceInitializationStage) {
        this.interfaceInitializationStage = interfaceInitializationStage;
    }

    public void setInterfacePolicy(InterfacePolicy interfacePolicy) {
        this.interfacePolicy = interfacePolicy;
        if (interfacePolicy != null) {
            interfacePolicy.setDescriptor(this);
        }
    }

    public void setInternalDefaultTable() {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(this.extractDefaultTable());
        }
    }

    public void setInternalDefaultTable(DatabaseTable defaultTable) {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(defaultTable);
        }
    }

    public void setIsIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
        if (isIsolated) {
            this.cacheSynchronizationType = 4;
        }
    }

    public boolean shouldIsolateObjectsInUnitOfWork() {
        return this.getUnitOfWorkCacheIsolationLevel() == 3;
    }

    public boolean shouldIsolateObjectsInUnitOfWorkEarlyTransaction() {
        return this.getUnitOfWorkCacheIsolationLevel() == 2;
    }

    public boolean shouldUseSessionCacheInUnitOfWorkEarlyTransaction() {
        return this.getUnitOfWorkCacheIsolationLevel() == 0;
    }

    public int getUnitOfWorkCacheIsolationLevel() {
        return this.unitOfWorkCacheIsolationLevel;
    }

    public void setUnitOfWorkCacheIsolationLevel(int unitOfWorkCacheIsolationLevel) {
        this.unitOfWorkCacheIsolationLevel = unitOfWorkCacheIsolationLevel;
    }

    public void setJavaClass(Class theJavaClass) {
        this.javaClass = theJavaClass;
    }

    public void setJavaClassName(String theJavaClassName) {
        this.javaClassName = theJavaClassName;
    }

    public void setJavaInterface(Class theJavaInterface) {
        this.javaClass = theJavaInterface;
        this.descriptorIsForInterface();
    }

    public void setJavaInterfaceName(String theJavaInterfaceName) {
        this.javaClassName = theJavaInterfaceName;
        this.descriptorIsForInterface();
    }

    public void setLockableMappings(List<DatabaseMapping> lockableMappings) {
        this.lockableMappings = lockableMappings;
    }

    public void setMappings(Vector<DatabaseMapping> mappings) {
        Enumeration<DatabaseMapping> mappingsEnum = mappings.elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            if (mapping.getDescriptor() != null) continue;
            mapping.setDescriptor(this);
        }
        this.mappings = mappings;
    }

    protected void setMultipleTableForeignKeys(Map<DatabaseTable, Set<DatabaseTable>> newValue) {
        this.multipleTableForeignKeys = newValue;
    }

    public void setMultipleTableInsertOrder(Vector<DatabaseTable> newValue) {
        this.multipleTableInsertOrder = newValue;
    }

    protected void setObjectBuilder(ObjectBuilder builder) {
        this.objectBuilder = builder;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        if (optimisticLockingPolicy != null) {
            optimisticLockingPolicy.setDescriptor(this);
        }
    }

    public void setPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyFieldName(fieldName);
    }

    public void setPrimaryKeyFieldNames(Vector primaryKeyFieldsName) {
        this.setPrimaryKeyFields(new ArrayList<DatabaseField>(primaryKeyFieldsName.size()));
        Enumeration keyEnum = primaryKeyFieldsName.elements();
        while (keyEnum.hasMoreElements()) {
            this.addPrimaryKeyFieldName((String)keyEnum.nextElement());
        }
    }

    public void setPrimaryKeyFields(List<DatabaseField> thePrimaryKeyFields) {
        this.primaryKeyFields = thePrimaryKeyFields;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public void setQueryKeys(Map<String, QueryKey> queryKeys) {
        this.queryKeys = queryKeys;
    }

    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    public void setRemoteIdentityMapClass(Class theIdentityMapClass) {
        this.remoteIdentityMapClass = theIdentityMapClass;
    }

    public void setRemoteIdentityMapSize(int identityMapSize) {
        this.remoteIdentityMapSize = identityMapSize;
    }

    public void setSequenceNumberField(DatabaseField sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public void setSequenceNumberFieldName(String fieldName) {
        if (fieldName == null) {
            this.setSequenceNumberField(null);
        } else {
            this.setSequenceNumberField(new DatabaseField(fieldName));
        }
    }

    public void setSequenceNumberName(String name) {
        this.sequenceNumberName = name;
    }

    protected void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setShouldAlwaysConformResultsInUnitOfWork(boolean shouldAlwaysConformResultsInUnitOfWork) {
        this.shouldAlwaysConformResultsInUnitOfWork = shouldAlwaysConformResultsInUnitOfWork;
    }

    public void setShouldAlwaysRefreshCache(boolean shouldAlwaysRefreshCache) {
        this.shouldAlwaysRefreshCache = shouldAlwaysRefreshCache;
    }

    public void setShouldAlwaysRefreshCacheOnRemote(boolean shouldAlwaysRefreshCacheOnRemote) {
        this.shouldAlwaysRefreshCacheOnRemote = shouldAlwaysRefreshCacheOnRemote;
    }

    public void setShouldBeReadOnly(boolean shouldBeReadOnly) {
        this.shouldBeReadOnly = shouldBeReadOnly;
    }

    public void setReadOnly() {
        this.setShouldBeReadOnly(true);
    }

    public void setShouldDisableCacheHits(boolean shouldDisableCacheHits) {
        this.shouldDisableCacheHits = shouldDisableCacheHits;
    }

    public void setShouldDisableCacheHitsOnRemote(boolean shouldDisableCacheHitsOnRemote) {
        this.shouldDisableCacheHitsOnRemote = shouldDisableCacheHitsOnRemote;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean shouldOnlyRefreshCacheIfNewerVersion) {
        this.shouldOnlyRefreshCacheIfNewerVersion = shouldOnlyRefreshCacheIfNewerVersion;
    }

    public void setShouldOrderMappings(boolean shouldOrderMappings) {
        this.shouldOrderMappings = shouldOrderMappings;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public void setTableName(String tableName) throws DescriptorException {
        if (!this.getTables().isEmpty()) {
            throw DescriptorException.onlyOneTableCanBeAddedWithThisMethod(this);
        }
        this.addTableName(tableName);
    }

    public void setTableNames(Vector tableNames) {
        this.setTables(NonSynchronizedVector.newInstance(tableNames.size()));
        Enumeration tableEnum = tableNames.elements();
        while (tableEnum.hasMoreElements()) {
            this.addTableName((String)tableEnum.nextElement());
        }
    }

    public void setTablePerClassPolicy(TablePerClassPolicy tablePerClassPolicy) {
        this.interfacePolicy = tablePerClassPolicy;
        if (this.interfacePolicy != null) {
            this.interfacePolicy.setDescriptor(this);
        }
    }

    public void setTableQualifier(String tableQualifier) {
        Enumeration<DatabaseTable> enumtr = this.getTables().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseTable table = enumtr.nextElement();
            table.setTableQualifier(tableQualifier);
        }
    }

    public void setTables(Vector<DatabaseTable> theTables) {
        this.tables = theTables;
    }

    public void setWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.wrapperPolicy = wrapperPolicy;
        if (wrapperPolicy != null) {
            wrapperPolicy.setDescriptor(this);
        }
        this.getObjectBuilder().setHasWrapperPolicy(wrapperPolicy != null);
    }

    public boolean shouldAlwaysConformResultsInUnitOfWork() {
        return this.shouldAlwaysConformResultsInUnitOfWork;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.shouldAlwaysRefreshCache;
    }

    public boolean shouldAlwaysRefreshCacheOnRemote() {
        return this.shouldAlwaysRefreshCacheOnRemote;
    }

    public boolean shouldBeReadOnly() {
        return this.shouldBeReadOnly;
    }

    public boolean shouldDisableCacheHits() {
        return this.shouldDisableCacheHits;
    }

    public boolean shouldDisableCacheHitsOnRemote() {
        return this.shouldDisableCacheHitsOnRemote;
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.shouldOnlyRefreshCacheIfNewerVersion;
    }

    public boolean shouldOrderMappings() {
        return this.shouldOrderMappings;
    }

    public boolean hasSimplePrimaryKey() {
        return this.hasSimplePrimaryKey;
    }

    public boolean hasTablePerClassPolicy() {
        return this.hasInterfacePolicy() && this.interfacePolicy.isTablePerClassPolicy();
    }

    public void setHasSimplePrimaryKey(boolean hasSimplePrimaryKey) {
        this.hasSimplePrimaryKey = hasSimplePrimaryKey;
    }

    public boolean shouldAcquireCascadedLocks() {
        return this.shouldAcquireCascadedLocks;
    }

    public void setShouldAcquireCascadedLocks(boolean shouldAcquireCascadedLocks) {
        this.shouldAcquireCascadedLocks = shouldAcquireCascadedLocks;
    }

    public boolean shouldUseCacheIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseFullIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseSoftIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftIdentityMap_Class;
    }

    public boolean shouldUseHardCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseNoIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseRemoteCacheIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseRemoteFullIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseRemoteHardCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteNoIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean shouldUseSoftCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean supportsChangeTracking(Project project) {
        OptimisticLockingPolicy lockingPolicy = this.getOptimisticLockingPolicy();
        if (lockingPolicy != null && lockingPolicy instanceof FieldsLockingPolicy) {
            return false;
        }
        Vector<DatabaseMapping> mappings = this.getMappings();
        for (DatabaseMapping mapping : mappings) {
            if (mapping.isChangeTrackingSupported(project)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getJavaClassName() + " --> " + this.getTables() + ")";
    }

    public void useAllFieldsLocking() {
        this.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
    }

    public void useCacheIdentityMap() {
        this.setIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useChangedFieldsLocking() {
        this.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
    }

    public void useCloneCopyPolicy() {
        this.useCloneCopyPolicy("clone");
    }

    public void useCloneCopyPolicy(String cloneMethodName) {
        CloneCopyPolicy policy = new CloneCopyPolicy();
        policy.setMethodName(cloneMethodName);
        this.setCopyPolicy(policy);
    }

    public void useInstantiationCopyPolicy() {
        this.setCopyPolicy(new InstantiationCopyPolicy());
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.getInstantiationPolicy().useDefaultConstructorInstantiationPolicy();
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName);
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(Object factory, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factory, methodName);
    }

    public void useFullIdentityMap() {
        this.setIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useHardCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useSoftIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useRemoteSoftIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useMethodInstantiationPolicy(String staticMethodName) {
        this.getInstantiationPolicy().useMethodInstantiationPolicy(staticMethodName);
    }

    public void useNoIdentityMap() {
        this.setIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteCacheIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useRemoteFullIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useRemoteHardCacheWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useRemoteNoIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteSoftCacheWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public void useRemoteWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    public void useSelectedFieldsLocking(Vector fieldNames) {
        SelectedFieldsLockingPolicy policy = new SelectedFieldsLockingPolicy();
        policy.setLockFieldNames(fieldNames);
        this.setOptimisticLockingPolicy(policy);
    }

    public boolean usesFieldLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof FieldsLockingPolicy;
    }

    public void useSoftCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public boolean usesOptimisticLocking() {
        return this.optimisticLockingPolicy != null;
    }

    public boolean usesVersionLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof VersionLockingPolicy;
    }

    public boolean usesSequenceNumbers() {
        return this.sequenceNumberField != null;
    }

    public void useTimestampLocking(String writeLockFieldName) {
        this.useTimestampLocking(writeLockFieldName, true);
    }

    public void useTimestampLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        TimestampLockingPolicy policy = new TimestampLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useVersionLocking(String writeLockFieldName) {
        this.useVersionLocking(writeLockFieldName, true);
    }

    public void useVersionLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        VersionLockingPolicy policy = new VersionLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    protected void validateAfterInitialization(AbstractSession session) {
        this.selfValidationAfterInitialization(session);
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            mappings.nextElement().validateAfterInitialization(session);
        }
    }

    protected void validateBeforeInitialization(AbstractSession session) {
        this.selfValidationBeforeInitialization(session);
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            mappings.nextElement().validateBeforeInitialization(session);
        }
    }

    protected void verifyTableQualifiers(Platform platform) {
        String tableQualifier = platform.getTableQualifier();
        if (tableQualifier.length() == 0) {
            return;
        }
        Enumeration<DatabaseTable> tableEnumeration = this.getTables().elements();
        while (tableEnumeration.hasMoreElements()) {
            DatabaseTable table = tableEnumeration.nextElement();
            if (table.getTableQualifier().length() != 0) continue;
            table.setTableQualifier(tableQualifier);
        }
    }

    public CMPPolicy getCMPPolicy() {
        return this.cmpPolicy;
    }

    public void setCMPPolicy(CMPPolicy newCMPPolicy) {
        this.cmpPolicy = newCMPPolicy;
        if (this.cmpPolicy != null) {
            this.cmpPolicy.setDescriptor(this);
        }
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.cmpPolicy != null && this.cmpPolicy.hasPessimisticLockingPolicy();
    }

    public FetchGroupManager getFetchGroupManager() {
        return this.fetchGroupManager;
    }

    public void setFetchGroupManager(FetchGroupManager fetchGroupManager) {
        this.fetchGroupManager = fetchGroupManager;
        if (fetchGroupManager != null) {
            fetchGroupManager.setDescriptor(this);
        }
    }

    public boolean isDescriptorForCMP() {
        return this.getCMPPolicy() != null;
    }

    public boolean hasFetchGroupManager() {
        return this.fetchGroupManager != null;
    }

    public boolean hasCascadeLockingPolicies() {
        return !this.cascadeLockingPolicies.isEmpty();
    }

    public boolean hasCMPPolicy() {
        return this.cmpPolicy != null;
    }

    public FetchGroup getDefaultFetchGroup() {
        if (!this.hasFetchGroupManager()) {
            return null;
        }
        return this.getFetchGroupManager().getDefaultFetchGroup();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return true;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    public void setIdValidation(IdValidation idValidation) {
        this.idValidation = idValidation;
    }

    public IdValidation getIdValidation() {
        return this.idValidation;
    }

    public QueryRedirector getDefaultQueryRedirector() {
        return this.defaultQueryRedirector;
    }

    public void setDefaultQueryRedirector(QueryRedirector defaultRedirector) {
        this.defaultQueryRedirector = defaultRedirector;
    }

    public QueryRedirector getDefaultReadAllQueryRedirector() {
        return this.defaultReadAllQueryRedirector;
    }

    public void setDefaultReadAllQueryRedirector(QueryRedirector defaultReadAllQueryRedirector) {
        this.defaultReadAllQueryRedirector = defaultReadAllQueryRedirector;
    }

    public QueryRedirector getDefaultReadObjectQueryRedirector() {
        return this.defaultReadObjectQueryRedirector;
    }

    public void setDefaultReadObjectQueryRedirector(QueryRedirector defaultReadObjectQueryRedirector) {
        this.defaultReadObjectQueryRedirector = defaultReadObjectQueryRedirector;
    }

    public QueryRedirector getDefaultReportQueryRedirector() {
        return this.defaultReportQueryRedirector;
    }

    public void setDefaultReportQueryRedirector(QueryRedirector defaultReportQueryRedirector) {
        this.defaultReportQueryRedirector = defaultReportQueryRedirector;
    }

    public QueryRedirector getDefaultUpdateObjectQueryRedirector() {
        return this.defaultUpdateObjectQueryRedirector;
    }

    public void setDefaultUpdateObjectQueryRedirector(QueryRedirector defaultUpdateQueryRedirector) {
        this.defaultUpdateObjectQueryRedirector = defaultUpdateQueryRedirector;
    }

    public QueryRedirector getDefaultInsertObjectQueryRedirector() {
        return this.defaultInsertObjectQueryRedirector;
    }

    public void setDefaultInsertObjectQueryRedirector(QueryRedirector defaultInsertQueryRedirector) {
        this.defaultInsertObjectQueryRedirector = defaultInsertQueryRedirector;
    }

    public QueryRedirector getDefaultDeleteObjectQueryRedirector() {
        return this.defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultDeleteObjectQueryRedirector(QueryRedirector defaultDeleteObjectQueryRedirector) {
        this.defaultDeleteObjectQueryRedirector = defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultQueryRedirectorClassName(String defaultQueryRedirectorClassName) {
        this.defaultQueryRedirectorClassName = defaultQueryRedirectorClassName;
    }

    public void setDefaultReadAllQueryRedirectorClassName(String defaultReadAllQueryRedirectorClassName) {
        this.defaultReadAllQueryRedirectorClassName = defaultReadAllQueryRedirectorClassName;
    }

    public void setDefaultReadObjectQueryRedirectorClassName(String defaultReadObjectQueryRedirectorClassName) {
        this.defaultReadObjectQueryRedirectorClassName = defaultReadObjectQueryRedirectorClassName;
    }

    public void setDefaultReportQueryRedirectorClassName(String defaultReportQueryRedirectorClassName) {
        this.defaultReportQueryRedirectorClassName = defaultReportQueryRedirectorClassName;
    }

    public void setDefaultUpdateObjectQueryRedirectorClassName(String defaultUpdateObjectQueryRedirectorClassName) {
        this.defaultUpdateObjectQueryRedirectorClassName = defaultUpdateObjectQueryRedirectorClassName;
    }

    public void setDefaultInsertObjectQueryRedirectorClassName(String defaultInsertObjectQueryRedirectorClassName) {
        this.defaultInsertObjectQueryRedirectorClassName = defaultInsertObjectQueryRedirectorClassName;
    }

    public void setDefaultDeleteObjectQueryRedirectorClassName(String defaultDeleteObjectQueryRedirectorClassName) {
        this.defaultDeleteObjectQueryRedirectorClassName = defaultDeleteObjectQueryRedirectorClassName;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public List<DatabaseMapping> getMappingsPostCalculateChanges() {
        return this.mappingsPostCalculateChanges;
    }

    public boolean hasMappingsPostCalculateChanges() {
        return this.mappingsPostCalculateChanges != null;
    }

    public void addMappingsPostCalculateChanges(DatabaseMapping mapping) {
        if (this.mappingsPostCalculateChanges == null) {
            this.mappingsPostCalculateChanges = new ArrayList<DatabaseMapping>();
        }
        this.mappingsPostCalculateChanges.add(mapping);
    }

    public List<DatabaseMapping> getMappingsPostCalculateChangesOnDeleted() {
        return this.mappingsPostCalculateChangesOnDeleted;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.mappingsPostCalculateChangesOnDeleted != null;
    }

    public void addMappingsPostCalculateChangesOnDeleted(DatabaseMapping mapping) {
        if (this.mappingsPostCalculateChangesOnDeleted == null) {
            this.mappingsPostCalculateChangesOnDeleted = new ArrayList<DatabaseMapping>();
        }
        this.mappingsPostCalculateChangesOnDeleted.add(mapping);
    }
}

