/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;

public class IsolatedClientSessionIdentityMapAccessor
extends IdentityMapAccessor {
    public IsolatedClientSessionIdentityMapAccessor(AbstractSession session, IdentityMapManager identityMapManager) {
        super(session, identityMapManager);
    }

    public CacheKey acquireDeferredLock(Vector primaryKey, Class javaClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireDeferredLock(primaryKey, javaClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, javaClass, descriptor);
    }

    public CacheKey acquireLock(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireLock(primaryKey, domainClass, forMerge, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLock(primaryKey, domainClass, forMerge, descriptor);
    }

    public CacheKey acquireLockNoWait(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireLockNoWait(primaryKey, domainClass, forMerge, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, domainClass, forMerge, descriptor);
    }

    public CacheKey acquireLockWithWait(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor, int wait) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireLockWithWait(primaryKey, domainClass, forMerge, descriptor, wait);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLockWithWait(primaryKey, domainClass, forMerge, descriptor, wait);
    }

    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireReadLockOnCacheKey(primaryKey, domainClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireReadLockOnCacheKey(primaryKey, domainClass, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(primaryKey, domainClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireReadLockOnCacheKeyNoWait(primaryKey, domainClass, descriptor);
    }

    public boolean acquireWriteLock() {
        this.getIdentityMapManager().acquireWriteLock();
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireWriteLock();
    }

    public boolean containsKey(Vector key, Class theClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().containsKey(key, theClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().containsKey(key, theClass, descriptor);
    }

    public boolean containsObjectInIdentityMap(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    public Vector getClassesRegistered() {
        Vector results = this.getIdentityMapManager().getClassesRegistered();
        results.addAll(((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getClassesRegistered());
        return results;
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        if (this.session.getDescriptor(theClass).isIsolated()) {
            return this.getIdentityMapManager().getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, shouldReturnInvalidatedObjects);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, shouldReturnInvalidatedObjects);
    }

    public CacheKey getCacheKeyForObject(Vector primaryKey, Class myClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getCacheKeyForObject(primaryKey, myClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, myClass, descriptor);
    }

    public CacheKey getCacheKeyForObjectForLock(Vector primaryKey, Class myClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getCacheKeyForObjectForLock(primaryKey, myClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, myClass, descriptor);
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public IdentityMapManager getIdentityMapManager() {
        return this.identityMapManager;
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getIdentityMap(descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getIdentityMap(descriptor);
    }

    public Object getQueryResult(ReadQuery query, Vector parameters, boolean checkExpiry) {
        if (((IsolatedClientSession)this.session).isIsolatedQuery(query)) {
            return this.getIdentityMapManager().getQueryResult(query, parameters, checkExpiry);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getQueryResult(query, parameters, checkExpiry);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getWrapper(Vector primaryKey, Class theClass) {
        if (this.session.getDescriptor(theClass).isIsolated()) {
            return this.getIdentityMapManager().getWrapper(primaryKey, theClass);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWrapper(primaryKey, theClass);
    }

    public WriteLockManager getWriteLockManager() {
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWriteLockManager();
    }

    public Object getWriteLockValue(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().getWriteLockValue(primaryKey, theClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, theClass, descriptor);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().initializeAllIdentityMaps();
    }

    public void initializeIdentityMap(Class theClass) {
        this.getSession().log(2, "cache", "initialize_identitymap", theClass);
        if (this.session.getDescriptor(theClass).isIsolated()) {
            this.getIdentityMapManager().initializeIdentityMap(theClass);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().initializeIdentityMap(theClass);
        }
    }

    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        this.getSession().getCommitManager().reinitialize();
    }

    public void putQueryResult(ReadQuery query, Vector parameters, Object results) {
        if (((IsolatedClientSession)this.session).isIsolatedQuery(query)) {
            this.getIdentityMapManager().putQueryResult(query, parameters, results);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().putQueryResult(query, parameters, results);
        }
    }

    public void printIdentityMap(Class businessClass) {
        if (this.getSession().shouldLog(7, "cache")) {
            if (this.session.getDescriptor(businessClass).isIsolated()) {
                this.getIdentityMapManager().printIdentityMap(businessClass);
            } else {
                ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMap(businessClass);
            }
        }
    }

    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMaps();
        }
    }

    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(1, "cache")) {
            this.getIdentityMapManager().printLocks();
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMapLocks();
        }
    }

    public CacheKey internalPutInIdentityMap(Object domainObject, Vector key, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().putInIdentityMap(domainObject, key, writeLockValue, readTime, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().internalPutInIdentityMap(domainObject, key, writeLockValue, readTime, descriptor);
    }

    public void releaseWriteLock() {
        ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().releaseWriteLock();
        this.getIdentityMapManager().releaseWriteLock();
    }

    public Object removeFromIdentityMap(Vector key, Class theClass, ClassDescriptor descriptor, Object object) {
        if (descriptor.isIsolated()) {
            return this.getIdentityMapManager().removeFromIdentityMap(key, theClass, descriptor, object);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().removeFromIdentityMap(key, theClass, descriptor, object);
    }

    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    public void setWrapper(Vector primaryKey, Class theClass, Object wrapper) {
        if (this.getSession().getDescriptor(theClass).isIsolated()) {
            this.getIdentityMapManager().setWrapper(primaryKey, theClass, wrapper);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().setWrapper(primaryKey, theClass, wrapper);
        }
    }

    public void updateWriteLockValue(Vector primaryKey, Class theClass, Object writeLockValue) {
        if (this.getSession().getDescriptor(theClass).isIsolated()) {
            this.getIdentityMapManager().setWriteLockValue(primaryKey, theClass, writeLockValue);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().updateWriteLockValue(primaryKey, theClass, writeLockValue);
        }
    }
}

