/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;

public class JAXBListWrapper
extends ListWrapper {
    private JAXBValueStore jaxbValueStore;
    private DatabaseMapping mapping;
    private ContainerPolicy containerPolicy;
    private AbstractSession session;
    private Object elements;

    public JAXBListWrapper(JAXBValueStore theJAXBValueStore, SDOProperty theProperty) {
        super(theJAXBValueStore.getDataObject(), theProperty);
        this.jaxbValueStore = theJAXBValueStore;
        JAXBContext jaxbContext = (JAXBContext)this.jaxbValueStore.getJAXBHelperContext().getJAXBContext();
        this.session = jaxbContext.getXMLContext().getSession(this.jaxbValueStore.getEntity().getClass());
        this.mapping = this.jaxbValueStore.getJAXBMappingForProperty(theProperty);
        this.containerPolicy = this.mapping.getContainerPolicy();
        this.elements = this.mapping.getAttributeValueFromObject(this.jaxbValueStore.getEntity());
        if (this.elements == null) {
            this.elements = this.containerPolicy.containerInstance();
            this.mapping.setAttributeValueInObject(this.jaxbValueStore.getEntity(), this.elements);
        }
    }

    public JAXBListWrapper(JAXBValueStore theJAXBValueStore, SDOProperty theProperty, List list) {
        this(theJAXBValueStore, theProperty);
        this.elements = list;
    }

    private List getEmptyList() {
        if (this.containerPolicy == null) {
            return null;
        }
        return (List)this.containerPolicy.containerInstance();
    }

    public boolean add(Object item, boolean updateSequence) {
        if (item == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        Object itemToAdd = item;
        if (!this.property.getType().isDataType()) {
            itemToAdd = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item);
        }
        boolean result = this.containerPolicy.addInto(itemToAdd, this.elements, this.session);
        this.updateContainment(item, updateSequence);
        return result;
    }

    public void add(int index, Object item, boolean updateSequence) {
        if (item == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        if (index < 0 || index > this.size()) {
            return;
        }
        this.copyElements();
        Object itemToAdd = item;
        if (!this.property.getType().isDataType()) {
            itemToAdd = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item);
        }
        Vector v = this.containerPolicy.vectorFor(this.elements, this.session);
        v.add(index, itemToAdd);
        this.containerPolicy.clear(this.elements);
        for (Object next : v) {
            this.containerPolicy.addInto(next, this.elements, this.session);
        }
        this.updateContainment(item, updateSequence);
    }

    protected void copyElements() {
        if (this.isLogging() && !((SDOChangeSummary)this.dataObject.getChangeSummary()).isDirty(this)) {
            ((SDOChangeSummary)this.dataObject.getChangeSummary()).getOriginalElements().put(this, this.getCurrentElements());
        }
    }

    private boolean isLogging() {
        return this.dataObject != null && this.dataObject.getChangeSummary() != null && this.dataObject.getChangeSummary().isLogging();
    }

    public List getCurrentElements() {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session);
        }
        if (this.property.isContainment()) {
            return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session), this.property, (DataObject)this.jaxbValueStore.getDataObject());
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session));
    }

    public void setCurrentElements(List newElements) {
        if (newElements == null || newElements.size() == 0) {
            this.elements = this.containerPolicy.containerInstance();
        }
        this.elements = this.containerPolicy.containerInstance(newElements.size());
        List<Object> elementsToAdd = newElements;
        if (!this.property.getType().isDataType()) {
            elementsToAdd = this.jaxbValueStore.getJAXBHelperContext().unwrap((Collection<DataObject>)newElements);
        }
        for (int i = 0; i < newElements.size(); ++i) {
            if (this.property.getType().isDataType()) continue;
            this.containerPolicy.addInto(elementsToAdd.get(i), this.elements, this.session);
        }
        this.mapping.setAttributeValueInObject(this.jaxbValueStore.getEntity(), this.elements);
    }

    public void undoChanges(SDOChangeSummary cs) {
        if (null == cs) {
            return;
        }
        if (cs.isDirty(this)) {
            this.setCurrentElements((List)cs.getOriginalElements().get(this));
            cs.getOriginalElements().remove(this);
        }
    }

    public boolean remove(Object item, boolean fromDelete, boolean updateSequence) {
        this.copyElements();
        this.removeContainment(item, fromDelete, updateSequence);
        Object toRemove = item;
        if (!this.property.getType().isDataType()) {
            toRemove = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item);
        }
        return this.containerPolicy.removeFrom(toRemove, this.elements, this.session);
    }

    public boolean addAll(Collection items, boolean updateSequence) {
        if (items.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean modified = false;
        if (items != null && items.size() != 0) {
            modified = true;
            for (Object next : items) {
                if (!this.property.getType().isDataType()) {
                    next = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)next);
                }
                this.containerPolicy.addInto(next, this.elements, this.session);
            }
        }
        this.dataObject._getCurrentValueStore().setManyProperty(this.property, this);
        this.dataObject.updateContainment(this.property, items, updateSequence);
        this.updateSequence(this.property, items, updateSequence);
        return modified;
    }

    public boolean addAll(int position, Collection items, boolean updateSequence) {
        if (position < 0 || position > this.size()) {
            return false;
        }
        if (items == null || items.size() == 0) {
            return false;
        }
        if (items.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        boolean modified = true;
        this.copyElements();
        Vector v = this.containerPolicy.vectorFor(this.elements, this.session);
        List<Object> unwrappedItems = items;
        if (!this.property.getType().isDataType()) {
            unwrappedItems = this.jaxbValueStore.getJAXBHelperContext().unwrap((Collection<DataObject>)items);
        }
        v.addAll(position, unwrappedItems);
        this.containerPolicy.clear(this.elements);
        for (Object next : v) {
            this.containerPolicy.addInto(next, this.elements, this.session);
        }
        this.dataObject.updateContainment(this.property, items);
        this.updateSequence(this.property, items, updateSequence);
        return modified;
    }

    public int size() {
        return this.containerPolicy.sizeFor(this.elements);
    }

    public boolean isEmpty() {
        return this.containerPolicy.isEmpty(this.elements);
    }

    public boolean contains(Object item) {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.contains(item, this.elements, this.session);
        }
        return this.containerPolicy.contains(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item), this.elements, this.session);
    }

    public boolean containsAll(Collection items) {
        for (Object next : items) {
            if (this.contains(next)) continue;
            return false;
        }
        return true;
    }

    public Object remove(int index, boolean updateSequence) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        this.copyElements();
        Object toRemove = this.get(index);
        int occurrence = this.getOccurrenceIndex(toRemove);
        this.removeContainment(occurrence, toRemove, false, updateSequence);
        if (!this.property.getType().isDataType()) {
            toRemove = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)toRemove);
        }
        return this.containerPolicy.removeFrom(toRemove, this.elements, this.session);
    }

    public Object get(int index) {
        Object toReturn = this.containerPolicy.vectorFor(this.elements, this.session).elementAt(index);
        if (!this.property.getType().isDataType()) {
            toReturn = this.property.isContainment() ? this.jaxbValueStore.getJAXBHelperContext().wrap(toReturn, this.property, (DataObject)this.jaxbValueStore.getDataObject()) : this.jaxbValueStore.getJAXBHelperContext().wrap(toReturn);
        }
        return toReturn;
    }

    private int getOccurrenceIndex(Object element) {
        int occurrence = 0;
        boolean skipFirstOccurrence = true;
        Vector currentElements = this.containerPolicy.vectorFor(this.elements, this.session);
        int size = this.size();
        for (int position = 0; position < size; ++position) {
            Object searchIndexObject = currentElements.get(position);
            if (element != searchIndexObject) continue;
            if (skipFirstOccurrence) {
                skipFirstOccurrence = false;
                continue;
            }
            ++occurrence;
        }
        return occurrence;
    }

    public ListIterator listIterator() {
        List<Object> currentElements = this.containerPolicy.vectorFor(this.elements, this.session);
        if (!this.property.getType().isDataType()) {
            currentElements = this.jaxbValueStore.getJAXBHelperContext().wrap(currentElements);
        }
        return currentElements.listIterator();
    }

    public ListIterator listIterator(int position) {
        List<Object> currentElements = this.containerPolicy.vectorFor(this.elements, this.session);
        if (!this.property.getType().isDataType()) {
            currentElements = this.jaxbValueStore.getJAXBHelperContext().wrap(currentElements);
        }
        return currentElements.listIterator(position);
    }

    public int indexOf(Object item) {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session).indexOf(item);
        }
        return this.containerPolicy.vectorFor(this.elements, this.session).indexOf(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item));
    }

    public int lastIndexOf(Object item) {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session).lastIndexOf(item);
        }
        return this.containerPolicy.vectorFor(this.elements, this.session).lastIndexOf(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item));
    }

    public Object writeReplace() {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session);
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session));
    }

    public Iterator iterator() {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session).iterator();
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session)).iterator();
    }

    protected void updateContainment(Object item, boolean updateSequence) {
        XMLCompositeCollectionMapping compositeMapping;
        if (this.mapping.isAbstractCompositeCollectionMapping() && null != item && (compositeMapping = (XMLCompositeCollectionMapping)this.mapping).getContainerAccessor() != null) {
            Object itemEntity = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item);
            compositeMapping.getContainerAccessor().setAttributeValueInObject(itemEntity, this.jaxbValueStore.getEntity());
        }
        super.updateContainment(item, updateSequence);
    }
}

