/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartBatchedTransactionExtendedResult;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StartBatchedTransactionExtendedRequest
extends ExtendedRequest {
    public static final String START_BATCHED_TRANSACTION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.1";
    private static final long serialVersionUID = 7141543268276702748L;

    public StartBatchedTransactionExtendedRequest() {
        super(START_BATCHED_TRANSACTION_REQUEST_OID);
    }

    public StartBatchedTransactionExtendedRequest(Control[] controls) {
        super(START_BATCHED_TRANSACTION_REQUEST_OID, controls);
    }

    public StartBatchedTransactionExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        if (extendedRequest.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_TXN_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    public StartBatchedTransactionExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new StartBatchedTransactionExtendedResult(extendedResponse);
    }

    @Override
    public StartBatchedTransactionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public StartBatchedTransactionExtendedRequest duplicate(Control[] controls) {
        StartBatchedTransactionExtendedRequest r = new StartBatchedTransactionExtendedRequest(controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_START_BATCHED_TXN.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("StartBatchedTransactionExtendedRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    static {
        Object c1 = null;
        Object c2 = null;
        Object c3 = null;
        Object c4 = null;
        Object var4_4 = null;
    }
}

