/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.domain.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.domain.factory.ITransactionalEditingDomainFactoryListener;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractResourceSetListenerInstaller<T extends ResourceSetListenerImpl>
implements ITransactionalEditingDomainFactoryListener {
    private Class<T> resourceSetListenerType;
    private Map<TransactionalEditingDomain, T> resourceSetListeners = new HashMap<TransactionalEditingDomain, T>();

    public AbstractResourceSetListenerInstaller(Class<T> resourceSetListenerType) {
        Assert.isNotNull(resourceSetListenerType);
        this.resourceSetListenerType = resourceSetListenerType;
    }

    protected T createResourceSetListener() {
        try {
            return (T)((ResourceSetListenerImpl)this.resourceSetListenerType.newInstance());
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return null;
        }
    }

    @Override
    public void postCreateEditingDomain(TransactionalEditingDomain editingDomain) {
        if (this.resourceSetListeners.containsKey(editingDomain)) {
            return;
        }
        T listener = this.createResourceSetListener();
        if (listener != null) {
            editingDomain.addResourceSetListener(listener);
            this.resourceSetListeners.put(editingDomain, listener);
        }
    }

    @Override
    public void preDisposeEditingDomain(TransactionalEditingDomain editingDomain) {
        ResourceSetListenerImpl listener = (ResourceSetListenerImpl)this.resourceSetListeners.get(editingDomain);
        if (listener != null) {
            editingDomain.removeResourceSetListener((ResourceSetListener)listener);
            this.resourceSetListeners.remove(editingDomain);
        }
    }
}

