/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.BasicWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.IWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.util.WorkflowRunnerActionHandlerHelper;
import org.eclipse.sphinx.platform.jobs.WorkspaceOperationWorkspaceJob;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.ui.operations.RunnableWithProgressAdapter;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicWorkflowRunnerAction
extends BaseSelectionListenerAction {
    private boolean runInBackground;
    protected WorkflowRunnerActionHandlerHelper helper;

    public BasicWorkflowRunnerAction() {
        this(Messages.action_runWorkflow_label);
    }

    public BasicWorkflowRunnerAction(String text) {
        super(text);
        this.setRunInBackground(false);
        this.helper = new WorkflowRunnerActionHandlerHelper();
    }

    public boolean isRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (this.helper.isWorkflow(this.getStructuredSelection())) {
            this.setText(Messages.action_runWorkflow_label);
            return true;
        }
        if (this.helper.isModel(this.getStructuredSelection())) {
            this.setText(String.valueOf(Messages.action_runWorkflow_label) + "...");
            return true;
        }
        return false;
    }

    public String getOperationName() {
        return Messages.operation_runWorkflow_label;
    }

    protected IWorkflowRunnerOperation createWorkflowRunnerOperation() {
        Object workflow = this.helper.getWorkflow(this.getStructuredSelection());
        if (workflow == null) {
            workflow = this.helper.promptForWorkflow(this.getStructuredSelection());
        }
        BasicWorkflowRunnerOperation operation = new BasicWorkflowRunnerOperation(this.getOperationName(), workflow);
        List<URI> modelURIs = this.helper.getModelURIs(this.getStructuredSelection());
        operation.getModelURIs().addAll(modelURIs);
        return operation;
    }

    protected WorkspaceJob createWorkspaceOperationJob(IWorkflowRunnerOperation operation) {
        return new WorkspaceOperationWorkspaceJob((IWorkspaceOperation)operation);
    }

    public void run() {
        ExtendedPlatformUI.showSystemConsole();
        IWorkflowRunnerOperation operation = this.createWorkflowRunnerOperation();
        if (this.isRunInBackground()) {
            WorkspaceJob job = this.createWorkspaceOperationJob(operation);
            job.schedule();
        } else {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ExtendedPlatformUI.getActiveShell());
                dialog.run(true, true, (IRunnableWithProgress)new RunnableWithProgressAdapter((IWorkspaceOperation)operation));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
    }
}

