/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.splitting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.sphinx.emf.resource.ModelResourceDescriptor;
import org.eclipse.sphinx.emf.splitting.IModelSplitDirective;
import org.eclipse.sphinx.emf.splitting.IModelSplitPolicy;

public class ModelSplitProcessor {
    protected IModelSplitPolicy modelSplitPolicy;
    private Collection<Resource> resourcesToSplit;
    private Collection<EObject> eObjectsToSplit;
    private Map<EObject, Map<URI, EObject>> originalToSplitEObjectsMap = new HashMap<EObject, Map<URI, EObject>>();
    private Map<EObject, EObject> eObjectToOriginalContainerMap = new HashMap<EObject, EObject>();
    private Map<URI, List<EObject>> targetResourceURIToContentsMap = new HashMap<URI, List<EObject>>();

    public ModelSplitProcessor(IModelSplitPolicy modelSplitPolicy) {
        Assert.isNotNull((Object)modelSplitPolicy);
        this.modelSplitPolicy = modelSplitPolicy;
    }

    protected EObject getSplitEObject(EObject originalEObject, URI targetResourceURI) {
        Map<URI, EObject> targetResourceURIToSplitEObjectsMap = this.originalToSplitEObjectsMap.get(originalEObject);
        if (targetResourceURIToSplitEObjectsMap != null) {
            return targetResourceURIToSplitEObjectsMap.get(targetResourceURI);
        }
        return null;
    }

    protected void addSplitEObject(EObject originalEObject, EObject splitEObject, URI targetResourceURI) {
        Map<URI, EObject> targetResourceURIToSplitEObjectsMap = this.originalToSplitEObjectsMap.get(originalEObject);
        if (targetResourceURIToSplitEObjectsMap == null) {
            targetResourceURIToSplitEObjectsMap = new HashMap<URI, EObject>();
            this.originalToSplitEObjectsMap.put(originalEObject, targetResourceURIToSplitEObjectsMap);
        }
        targetResourceURIToSplitEObjectsMap.put(targetResourceURI, splitEObject);
    }

    protected void addOriginalContainer(EObject eObject, EObject originalContainer) {
        this.eObjectToOriginalContainerMap.put(eObject, originalContainer);
    }

    protected EObject getOriginalContainer(EObject eObject) {
        EObject originalContainer = this.eObjectToOriginalContainerMap.get(eObject);
        return originalContainer != null ? originalContainer : ((InternalEObject)eObject).eInternalContainer();
    }

    protected List<EObject> getTargetResourceContents(URI targetResourceURI) {
        List<EObject> targetResourceContents = this.targetResourceURIToContentsMap.get(targetResourceURI);
        if (targetResourceContents == null) {
            targetResourceContents = new ArrayList<EObject>();
            this.targetResourceURIToContentsMap.put(targetResourceURI, targetResourceContents);
        }
        return targetResourceContents;
    }

    public Collection<Resource> getResourcesToSplit() {
        if (this.resourcesToSplit == null) {
            this.resourcesToSplit = new ArrayList<Resource>();
        }
        return this.resourcesToSplit;
    }

    public Collection<EObject> getEObjectsToSplit() {
        if (this.eObjectsToSplit == null) {
            this.eObjectsToSplit = new ArrayList<EObject>();
        }
        return this.eObjectsToSplit;
    }

    public void run(IProgressMonitor monitor) {
        Collection<Resource> resourcesToSplit = this.getResourcesToSplit();
        Collection<EObject> eObjectsToSplit = this.getEObjectsToSplit();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(resourcesToSplit.size() + eObjectsToSplit.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.splitResources(resourcesToSplit, (IProgressMonitor)progress.newChild(resourcesToSplit.size()));
        this.splitEObjects(eObjectsToSplit, (IProgressMonitor)progress.newChild(eObjectsToSplit.size()));
    }

    protected void splitResources(Collection<Resource> resources, IProgressMonitor monitor) {
        Assert.isNotNull(resources);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (Resource resource : resources) {
            this.splitEObjects((Collection<EObject>)resource.getContents(), (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    protected void splitEObjects(Collection<EObject> eObjects, IProgressMonitor monitor) {
        Assert.isNotNull(eObjects);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        List<IModelSplitDirective> directives = this.collectSplitDirectives(eObjects, (IProgressMonitor)progress.newChild(25));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.processSplitDirectives(directives, (IProgressMonitor)progress.newChild(75));
    }

    public Map<URI, List<EObject>> getSplitModelContents() {
        return Collections.unmodifiableMap(this.targetResourceURIToContentsMap);
    }

    public Collection<ModelResourceDescriptor> getSplitResourceDescriptors() {
        ArrayList<ModelResourceDescriptor> descriptors = new ArrayList<ModelResourceDescriptor>(this.targetResourceURIToContentsMap.keySet().size());
        for (URI uri : this.targetResourceURIToContentsMap.keySet()) {
            List<EObject> contents = this.targetResourceURIToContentsMap.get(uri);
            if (contents == null || contents.isEmpty()) continue;
            String contentTypeId = this.modelSplitPolicy.getContentTypeId(contents);
            descriptors.add(new ModelResourceDescriptor(uri, contentTypeId, contents));
        }
        return Collections.unmodifiableList(descriptors);
    }

    protected List<IModelSplitDirective> collectSplitDirectives(Collection<EObject> eObjects, IProgressMonitor monitor) {
        Assert.isNotNull(eObjects);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * eObjects.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ArrayList<IModelSplitDirective> directives = new ArrayList<IModelSplitDirective>();
        for (EObject eObject : eObjects) {
            TreeIterator iterator = eObject.eAllContents();
            while (iterator.hasNext()) {
                IModelSplitDirective directive = this.modelSplitPolicy.getSplitDirective((EObject)iterator.next());
                if (directive == null) continue;
                directives.add(directive);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return directives;
    }

    protected void processSplitDirectives(List<IModelSplitDirective> directives, IProgressMonitor monitor) {
        Assert.isNotNull(directives);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)directives.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IModelSplitDirective directive : directives) {
            if (directive.isValid()) {
                EObject eObject = directive.getEObject();
                URI targetResourceURI = directive.getTargetResourceURI();
                this.addSplitEObject(eObject, eObject, targetResourceURI);
                this.addOriginalContainer(eObject, eObject.eContainer());
                ArrayList<InternalEObject> ancestors = new ArrayList<InternalEObject>();
                InternalEObject container = ((InternalEObject)eObject).eInternalContainer();
                while (container != null) {
                    ancestors.add(container);
                    if (this.getSplitEObject((EObject)container, targetResourceURI) != null) break;
                    container = this.getOriginalContainer((EObject)container);
                }
                EObject lastEObject = eObject;
                EObject lastSplitEObject = eObject;
                boolean newSplitAncestor = true;
                for (EObject eObject2 : ancestors) {
                    EStructuralFeature containingFeature;
                    EObject splitAncestor = null;
                    splitAncestor = this.getSplitEObject(eObject2, targetResourceURI);
                    if (splitAncestor == null) {
                        splitAncestor = this.copyAncestor(eObject2, directive);
                        this.addSplitEObject(eObject2, splitAncestor, targetResourceURI);
                        if (((InternalEObject)eObject2).eInternalContainer() == null) {
                            List<EObject> targetResourceContents = this.getTargetResourceContents(targetResourceURI);
                            targetResourceContents.add(splitAncestor);
                        }
                    } else {
                        newSplitAncestor = false;
                    }
                    if ((containingFeature = lastEObject.eContainingFeature()) == null) {
                        throw new RuntimeException("Containing feature of '" + lastEObject + "' not found");
                    }
                    if (containingFeature.isMany()) {
                        List values = (List)splitAncestor.eGet(containingFeature);
                        values.add(lastSplitEObject);
                    } else {
                        splitAncestor.eSet(containingFeature, (Object)lastSplitEObject);
                    }
                    if (!newSplitAncestor) break;
                    lastEObject = eObject2;
                    lastSplitEObject = splitAncestor;
                }
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    protected <T extends EObject> T copyAncestor(T ancestor, IModelSplitDirective directive) {
        AncestorCopier copier = new AncestorCopier(ancestor, directive);
        EObject copiedAncestor = copier.copy(ancestor);
        copier.copyReferences();
        EObject t = copiedAncestor;
        return (T)t;
    }

    public void dispose() {
        this.originalToSplitEObjectsMap.clear();
        this.eObjectToOriginalContainerMap.clear();
        this.targetResourceURIToContentsMap.clear();
    }

    protected static class AncestorCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        protected EObject ancestor;
        protected IModelSplitDirective modelSplitDirective;

        public AncestorCopier(EObject ancestor, IModelSplitDirective modelSplitDirective) {
            Assert.isNotNull((Object)ancestor);
            Assert.isNotNull((Object)modelSplitDirective);
            this.ancestor = ancestor;
            this.modelSplitDirective = modelSplitDirective;
        }

        public EObject copy(EObject eObject) {
            if (eObject == null) {
                return null;
            }
            EObject copiedEObject = this.createCopy(eObject);
            if (copiedEObject != null) {
                this.put(eObject, copiedEObject);
                for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                    if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived() || eObject == this.ancestor && !this.modelSplitDirective.shouldReplicateAncestorFeature(eObject, eStructuralFeature)) continue;
                    if (eStructuralFeature instanceof EAttribute) {
                        EAttribute eAttribute = (EAttribute)eStructuralFeature;
                        this.copyAttribute(eAttribute, eObject, copiedEObject);
                        continue;
                    }
                    EReference eReference = (EReference)eStructuralFeature;
                    if (!eReference.isContainment()) continue;
                    this.copyContainment(eReference, eObject, copiedEObject);
                }
                this.copyProxyURI(eObject, copiedEObject);
            }
            return copiedEObject;
        }

        protected void copyFeatureMap(FeatureMap featureMap) {
            int i = 0;
            int size = featureMap.size();
            while (i < size) {
                Object value;
                EStructuralFeature feature = featureMap.getEStructuralFeature(i);
                if (feature instanceof EReference && ((EReference)feature).isContainment() && this.modelSplitDirective.shouldReplicateAncestorFeature(((FeatureMap.Internal)featureMap).getEObject(), feature) && (value = featureMap.getValue(i)) != null) {
                    this.copy((EObject)value);
                }
                ++i;
            }
        }
    }
}

