/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.jdt.loaders;

import com.google.common.base.Objects;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class DelegatingCompositeBundleClassLoader
extends SecureClassLoader {
    private List<Bundle> bundles;
    private List<ClassLoader> bundleClassLoaders = null;

    public DelegatingCompositeBundleClassLoader(ClassLoader parent, List<Bundle> bundles) {
        super(parent);
        Assert.isNotNull(bundles);
        this.bundles = bundles;
    }

    public List<ClassLoader> getBundleClassLoaders() {
        List<ClassLoader> _xblockexpression = null;
        boolean _equals = Objects.equal(this.bundleClassLoaders, null);
        if (_equals) {
            List _list;
            Functions.Function1<Bundle, BundleWiring> _function = new Functions.Function1<Bundle, BundleWiring>(){

                public BundleWiring apply(Bundle it) {
                    return (BundleWiring)it.adapt(BundleWiring.class);
                }
            };
            List _map = ListExtensions.map(this.bundles, (Functions.Function1)_function);
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
            Functions.Function1<BundleWiring, ClassLoader> _function_1 = new Functions.Function1<BundleWiring, ClassLoader>(){

                public ClassLoader apply(BundleWiring it) {
                    return it.getClassLoader();
                }
            };
            Iterable _map_1 = IterableExtensions.map((Iterable)_filterNull, (Functions.Function1)_function_1);
            this.bundleClassLoaders = _list = IterableExtensions.toList((Iterable)_map_1);
        }
        _xblockexpression = this.bundleClassLoaders;
        return _xblockexpression;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        List<ClassLoader> _bundleClassLoaders = this.getBundleClassLoaders();
        for (ClassLoader bundleClassLoader : _bundleClassLoaders) {
            try {
                Class<?> clazz = bundleClassLoader.loadClass(name);
                return clazz;
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable throwable = _t;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    public String toString() {
        Class<?> _class = this.getClass();
        String _name = _class.getName();
        String _plus = String.valueOf(_name) + " [bundles=";
        Object[] _array = this.bundles.toArray();
        String _string = Arrays.toString(_array);
        String _plus_1 = String.valueOf(_plus) + _string;
        return String.valueOf(_plus_1) + "]";
    }
}

