/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceEditingDomainDescriptor {
    public String name;
    private Set<URI> resourcesURIs;

    public ReferenceEditingDomainDescriptor(String editingDomainName) {
        this.name = editingDomainName;
        this.resourcesURIs = new HashSet<URI>();
    }

    public void addResourceURI(URI fileURI) {
        if (this.resourcesURIs != null && !this.resourcesURIs.contains(fileURI)) {
            this.resourcesURIs.add(fileURI);
        }
    }

    public Set<URI> getResourceURIs() {
        return this.resourcesURIs;
    }

    public boolean containsResource(String ResourceName) {
        for (URI uri : this.resourcesURIs) {
            String lastSegment = uri.lastSegment();
            if (lastSegment == null || !lastSegment.equals(ResourceName)) continue;
            return true;
        }
        return false;
    }

    public boolean matchResourceContentWith(TransactionalEditingDomain editingDomain) {
        ResourceSet resourceSet;
        int count = 0;
        if (editingDomain != null && editingDomain.getID().equals(this.name) && (resourceSet = editingDomain.getResourceSet()) != null) {
            EList resources = resourceSet.getResources();
            if (resources.isEmpty() && this.resourcesURIs.isEmpty()) {
                return true;
            }
            for (Resource resource : resources) {
                if (!this.resourcesURIs.contains(resource.getURI())) continue;
                ++count;
            }
            if (count == this.resourcesURIs.size()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

