/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.serialization.generators.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.generators.util.IGeneratorConstants;

public class Ecore2XSDUtil {
    static XMLPersistenceMappingExtendedMetaData metadata = XMLPersistenceMappingExtendedMetaData.INSTANCE;
    static Comparator<EClassifier> xmlNameComparator = new Comparator<EClassifier>(){

        @Override
        public int compare(EClassifier first, EClassifier second) {
            return metadata.getXMLName(first).compareTo(metadata.getXMLName(second));
        }
    };

    public static List<EClass> findAllConcreteTypes(EClass eClass, List<EPackage> additionalSearchScope) {
        ArrayList<EClass> concreteTypes = new ArrayList<EClass>();
        if (eClass != null) {
            ArrayList<EPackage> searchScope = new ArrayList<EPackage>();
            searchScope.add((EPackage)EcoreUtil.getRootContainer((EObject)eClass));
            if (additionalSearchScope != null) {
                searchScope.addAll(additionalSearchScope);
            }
            if (!eClass.isAbstract()) {
                concreteTypes.add(eClass);
            }
            for (EPackage searchPackage : searchScope) {
                concreteTypes.addAll(Ecore2XSDUtil.findESubTypesOf(eClass, searchPackage, true));
            }
            Collections.sort(concreteTypes, xmlNameComparator);
        }
        return concreteTypes;
    }

    public static List<EClass> findESubTypesOf(EClass eClass) {
        ArrayList<EClass> subTypes = new ArrayList<EClass>();
        EPackage rootEPackage = (EPackage)EcoreUtil.getRootContainer((EObject)eClass);
        subTypes.addAll(Ecore2XSDUtil.findESubTypesOf(eClass, rootEPackage, true));
        return subTypes;
    }

    public static List<EClass> findESubTypesOf(EClass eClass, EPackage ePackage, boolean concreteTypesOnly) {
        ArrayList<EClass> subTypes = new ArrayList<EClass>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass otherEClass;
            if (!(eClassifier instanceof EClass) || !eClass.isSuperTypeOf(otherEClass = (EClass)eClassifier) || eClass == otherEClass || (otherEClass.isAbstract() || otherEClass.isInterface()) && concreteTypesOnly) continue;
            subTypes.add(otherEClass);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            subTypes.addAll(Ecore2XSDUtil.findESubTypesOf(eClass, subPackage, concreteTypesOnly));
        }
        return subTypes;
    }

    public static boolean isIgnoredAnnotationSource(String sourceURI) {
        return "http://www.eclipse.org/emf/2002/Ecore".equals(sourceURI) || "http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals(sourceURI) || "http://www.eclipse.org/emf/2002/GenModel".equals(sourceURI);
    }

    public static String getURI(ExtendedMetaData extendedMetaData, EStructuralFeature eStructuralFeature) {
        String namespace = extendedMetaData.getNamespace(eStructuralFeature);
        String name = extendedMetaData.getName(eStructuralFeature);
        if ("http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
            namespace = "http://www.w3.org/2001/XMLSchema";
        }
        String result = name;
        if (namespace != null) {
            result = String.valueOf(namespace) + "#" + name;
        }
        return result;
    }

    public static List<EClassifier> getGlobalElements(EPackage rootPackage) {
        ArrayList<EClassifier> globalElements = new ArrayList<EClassifier>();
        for (EClassifier eClassifier : rootPackage.getEClassifiers()) {
            if (!metadata.isXMLGlobalElement(eClassifier) || !Ecore2XSDUtil.isConcrete(eClassifier)) continue;
            globalElements.add(eClassifier);
        }
        for (EPackage ePackage : rootPackage.getESubpackages()) {
            globalElements.addAll(Ecore2XSDUtil.getGlobalElements(ePackage));
        }
        Collections.sort(globalElements, xmlNameComparator);
        return globalElements;
    }

    public static String handlePrefix(Map<String, String> namespaces, String preferredPrefix, String namespace) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        String value = namespaces.get(preferredPrefix);
        if (namespace == null ? value == null : namespace.equals(value)) {
            return preferredPrefix;
        }
        if (value != null || "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                if (!(namespace == null ? entry.getValue() == null : namespace.equals(entry.getValue()))) continue;
                return entry.getKey();
            }
        }
        String uniquePrefix = preferredPrefix;
        int i = 0;
        while (namespaces.containsKey(uniquePrefix)) {
            uniquePrefix = String.valueOf(preferredPrefix) + "_" + i;
            ++i;
        }
        String namespaceKey = null;
        if (!"".equals(uniquePrefix)) {
            namespaceKey = uniquePrefix;
        }
        namespaces.put(namespaceKey, namespace);
        return uniquePrefix;
    }

    public static Boolean isCustomSimpleType(EDataType eDataType) {
        if (XMLPersistenceMappingExtendedMetaData.INSTANCE.getXMLCustomSimpleType((EClassifier)eDataType).equals(IGeneratorConstants.BOOLEAN_TRUE)) {
            return true;
        }
        return false;
    }

    public static String getNsPrefixFromQNamePrefixToNamespaceMap(Map<String, String> namespaces, String ns) {
        if (namespaces.containsValue(ns)) {
            for (String prefix : namespaces.keySet()) {
                if (!namespaces.get(prefix).equals(ns)) continue;
                return prefix;
            }
        }
        return null;
    }

    public static String getSingularName(ENamedElement element) {
        EReference ref;
        String suffixSingualr = "";
        if (element instanceof EReference && !(ref = (EReference)element).isContainment()) {
            suffixSingualr = "-REF";
        }
        return String.valueOf(Ecore2XSDUtil.buildXmlName(element.getName())) + suffixSingualr;
    }

    public static String getPluralName(ENamedElement element) {
        EReference ref;
        String suffixPlural = "S";
        if (element instanceof EReference && !(ref = (EReference)element).isContainment()) {
            suffixPlural = "-REFS";
        }
        return String.valueOf(Ecore2XSDUtil.buildXmlName(element.getName())) + suffixPlural;
    }

    public static boolean hasConcreteSubclasses(EClass eClass, EPackage model) {
        TreeIterator iterator = model.eAllContents();
        while (iterator.hasNext()) {
            EClass potentialSubclass;
            EObject element = (EObject)iterator.next();
            if (!(element instanceof EClass) || (potentialSubclass = (EClass)element).isAbstract() || !potentialSubclass.getESuperTypes().contains((Object)eClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConcrete(EClassifier eClassifier) {
        EClass eClass;
        boolean isConcrete = true;
        if (eClassifier instanceof EClass && (eClass = (EClass)eClassifier).isAbstract()) {
            isConcrete = false;
        }
        return isConcrete;
    }

    public static String buildXmlName(String camelName) {
        LinkedList<?> nameSegments = Ecore2XSDUtil.getCamelNameSegments(camelName);
        Iterator segIter = nameSegments.iterator();
        boolean isFirst = true;
        String xmlName = new String();
        while (segIter.hasNext()) {
            if (!isFirst) {
                xmlName = String.valueOf(xmlName) + "-";
            } else {
                isFirst = false;
            }
            xmlName = String.valueOf(xmlName) + ((String)segIter.next()).toUpperCase();
        }
        return xmlName;
    }

    private static LinkedList<?> getCamelNameSegments(String camelName) {
        if (camelName == null || camelName.length() == 0) {
            return null;
        }
        LinkedList<String> segmentList = new LinkedList<String>();
        String segment = new String();
        segment = String.valueOf(segment) + camelName.charAt(0);
        boolean wasDigit = false;
        boolean wasNotLetterOrDigit = false;
        int i = 1;
        while (i < camelName.length()) {
            char c = camelName.charAt(i);
            boolean isLetter = Character.isLetter(c);
            boolean isUpperCase = Character.isUpperCase(c);
            if ((!isLetter || isUpperCase || wasDigit || wasNotLetterOrDigit) && segment.length() > 0) {
                segmentList.add(segment);
                segment = new String();
            }
            segment = String.valueOf(segment) + c;
            wasDigit = Character.isDigit(c);
            wasNotLetterOrDigit = !isLetter && !wasDigit;
            ++i;
        }
        if (segment.length() > 0) {
            segmentList.add(segment);
        }
        ListIterator<String> segmentIter = segmentList.listIterator(segmentList.size());
        String segment2 = (String)segmentIter.previous();
        while (segmentIter.hasPrevious()) {
            String segment1 = (String)segmentIter.previous();
            char c = segment1.charAt(0);
            if (!Character.isDigit(c) && !Character.isLetter(c)) {
                segmentIter.remove();
                segment2 = segment1;
                continue;
            }
            char d = segment2.charAt(segment2.length() - 1);
            boolean doLink = Character.isUpperCase(c) && Character.isUpperCase(d);
            if (segment1.length() == 1 && (doLink |= Character.isDigit(c) && Character.isDigit(d))) {
                segment2 = String.valueOf(segment1) + segment2;
                segmentIter.remove();
                segmentIter.next();
                segmentIter.set(segment2);
                segmentIter.previous();
                continue;
            }
            segment2 = segment1;
        }
        return segmentList;
    }
}

