/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.ui.Activator;
import org.eclipse.sphinx.emf.validation.ui.views.ActionProblemProperties;
import org.eclipse.sphinx.emf.validation.ui.views.ActionResolveMarker;
import org.eclipse.sphinx.emf.validation.ui.views.CategoryComparator;
import org.eclipse.sphinx.emf.validation.ui.views.DialogMarkerFilter;
import org.eclipse.sphinx.emf.validation.ui.views.DialogProblemFilter;
import org.eclipse.sphinx.emf.validation.ui.views.FieldCategory;
import org.eclipse.sphinx.emf.validation.ui.views.FieldCreationTime;
import org.eclipse.sphinx.emf.validation.ui.views.FieldEObject;
import org.eclipse.sphinx.emf.validation.ui.views.FieldEObjectType;
import org.eclipse.sphinx.emf.validation.ui.views.FieldEObjectURI;
import org.eclipse.sphinx.emf.validation.ui.views.FieldId;
import org.eclipse.sphinx.emf.validation.ui.views.FieldMarkerGroup;
import org.eclipse.sphinx.emf.validation.ui.views.FieldResource;
import org.eclipse.sphinx.emf.validation.ui.views.FieldRuleId;
import org.eclipse.sphinx.emf.validation.ui.views.FieldSeverityAndMessage;
import org.eclipse.sphinx.emf.validation.ui.views.IField;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerFilter;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerList;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSupportRegistry;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerView;
import org.eclipse.sphinx.emf.validation.ui.views.ProblemFilter;
import org.eclipse.sphinx.emf.validation.ui.views.TableComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ValidationView
extends MarkerView {
    private static final String[] ROOT_TYPES = new String[]{"sphinx.emf.validation.problem.marker", "org.eclipse.core.resources.problemmarker"};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.sphinx.emf.validation.ui";
    private static final String TAG_SYSTEM_FILTER_ENTRY = "systemFilter";
    private ActionResolveMarker resolveMarkerAction;
    private IHandlerService handlerService;
    private IHandlerActivation resolveMarkerHandlerActivation;
    private IActivityManagerListener activityManagerListener;
    private IField severityAndMessage = new FieldSeverityAndMessage();
    private IField eObject = new FieldEObject();
    private IField eObjectURI = new FieldEObjectURI();
    private IField eObjectType = new FieldEObjectType();
    private IField resource = new FieldResource();
    private IField ruleId = new FieldRuleId();
    private IField creationTime = new FieldCreationTime();
    private static IField id = new FieldId();

    public ValidationView() {
        this.creationTime.setShowing(true);
    }

    @Override
    public void dispose() {
        if (this.resolveMarkerAction != null) {
            this.resolveMarkerAction.dispose();
        }
        if (this.resolveMarkerHandlerActivation != null && this.handlerService != null) {
            this.handlerService.deactivateHandler(this.resolveMarkerHandlerActivation);
        }
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener(this.activityManagerListener);
        super.dispose();
    }

    @Override
    protected IField[] getSortingFields() {
        return new IField[]{this.severityAndMessage, this.eObject, this.eObjectURI, this.resource, this.eObjectType, this.ruleId, this.creationTime, id};
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.propertiesAction = new ActionProblemProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.resolveMarkerAction = new ActionResolveMarker(this, (ISelectionProvider)this.getViewer());
    }

    @Override
    protected void registerGlobalActions(IActionBars actionBars) {
        super.registerGlobalActions(actionBars);
        String quickFixId = "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals";
        this.resolveMarkerAction.setActionDefinitionId(quickFixId);
        this.handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        if (this.handlerService != null) {
            this.resolveMarkerHandlerActivation = this.handlerService.activateHandler(quickFixId, (IHandler)new ActionHandler((IAction)this.resolveMarkerAction));
        }
    }

    @Override
    protected void fillContextMenuAdditions(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resolveMarkerAction);
    }

    @Override
    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    @Override
    protected IField[] getAllFields() {
        return new IField[]{this.severityAndMessage, this.eObject, this.eObjectURI, this.resource, this.eObjectType, this.ruleId, this.creationTime};
    }

    @Override
    void updateTitle() {
        int totalCount;
        MarkerList visibleMarkers = this.getVisibleMarkers();
        String breakdown = this.formatSummaryBreakDown(visibleMarkers);
        int filteredCount = visibleMarkers.getItemCount();
        if (filteredCount != (totalCount = this.getTotalMarkers())) {
            breakdown = NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Object[]{breakdown, new Integer(filteredCount), new Integer(totalCount)});
        }
        this.setContentDescription(breakdown);
    }

    private String formatSummaryBreakDown(MarkerList visibleMarkers) {
        return MessageFormat.format((String)MarkerMessages.problem_statusSummaryBreakdown, (Object[])new Object[]{new Integer(visibleMarkers.getErrors()), new Integer(visibleMarkers.getWarnings()), new Integer(visibleMarkers.getInfos())});
    }

    private String getSummary(MarkerList markers) {
        String message = MessageFormat.format((String)MarkerMessages.marker_statusSummarySelected, (Object[])new Object[]{new Integer(markers.getItemCount()), this.formatSummaryBreakDown(markers)});
        return message;
    }

    @Override
    protected String updateSummarySelected(IStructuredSelection selection) {
        ArrayList<MarkerNode> selectionList = new ArrayList<MarkerNode>();
        for (MarkerNode next : selection) {
            if (!next.isConcrete()) continue;
            selectionList.add(next);
        }
        return this.getSummary(new MarkerList(selectionList));
    }

    @Override
    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    @Override
    protected String getStaticContextId() {
        return "org.eclipse.ui.problem_view_context";
    }

    @Override
    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] filters = this.getUserFilters();
        ProblemFilter[] problemFilters = new ProblemFilter[filters.length];
        System.arraycopy(filters, 0, problemFilters, 0, filters.length);
        return new DialogProblemFilter(this.getSite().getShell(), problemFilters);
    }

    @Override
    protected MarkerFilter createFilter(String name) {
        return new ProblemFilter(name);
    }

    @Override
    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    @Override
    String getMarkerEnablementPreferenceName() {
        return "LIMIT_PROBLEMS";
    }

    @Override
    String getMarkerLimitPreferenceName() {
        return "PROBLEMS_LIMIT";
    }

    @Override
    String getFiltersPreferenceName() {
        return "PROBLEMS_FILTERS";
    }

    @Override
    MarkerFilter[] getAllFilters() {
        MarkerFilter[] userFilters = super.getAllFilters();
        Collection declaredFilters = MarkerSupportRegistry.getInstance().getRegisteredFilters();
        Iterator iterator = declaredFilters.iterator();
        MarkerFilter[] allFilters = new MarkerFilter[userFilters.length + declaredFilters.size()];
        System.arraycopy(userFilters, 0, allFilters, 0, userFilters.length);
        int index = userFilters.length;
        while (iterator.hasNext()) {
            allFilters[index] = (MarkerFilter)iterator.next();
            ++index;
        }
        return allFilters;
    }

    @Override
    void addDropDownContributions(IMenuManager menu) {
        MenuManager groupByMenu = new MenuManager(MarkerMessages.ProblemView_GroupByMenu);
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_EObject, new FieldEObject(), this));
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_EObjectType, new FieldEObjectType(), this));
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_Type, new FieldCategory(), this));
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_RuleId, new FieldRuleId(), this));
        for (Object o : MarkerSupportRegistry.getInstance().getMarkerGroups()) {
            FieldMarkerGroup group;
            if (!(o instanceof FieldMarkerGroup) || !(group = (FieldMarkerGroup)o).getId().equals("org.eclipse.ui.ide.severity")) continue;
            groupByMenu.add((IAction)new GroupingAction(group.getDescription(), group, this));
        }
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_None, null, this));
        menu.add((IContributionItem)groupByMenu);
        super.addDropDownContributions(menu);
    }

    protected void regenerateLayout() {
        ColumnPixelData[] columnWidths;
        TableLayout layout = new TableLayout();
        this.getViewer().getTree().setLayout((Layout)layout);
        ColumnPixelData[] columnPixelDataArray = columnWidths = this.getDefaultColumnLayouts();
        int n = columnWidths.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnPixelData element = columnPixelDataArray[n2];
            layout.addColumnData((ColumnLayoutData)element);
            ++n2;
        }
        this.getViewer().getTree().layout(true);
    }

    @Override
    void setComparator(TableComparator sorter2) {
        this.getMarkerAdapter().getCategorySorter().setTableSorter(sorter2);
        this.getMarkerAdapter().getCategorySorter().saveState(this.getDialogSettings());
        this.updateForNewComparator(sorter2);
    }

    @Override
    public TableComparator getTableSorter() {
        return ((CategoryComparator)this.getViewer().getComparator()).innerSorter;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActivityManagerListener();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this.activityManagerListener);
    }

    private void createActivityManagerListener() {
        this.activityManagerListener = new IActivityManagerListener(){

            public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                ValidationView.this.clearEnabledFilters();
                ValidationView.this.refreshViewer();
            }
        };
    }

    public IField findField(String description) {
        IField[] fields;
        IField[] iFieldArray = fields = this.getSortingFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField element = iFieldArray[n2];
            if (element.getDescription().equals(description)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected ViewerComparator buildComparator() {
        TableComparator sorter = this.createTableComparator();
        CategoryComparator category = new CategoryComparator(sorter);
        category.restoreState(this.getDialogSettings(), this);
        return category;
    }

    @Override
    boolean canBeEditable() {
        return false;
    }

    @Override
    protected void initToolBar(IToolBarManager tbm) {
        tbm.add(this.getFilterAction());
        tbm.update(false);
    }

    public void selectCategory(String description, CategoryComparator sorter) {
        if (description == null) {
            this.selectCategoryField(null, sorter);
        }
        if (description.equals(MarkerMessages.description_eObject)) {
            this.selectCategoryField(new FieldEObject(), sorter);
            return;
        }
        if (description.equals(MarkerMessages.description_eObjectType)) {
            this.selectCategoryField(new FieldEObjectType(), sorter);
            return;
        }
        if (description.equals(MarkerMessages.description_type)) {
            this.selectCategoryField(new FieldCategory(), sorter);
            return;
        }
        if (description.equals(MarkerMessages.description_ruleId)) {
            this.selectCategoryField(new FieldRuleId(), sorter);
            return;
        }
        for (IField group : MarkerSupportRegistry.getInstance().getMarkerGroups()) {
            if (!group.getDescription().equals(description)) continue;
            this.selectCategoryField(group, sorter);
            return;
        }
        this.selectCategoryField(null, sorter);
    }

    void selectCategoryField(IField groupingField, CategoryComparator sorter) {
        sorter.setCategoryField(groupingField);
        if (this.getMarkerAdapter() != null) {
            this.getMarkerAdapter().getCurrentMarkers().clearGroups();
            this.refreshViewer();
        }
    }

    @Override
    protected void writeFiltersSettings(XMLMemento memento) {
        super.writeFiltersSettings(memento);
        for (MarkerFilter filter : MarkerSupportRegistry.getInstance().getRegisteredFilters()) {
            IMemento child = memento.createChild(TAG_SYSTEM_FILTER_ENTRY, filter.getName());
            child.putString("enabled", String.valueOf(filter.isEnabled()));
        }
    }

    @Override
    void restoreFilters(IMemento memento) {
        super.restoreFilters(memento);
        if (memento == null) {
            return;
        }
        IMemento[] sections = memento.getChildren(TAG_SYSTEM_FILTER_ENTRY);
        Collection registered = MarkerSupportRegistry.getInstance().getRegisteredFilters();
        MarkerFilter[] filters = new MarkerFilter[registered.size()];
        registered.toArray(filters);
        if (sections != null) {
            IMemento[] iMementoArray = sections;
            int n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento element = iMementoArray[n2];
                String filterName = element.getID();
                boolean enabled = Boolean.valueOf(element.getString("enabled"));
                this.setEnablement(filterName, enabled, filters);
                ++n2;
            }
        }
    }

    private void setEnablement(String filterName, boolean enabled, MarkerFilter[] filters) {
        MarkerFilter[] markerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerFilter element = markerFilterArray[n2];
            if (element.getName().equals(filterName)) {
                element.setEnabled(enabled);
                return;
            }
            ++n2;
        }
    }

    @Override
    protected String getMarkerName() {
        return MarkerMessages.problem_title;
    }

    private class GroupingAction
    extends Action {
        IField groupingField;
        ValidationView problemView;

        public GroupingAction(String label, IField field, ValidationView view) {
            super(label, 8);
            this.groupingField = field;
            this.problemView = view;
            IField categoryField = view.getMarkerAdapter().getCategorySorter().getCategoryField();
            if (categoryField == null) {
                this.setChecked(this.groupingField == null);
            } else {
                boolean state = categoryField.equals(this.groupingField);
                if (this.groupingField != null) {
                    state |= categoryField.getDescription().equals(this.groupingField.getDescription());
                }
                this.setChecked(state);
            }
        }

        public void run() {
            if (this.isChecked()) {
                Job categoryJob = new Job(MarkerMessages.ProblemView_UpdateCategoryJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ((GroupingAction)GroupingAction.this).ValidationView.this.markerProcessJob.join();
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                        GroupingAction.this.problemView.selectCategoryField(GroupingAction.this.groupingField, GroupingAction.this.problemView.getMarkerAdapter().getCategorySorter());
                        ValidationView.this.getMarkerAdapter().getCategorySorter().saveState(ValidationView.this.getDialogSettings());
                        return Status.OK_STATUS;
                    }
                };
                categoryJob.setSystem(true);
                this.problemView.preserveSelection();
                IWorkbenchSiteProgressService progressService = ValidationView.this.getProgressService();
                if (progressService == null) {
                    categoryJob.schedule();
                } else {
                    ValidationView.this.getProgressService().schedule(categoryJob);
                }
            }
        }
    }
}

