/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;

public class CompositeValidator
implements EValidator {
    private List<EValidator> children = new ArrayList<EValidator>();

    public CompositeValidator() {
    }

    public CompositeValidator(EValidator delegate) {
        this();
        this.addChild(delegate);
    }

    public void addChild(EValidator delegate) {
        if (this == delegate) {
            return;
        }
        if (!this.children.contains(delegate)) {
            this.children.add(delegate);
        }
    }

    public void removeChild(EValidator delegate) {
        if (this == delegate) {
            return;
        }
        if (this.children.contains(delegate)) {
            this.children.remove(delegate);
        }
    }

    public List<EValidator> getChildren() {
        return this.children;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (EValidator validator : this.getChildren()) {
            boolean bl = result = result && validator.validate(eObject, diagnostics, context);
        }
        return result;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (EValidator validator : this.getChildren()) {
            boolean validate = validator.validate(eClass, eObject, diagnostics, context);
            boolean bl = result = result && validate;
        }
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (EValidator validator : this.getChildren()) {
            boolean validate = validator.validate(eDataType, value, diagnostics, context);
            boolean bl = result = result && validate;
        }
        return result;
    }
}

