/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.ITreeElementStateProvider;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class AbstractTreeElementStateProvider
implements ITreeElementStateProvider {
    protected TreeViewer viewer;

    public AbstractTreeElementStateProvider(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
    }

    protected boolean canGetChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (this.viewer instanceof CommonViewer) {
            Set contentExtensions = ((CommonViewer)this.viewer).getNavigatorContentService().findContentExtensionsByTriggerPoint(element);
            return !contentExtensions.isEmpty();
        }
        return true;
    }

    @Override
    public boolean isResolved() {
        if (this.hasUnderlyingModel() && !this.isUnderlyingModelLoaded()) {
            return !this.canUnderlyingModelBeLoaded();
        }
        if (this.isStale()) {
            return true;
        }
        return this.canGetChildren(this.getTreeElement());
    }

    @Override
    public boolean canBeExpanded() {
        if (this.isStale()) {
            return false;
        }
        Object element = this.getTreeElement();
        return element != null && this.viewer.isExpandable(element);
    }

    @Override
    public boolean isExpanded() {
        if (this.isStale()) {
            return false;
        }
        Object element = this.getTreeElement();
        return element != null && this.viewer.getExpandedState(element);
    }
}

